/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataflowEndpointGroupV2Request extends GroundStationRequest implements
        ToCopyableBuilder<CreateDataflowEndpointGroupV2Request.Builder, CreateDataflowEndpointGroupV2Request> {
    private static final SdkField<List<CreateEndpointDetails>> ENDPOINTS_FIELD = SdkField
            .<List<CreateEndpointDetails>> builder(MarshallingType.LIST)
            .memberName("endpoints")
            .getter(getter(CreateDataflowEndpointGroupV2Request::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateEndpointDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateEndpointDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> CONTACT_PRE_PASS_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("contactPrePassDurationSeconds")
            .getter(getter(CreateDataflowEndpointGroupV2Request::contactPrePassDurationSeconds))
            .setter(setter(Builder::contactPrePassDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPrePassDurationSeconds")
                    .build()).build();

    private static final SdkField<Integer> CONTACT_POST_PASS_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("contactPostPassDurationSeconds")
            .getter(getter(CreateDataflowEndpointGroupV2Request::contactPostPassDurationSeconds))
            .setter(setter(Builder::contactPostPassDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPostPassDurationSeconds")
                    .build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateDataflowEndpointGroupV2Request::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINTS_FIELD,
            CONTACT_PRE_PASS_DURATION_SECONDS_FIELD, CONTACT_POST_PASS_DURATION_SECONDS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CreateEndpointDetails> endpoints;

    private final Integer contactPrePassDurationSeconds;

    private final Integer contactPostPassDurationSeconds;

    private final Map<String, String> tags;

    private CreateDataflowEndpointGroupV2Request(BuilderImpl builder) {
        super(builder);
        this.endpoints = builder.endpoints;
        this.contactPrePassDurationSeconds = builder.contactPrePassDurationSeconds;
        this.contactPostPassDurationSeconds = builder.contactPostPassDurationSeconds;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Dataflow endpoint group's endpoint definitions
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return Dataflow endpoint group's endpoint definitions
     */
    public final List<CreateEndpointDetails> endpoints() {
        return endpoints;
    }

    /**
     * <p>
     * Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group will be in a
     * <code>PREPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when the
     * Dataflow Endpoint Group enters and exits the <code>PREPASS</code> state.
     * </p>
     * 
     * @return Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group will
     *         be in a <code>PREPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be
     *         emitted when the Dataflow Endpoint Group enters and exits the <code>PREPASS</code> state.
     */
    public final Integer contactPrePassDurationSeconds() {
        return contactPrePassDurationSeconds;
    }

    /**
     * <p>
     * Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will be in a
     * <code>POSTPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when the
     * Dataflow Endpoint Group enters and exits the <code>POSTPASS</code> state.
     * </p>
     * 
     * @return Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will be
     *         in a <code>POSTPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be
     *         emitted when the Dataflow Endpoint Group enters and exits the <code>POSTPASS</code> state.
     */
    public final Integer contactPostPassDurationSeconds() {
        return contactPostPassDurationSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags of a V2 dataflow endpoint group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags of a V2 dataflow endpoint group.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contactPrePassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(contactPostPassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataflowEndpointGroupV2Request)) {
            return false;
        }
        CreateDataflowEndpointGroupV2Request other = (CreateDataflowEndpointGroupV2Request) obj;
        return hasEndpoints() == other.hasEndpoints() && Objects.equals(endpoints(), other.endpoints())
                && Objects.equals(contactPrePassDurationSeconds(), other.contactPrePassDurationSeconds())
                && Objects.equals(contactPostPassDurationSeconds(), other.contactPostPassDurationSeconds())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataflowEndpointGroupV2Request").add("Endpoints", hasEndpoints() ? endpoints() : null)
                .add("ContactPrePassDurationSeconds", contactPrePassDurationSeconds())
                .add("ContactPostPassDurationSeconds", contactPostPassDurationSeconds()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "contactPrePassDurationSeconds":
            return Optional.ofNullable(clazz.cast(contactPrePassDurationSeconds()));
        case "contactPostPassDurationSeconds":
            return Optional.ofNullable(clazz.cast(contactPostPassDurationSeconds()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endpoints", ENDPOINTS_FIELD);
        map.put("contactPrePassDurationSeconds", CONTACT_PRE_PASS_DURATION_SECONDS_FIELD);
        map.put("contactPostPassDurationSeconds", CONTACT_POST_PASS_DURATION_SECONDS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataflowEndpointGroupV2Request, T> g) {
        return obj -> g.apply((CreateDataflowEndpointGroupV2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GroundStationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataflowEndpointGroupV2Request> {
        /**
         * <p>
         * Dataflow endpoint group's endpoint definitions
         * </p>
         * 
         * @param endpoints
         *        Dataflow endpoint group's endpoint definitions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<CreateEndpointDetails> endpoints);

        /**
         * <p>
         * Dataflow endpoint group's endpoint definitions
         * </p>
         * 
         * @param endpoints
         *        Dataflow endpoint group's endpoint definitions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(CreateEndpointDetails... endpoints);

        /**
         * <p>
         * Dataflow endpoint group's endpoint definitions
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.groundstation.model.CreateEndpointDetails.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.groundstation.model.CreateEndpointDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.groundstation.model.CreateEndpointDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #endpoints(List<CreateEndpointDetails>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.groundstation.model.CreateEndpointDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(java.util.Collection<CreateEndpointDetails>)
         */
        Builder endpoints(Consumer<CreateEndpointDetails.Builder>... endpoints);

        /**
         * <p>
         * Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group will be
         * in a <code>PREPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be emitted
         * when the Dataflow Endpoint Group enters and exits the <code>PREPASS</code> state.
         * </p>
         * 
         * @param contactPrePassDurationSeconds
         *        Amount of time, in seconds, before a contact starts that the Ground Station Dataflow Endpoint Group
         *        will be in a <code>PREPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event
         *        will be emitted when the Dataflow Endpoint Group enters and exits the <code>PREPASS</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds);

        /**
         * <p>
         * Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will be in a
         * <code>POSTPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will be emitted when
         * the Dataflow Endpoint Group enters and exits the <code>POSTPASS</code> state.
         * </p>
         * 
         * @param contactPostPassDurationSeconds
         *        Amount of time, in seconds, after a contact ends that the Ground Station Dataflow Endpoint Group will
         *        be in a <code>POSTPASS</code> state. A Ground Station Dataflow Endpoint Group State Change event will
         *        be emitted when the Dataflow Endpoint Group enters and exits the <code>POSTPASS</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds);

        /**
         * <p>
         * Tags of a V2 dataflow endpoint group.
         * </p>
         * 
         * @param tags
         *        Tags of a V2 dataflow endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private List<CreateEndpointDetails> endpoints = DefaultSdkAutoConstructList.getInstance();

        private Integer contactPrePassDurationSeconds;

        private Integer contactPostPassDurationSeconds;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataflowEndpointGroupV2Request model) {
            super(model);
            endpoints(model.endpoints);
            contactPrePassDurationSeconds(model.contactPrePassDurationSeconds);
            contactPostPassDurationSeconds(model.contactPostPassDurationSeconds);
            tags(model.tags);
        }

        public final List<CreateEndpointDetails.Builder> getEndpoints() {
            List<CreateEndpointDetails.Builder> result = CreateEndpointDetailsListCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<CreateEndpointDetails.BuilderImpl> endpoints) {
            this.endpoints = CreateEndpointDetailsListCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<CreateEndpointDetails> endpoints) {
            this.endpoints = CreateEndpointDetailsListCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(CreateEndpointDetails... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<CreateEndpointDetails.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> CreateEndpointDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getContactPrePassDurationSeconds() {
            return contactPrePassDurationSeconds;
        }

        public final void setContactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
        }

        @Override
        public final Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
            return this;
        }

        public final Integer getContactPostPassDurationSeconds() {
            return contactPostPassDurationSeconds;
        }

        public final void setContactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
        }

        @Override
        public final Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataflowEndpointGroupV2Request build() {
            return new CreateDataflowEndpointGroupV2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
