/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Endpoint definition used for creating a dataflow endpoint
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEndpointDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateEndpointDetails.Builder, CreateEndpointDetails> {
    private static final SdkField<UplinkAwsGroundStationAgentEndpoint> UPLINK_AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD = SdkField
            .<UplinkAwsGroundStationAgentEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("uplinkAwsGroundStationAgentEndpoint")
            .getter(getter(CreateEndpointDetails::uplinkAwsGroundStationAgentEndpoint))
            .setter(setter(Builder::uplinkAwsGroundStationAgentEndpoint))
            .constructor(UplinkAwsGroundStationAgentEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("uplinkAwsGroundStationAgentEndpoint").build()).build();

    private static final SdkField<DownlinkAwsGroundStationAgentEndpoint> DOWNLINK_AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD = SdkField
            .<DownlinkAwsGroundStationAgentEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("downlinkAwsGroundStationAgentEndpoint")
            .getter(getter(CreateEndpointDetails::downlinkAwsGroundStationAgentEndpoint))
            .setter(setter(Builder::downlinkAwsGroundStationAgentEndpoint))
            .constructor(DownlinkAwsGroundStationAgentEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("downlinkAwsGroundStationAgentEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            UPLINK_AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD, DOWNLINK_AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UplinkAwsGroundStationAgentEndpoint uplinkAwsGroundStationAgentEndpoint;

    private final DownlinkAwsGroundStationAgentEndpoint downlinkAwsGroundStationAgentEndpoint;

    private final Type type;

    private CreateEndpointDetails(BuilderImpl builder) {
        this.uplinkAwsGroundStationAgentEndpoint = builder.uplinkAwsGroundStationAgentEndpoint;
        this.downlinkAwsGroundStationAgentEndpoint = builder.downlinkAwsGroundStationAgentEndpoint;
        this.type = builder.type;
    }

    /**
     * <p>
     * Definition for an uplink agent endpoint
     * </p>
     * 
     * @return Definition for an uplink agent endpoint
     */
    public final UplinkAwsGroundStationAgentEndpoint uplinkAwsGroundStationAgentEndpoint() {
        return uplinkAwsGroundStationAgentEndpoint;
    }

    /**
     * <p>
     * Definition for a downlink agent endpoint
     * </p>
     * 
     * @return Definition for a downlink agent endpoint
     */
    public final DownlinkAwsGroundStationAgentEndpoint downlinkAwsGroundStationAgentEndpoint() {
        return downlinkAwsGroundStationAgentEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uplinkAwsGroundStationAgentEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(downlinkAwsGroundStationAgentEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointDetails)) {
            return false;
        }
        CreateEndpointDetails other = (CreateEndpointDetails) obj;
        return Objects.equals(uplinkAwsGroundStationAgentEndpoint(), other.uplinkAwsGroundStationAgentEndpoint())
                && Objects.equals(downlinkAwsGroundStationAgentEndpoint(), other.downlinkAwsGroundStationAgentEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEndpointDetails")
                .add("UplinkAwsGroundStationAgentEndpoint", uplinkAwsGroundStationAgentEndpoint())
                .add("DownlinkAwsGroundStationAgentEndpoint", downlinkAwsGroundStationAgentEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "uplinkAwsGroundStationAgentEndpoint":
            return Optional.ofNullable(clazz.cast(uplinkAwsGroundStationAgentEndpoint()));
        case "downlinkAwsGroundStationAgentEndpoint":
            return Optional.ofNullable(clazz.cast(downlinkAwsGroundStationAgentEndpoint()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #uplinkAwsGroundStationAgentEndpoint()} initialized to the given
     * value.
     *
     * <p>
     * Definition for an uplink agent endpoint
     * </p>
     * 
     * @param uplinkAwsGroundStationAgentEndpoint
     *        Definition for an uplink agent endpoint
     */
    public static CreateEndpointDetails fromUplinkAwsGroundStationAgentEndpoint(
            UplinkAwsGroundStationAgentEndpoint uplinkAwsGroundStationAgentEndpoint) {
        return builder().uplinkAwsGroundStationAgentEndpoint(uplinkAwsGroundStationAgentEndpoint).build();
    }

    /**
     * Create an instance of this class with {@link #uplinkAwsGroundStationAgentEndpoint()} initialized to the given
     * value.
     *
     * <p>
     * Definition for an uplink agent endpoint
     * </p>
     * 
     * @param uplinkAwsGroundStationAgentEndpoint
     *        Definition for an uplink agent endpoint
     */
    public static CreateEndpointDetails fromUplinkAwsGroundStationAgentEndpoint(
            Consumer<UplinkAwsGroundStationAgentEndpoint.Builder> uplinkAwsGroundStationAgentEndpoint) {
        UplinkAwsGroundStationAgentEndpoint.Builder builder = UplinkAwsGroundStationAgentEndpoint.builder();
        uplinkAwsGroundStationAgentEndpoint.accept(builder);
        return fromUplinkAwsGroundStationAgentEndpoint(builder.build());
    }

    /**
     * Create an instance of this class with {@link #downlinkAwsGroundStationAgentEndpoint()} initialized to the given
     * value.
     *
     * <p>
     * Definition for a downlink agent endpoint
     * </p>
     * 
     * @param downlinkAwsGroundStationAgentEndpoint
     *        Definition for a downlink agent endpoint
     */
    public static CreateEndpointDetails fromDownlinkAwsGroundStationAgentEndpoint(
            DownlinkAwsGroundStationAgentEndpoint downlinkAwsGroundStationAgentEndpoint) {
        return builder().downlinkAwsGroundStationAgentEndpoint(downlinkAwsGroundStationAgentEndpoint).build();
    }

    /**
     * Create an instance of this class with {@link #downlinkAwsGroundStationAgentEndpoint()} initialized to the given
     * value.
     *
     * <p>
     * Definition for a downlink agent endpoint
     * </p>
     * 
     * @param downlinkAwsGroundStationAgentEndpoint
     *        Definition for a downlink agent endpoint
     */
    public static CreateEndpointDetails fromDownlinkAwsGroundStationAgentEndpoint(
            Consumer<DownlinkAwsGroundStationAgentEndpoint.Builder> downlinkAwsGroundStationAgentEndpoint) {
        DownlinkAwsGroundStationAgentEndpoint.Builder builder = DownlinkAwsGroundStationAgentEndpoint.builder();
        downlinkAwsGroundStationAgentEndpoint.accept(builder);
        return fromDownlinkAwsGroundStationAgentEndpoint(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("uplinkAwsGroundStationAgentEndpoint", UPLINK_AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD);
        map.put("downlinkAwsGroundStationAgentEndpoint", DOWNLINK_AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEndpointDetails, T> g) {
        return obj -> g.apply((CreateEndpointDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateEndpointDetails> {
        /**
         * <p>
         * Definition for an uplink agent endpoint
         * </p>
         * 
         * @param uplinkAwsGroundStationAgentEndpoint
         *        Definition for an uplink agent endpoint
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkAwsGroundStationAgentEndpoint(UplinkAwsGroundStationAgentEndpoint uplinkAwsGroundStationAgentEndpoint);

        /**
         * <p>
         * Definition for an uplink agent endpoint
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UplinkAwsGroundStationAgentEndpoint.Builder} avoiding the need to create one manually via
         * {@link UplinkAwsGroundStationAgentEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UplinkAwsGroundStationAgentEndpoint.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #uplinkAwsGroundStationAgentEndpoint(UplinkAwsGroundStationAgentEndpoint)}.
         * 
         * @param uplinkAwsGroundStationAgentEndpoint
         *        a consumer that will call methods on {@link UplinkAwsGroundStationAgentEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uplinkAwsGroundStationAgentEndpoint(UplinkAwsGroundStationAgentEndpoint)
         */
        default Builder uplinkAwsGroundStationAgentEndpoint(
                Consumer<UplinkAwsGroundStationAgentEndpoint.Builder> uplinkAwsGroundStationAgentEndpoint) {
            return uplinkAwsGroundStationAgentEndpoint(UplinkAwsGroundStationAgentEndpoint.builder()
                    .applyMutation(uplinkAwsGroundStationAgentEndpoint).build());
        }

        /**
         * <p>
         * Definition for a downlink agent endpoint
         * </p>
         * 
         * @param downlinkAwsGroundStationAgentEndpoint
         *        Definition for a downlink agent endpoint
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkAwsGroundStationAgentEndpoint(DownlinkAwsGroundStationAgentEndpoint downlinkAwsGroundStationAgentEndpoint);

        /**
         * <p>
         * Definition for a downlink agent endpoint
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DownlinkAwsGroundStationAgentEndpoint.Builder} avoiding the need to create one manually via
         * {@link DownlinkAwsGroundStationAgentEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DownlinkAwsGroundStationAgentEndpoint.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #downlinkAwsGroundStationAgentEndpoint(DownlinkAwsGroundStationAgentEndpoint)}.
         * 
         * @param downlinkAwsGroundStationAgentEndpoint
         *        a consumer that will call methods on {@link DownlinkAwsGroundStationAgentEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #downlinkAwsGroundStationAgentEndpoint(DownlinkAwsGroundStationAgentEndpoint)
         */
        default Builder downlinkAwsGroundStationAgentEndpoint(
                Consumer<DownlinkAwsGroundStationAgentEndpoint.Builder> downlinkAwsGroundStationAgentEndpoint) {
            return downlinkAwsGroundStationAgentEndpoint(DownlinkAwsGroundStationAgentEndpoint.builder()
                    .applyMutation(downlinkAwsGroundStationAgentEndpoint).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UplinkAwsGroundStationAgentEndpoint uplinkAwsGroundStationAgentEndpoint;

        private DownlinkAwsGroundStationAgentEndpoint downlinkAwsGroundStationAgentEndpoint;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndpointDetails model) {
            uplinkAwsGroundStationAgentEndpoint(model.uplinkAwsGroundStationAgentEndpoint);
            downlinkAwsGroundStationAgentEndpoint(model.downlinkAwsGroundStationAgentEndpoint);
        }

        public final UplinkAwsGroundStationAgentEndpoint.Builder getUplinkAwsGroundStationAgentEndpoint() {
            return uplinkAwsGroundStationAgentEndpoint != null ? uplinkAwsGroundStationAgentEndpoint.toBuilder() : null;
        }

        public final void setUplinkAwsGroundStationAgentEndpoint(
                UplinkAwsGroundStationAgentEndpoint.BuilderImpl uplinkAwsGroundStationAgentEndpoint) {
            Object oldValue = this.uplinkAwsGroundStationAgentEndpoint;
            this.uplinkAwsGroundStationAgentEndpoint = uplinkAwsGroundStationAgentEndpoint != null ? uplinkAwsGroundStationAgentEndpoint
                    .build() : null;
            handleUnionValueChange(Type.UPLINK_AWS_GROUND_STATION_AGENT_ENDPOINT, oldValue,
                    this.uplinkAwsGroundStationAgentEndpoint);
        }

        @Override
        public final Builder uplinkAwsGroundStationAgentEndpoint(
                UplinkAwsGroundStationAgentEndpoint uplinkAwsGroundStationAgentEndpoint) {
            Object oldValue = this.uplinkAwsGroundStationAgentEndpoint;
            this.uplinkAwsGroundStationAgentEndpoint = uplinkAwsGroundStationAgentEndpoint;
            handleUnionValueChange(Type.UPLINK_AWS_GROUND_STATION_AGENT_ENDPOINT, oldValue,
                    this.uplinkAwsGroundStationAgentEndpoint);
            return this;
        }

        public final DownlinkAwsGroundStationAgentEndpoint.Builder getDownlinkAwsGroundStationAgentEndpoint() {
            return downlinkAwsGroundStationAgentEndpoint != null ? downlinkAwsGroundStationAgentEndpoint.toBuilder() : null;
        }

        public final void setDownlinkAwsGroundStationAgentEndpoint(
                DownlinkAwsGroundStationAgentEndpoint.BuilderImpl downlinkAwsGroundStationAgentEndpoint) {
            Object oldValue = this.downlinkAwsGroundStationAgentEndpoint;
            this.downlinkAwsGroundStationAgentEndpoint = downlinkAwsGroundStationAgentEndpoint != null ? downlinkAwsGroundStationAgentEndpoint
                    .build() : null;
            handleUnionValueChange(Type.DOWNLINK_AWS_GROUND_STATION_AGENT_ENDPOINT, oldValue,
                    this.downlinkAwsGroundStationAgentEndpoint);
        }

        @Override
        public final Builder downlinkAwsGroundStationAgentEndpoint(
                DownlinkAwsGroundStationAgentEndpoint downlinkAwsGroundStationAgentEndpoint) {
            Object oldValue = this.downlinkAwsGroundStationAgentEndpoint;
            this.downlinkAwsGroundStationAgentEndpoint = downlinkAwsGroundStationAgentEndpoint;
            handleUnionValueChange(Type.DOWNLINK_AWS_GROUND_STATION_AGENT_ENDPOINT, oldValue,
                    this.downlinkAwsGroundStationAgentEndpoint);
            return this;
        }

        @Override
        public CreateEndpointDetails build() {
            return new CreateEndpointDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CreateEndpointDetails#type()
     */
    public enum Type {
        UPLINK_AWS_GROUND_STATION_AGENT_ENDPOINT,

        DOWNLINK_AWS_GROUND_STATION_AGENT_ENDPOINT,

        UNKNOWN_TO_SDK_VERSION
    }
}
