/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEphemerisRequest extends GroundStationRequest implements
        ToCopyableBuilder<CreateEphemerisRequest.Builder, CreateEphemerisRequest> {
    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("satelliteId").getter(getter(CreateEphemerisRequest::satelliteId)).setter(setter(Builder::satelliteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(CreateEphemerisRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(CreateEphemerisRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expirationTime").getter(getter(CreateEphemerisRequest::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateEphemerisRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(CreateEphemerisRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<EphemerisData> EPHEMERIS_FIELD = SdkField.<EphemerisData> builder(MarshallingType.SDK_POJO)
            .memberName("ephemeris").getter(getter(CreateEphemerisRequest::ephemeris)).setter(setter(Builder::ephemeris))
            .constructor(EphemerisData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemeris").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateEphemerisRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SATELLITE_ID_FIELD,
            ENABLED_FIELD, PRIORITY_FIELD, EXPIRATION_TIME_FIELD, NAME_FIELD, KMS_KEY_ARN_FIELD, EPHEMERIS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String satelliteId;

    private final Boolean enabled;

    private final Integer priority;

    private final Instant expirationTime;

    private final String name;

    private final String kmsKeyArn;

    private final EphemerisData ephemeris;

    private final Map<String, String> tags;

    private CreateEphemerisRequest(BuilderImpl builder) {
        super(builder);
        this.satelliteId = builder.satelliteId;
        this.enabled = builder.enabled;
        this.priority = builder.priority;
        this.expirationTime = builder.expirationTime;
        this.name = builder.name;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.ephemeris = builder.ephemeris;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The satellite ID that associates this ephemeris with a satellite in AWS Ground Station.
     * </p>
     * 
     * @return The satellite ID that associates this ephemeris with a satellite in AWS Ground Station.
     */
    public final String satelliteId() {
        return satelliteId;
    }

    /**
     * <p>
     * Set to <code>true</code> to enable the ephemeris after validation. Set to <code>false</code> to keep it disabled.
     * </p>
     * 
     * @return Set to <code>true</code> to enable the ephemeris after validation. Set to <code>false</code> to keep it
     *         disabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * A priority score that determines which ephemeris to use when multiple ephemerides overlap.
     * </p>
     * <p>
     * Higher numbers take precedence. The default is 1. Must be 1 or greater.
     * </p>
     * 
     * @return A priority score that determines which ephemeris to use when multiple ephemerides overlap.</p>
     *         <p>
     *         Higher numbers take precedence. The default is 1. Must be 1 or greater.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * An overall expiration time for the ephemeris in UTC, after which it will become <code>EXPIRED</code>.
     * </p>
     * 
     * @return An overall expiration time for the ephemeris in UTC, after which it will become <code>EXPIRED</code>.
     */
    public final Instant expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * A name that you can use to identify the ephemeris.
     * </p>
     * 
     * @return A name that you can use to identify the ephemeris.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the KMS key to use for encrypting the ephemeris.
     * </p>
     * 
     * @return The ARN of the KMS key to use for encrypting the ephemeris.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * Ephemeris data.
     * </p>
     * 
     * @return Ephemeris data.
     */
    public final EphemerisData ephemeris() {
        return ephemeris;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to an ephemeris.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags assigned to an ephemeris.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(satelliteId());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(ephemeris());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEphemerisRequest)) {
            return false;
        }
        CreateEphemerisRequest other = (CreateEphemerisRequest) obj;
        return Objects.equals(satelliteId(), other.satelliteId()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(priority(), other.priority()) && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(name(), other.name()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(ephemeris(), other.ephemeris()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEphemerisRequest").add("SatelliteId", satelliteId()).add("Enabled", enabled())
                .add("Priority", priority()).add("ExpirationTime", expirationTime()).add("Name", name())
                .add("KmsKeyArn", kmsKeyArn()).add("Ephemeris", ephemeris()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "satelliteId":
            return Optional.ofNullable(clazz.cast(satelliteId()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "expirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "ephemeris":
            return Optional.ofNullable(clazz.cast(ephemeris()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("satelliteId", SATELLITE_ID_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("expirationTime", EXPIRATION_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("ephemeris", EPHEMERIS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEphemerisRequest, T> g) {
        return obj -> g.apply((CreateEphemerisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEphemerisRequest> {
        /**
         * <p>
         * The satellite ID that associates this ephemeris with a satellite in AWS Ground Station.
         * </p>
         * 
         * @param satelliteId
         *        The satellite ID that associates this ephemeris with a satellite in AWS Ground Station.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satelliteId(String satelliteId);

        /**
         * <p>
         * Set to <code>true</code> to enable the ephemeris after validation. Set to <code>false</code> to keep it
         * disabled.
         * </p>
         * 
         * @param enabled
         *        Set to <code>true</code> to enable the ephemeris after validation. Set to <code>false</code> to keep
         *        it disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A priority score that determines which ephemeris to use when multiple ephemerides overlap.
         * </p>
         * <p>
         * Higher numbers take precedence. The default is 1. Must be 1 or greater.
         * </p>
         * 
         * @param priority
         *        A priority score that determines which ephemeris to use when multiple ephemerides overlap.</p>
         *        <p>
         *        Higher numbers take precedence. The default is 1. Must be 1 or greater.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * An overall expiration time for the ephemeris in UTC, after which it will become <code>EXPIRED</code>.
         * </p>
         * 
         * @param expirationTime
         *        An overall expiration time for the ephemeris in UTC, after which it will become <code>EXPIRED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * A name that you can use to identify the ephemeris.
         * </p>
         * 
         * @param name
         *        A name that you can use to identify the ephemeris.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the KMS key to use for encrypting the ephemeris.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the KMS key to use for encrypting the ephemeris.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * Ephemeris data.
         * </p>
         * 
         * @param ephemeris
         *        Ephemeris data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemeris(EphemerisData ephemeris);

        /**
         * <p>
         * Ephemeris data.
         * </p>
         * This is a convenience method that creates an instance of the {@link EphemerisData.Builder} avoiding the need
         * to create one manually via {@link EphemerisData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EphemerisData.Builder#build()} is called immediately and its
         * result is passed to {@link #ephemeris(EphemerisData)}.
         * 
         * @param ephemeris
         *        a consumer that will call methods on {@link EphemerisData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ephemeris(EphemerisData)
         */
        default Builder ephemeris(Consumer<EphemerisData.Builder> ephemeris) {
            return ephemeris(EphemerisData.builder().applyMutation(ephemeris).build());
        }

        /**
         * <p>
         * Tags assigned to an ephemeris.
         * </p>
         * 
         * @param tags
         *        Tags assigned to an ephemeris.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private String satelliteId;

        private Boolean enabled;

        private Integer priority;

        private Instant expirationTime;

        private String name;

        private String kmsKeyArn;

        private EphemerisData ephemeris;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEphemerisRequest model) {
            super(model);
            satelliteId(model.satelliteId);
            enabled(model.enabled);
            priority(model.priority);
            expirationTime(model.expirationTime);
            name(model.name);
            kmsKeyArn(model.kmsKeyArn);
            ephemeris(model.ephemeris);
            tags(model.tags);
        }

        public final String getSatelliteId() {
            return satelliteId;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final EphemerisData.Builder getEphemeris() {
            return ephemeris != null ? ephemeris.toBuilder() : null;
        }

        public final void setEphemeris(EphemerisData.BuilderImpl ephemeris) {
            this.ephemeris = ephemeris != null ? ephemeris.build() : null;
        }

        @Override
        public final Builder ephemeris(EphemerisData ephemeris) {
            this.ephemeris = ephemeris;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEphemerisRequest build() {
            return new CreateEphemerisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
