/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMissionProfileRequest extends GroundStationRequest implements
        ToCopyableBuilder<CreateMissionProfileRequest.Builder, CreateMissionProfileRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateMissionProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> CONTACT_PRE_PASS_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("contactPrePassDurationSeconds")
            .getter(getter(CreateMissionProfileRequest::contactPrePassDurationSeconds))
            .setter(setter(Builder::contactPrePassDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPrePassDurationSeconds")
                    .build()).build();

    private static final SdkField<Integer> CONTACT_POST_PASS_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("contactPostPassDurationSeconds")
            .getter(getter(CreateMissionProfileRequest::contactPostPassDurationSeconds))
            .setter(setter(Builder::contactPostPassDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactPostPassDurationSeconds")
                    .build()).build();

    private static final SdkField<Integer> MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("minimumViableContactDurationSeconds")
            .getter(getter(CreateMissionProfileRequest::minimumViableContactDurationSeconds))
            .setter(setter(Builder::minimumViableContactDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("minimumViableContactDurationSeconds").build()).build();

    private static final SdkField<List<List<String>>> DATAFLOW_EDGES_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("dataflowEdges")
            .getter(getter(CreateMissionProfileRequest::dataflowEdges))
            .setter(setter(Builder::dataflowEdges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEdges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> TRACKING_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trackingConfigArn").getter(getter(CreateMissionProfileRequest::trackingConfigArn))
            .setter(setter(Builder::trackingConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingConfigArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateMissionProfileRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<KmsKey> STREAMS_KMS_KEY_FIELD = SdkField.<KmsKey> builder(MarshallingType.SDK_POJO)
            .memberName("streamsKmsKey").getter(getter(CreateMissionProfileRequest::streamsKmsKey))
            .setter(setter(Builder::streamsKmsKey)).constructor(KmsKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamsKmsKey").build()).build();

    private static final SdkField<String> STREAMS_KMS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamsKmsRole").getter(getter(CreateMissionProfileRequest::streamsKmsRole))
            .setter(setter(Builder::streamsKmsRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamsKmsRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CONTACT_PRE_PASS_DURATION_SECONDS_FIELD, CONTACT_POST_PASS_DURATION_SECONDS_FIELD,
            MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD, DATAFLOW_EDGES_FIELD, TRACKING_CONFIG_ARN_FIELD, TAGS_FIELD,
            STREAMS_KMS_KEY_FIELD, STREAMS_KMS_ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final Integer contactPrePassDurationSeconds;

    private final Integer contactPostPassDurationSeconds;

    private final Integer minimumViableContactDurationSeconds;

    private final List<List<String>> dataflowEdges;

    private final String trackingConfigArn;

    private final Map<String, String> tags;

    private final KmsKey streamsKmsKey;

    private final String streamsKmsRole;

    private CreateMissionProfileRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.contactPrePassDurationSeconds = builder.contactPrePassDurationSeconds;
        this.contactPostPassDurationSeconds = builder.contactPostPassDurationSeconds;
        this.minimumViableContactDurationSeconds = builder.minimumViableContactDurationSeconds;
        this.dataflowEdges = builder.dataflowEdges;
        this.trackingConfigArn = builder.trackingConfigArn;
        this.tags = builder.tags;
        this.streamsKmsKey = builder.streamsKmsKey;
        this.streamsKmsRole = builder.streamsKmsRole;
    }

    /**
     * <p>
     * Name of a mission profile.
     * </p>
     * 
     * @return Name of a mission profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Amount of time prior to contact start you’d like to receive a Ground Station Contact State Change event
     * indicating an upcoming pass.
     * </p>
     * 
     * @return Amount of time prior to contact start you’d like to receive a Ground Station Contact State Change event
     *         indicating an upcoming pass.
     */
    public final Integer contactPrePassDurationSeconds() {
        return contactPrePassDurationSeconds;
    }

    /**
     * <p>
     * Amount of time after a contact ends that you’d like to receive a Ground Station Contact State Change event
     * indicating the pass has finished.
     * </p>
     * 
     * @return Amount of time after a contact ends that you’d like to receive a Ground Station Contact State Change
     *         event indicating the pass has finished.
     */
    public final Integer contactPostPassDurationSeconds() {
        return contactPostPassDurationSeconds;
    }

    /**
     * <p>
     * Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will not
     * present you with contacts shorter than this duration.
     * </p>
     * 
     * @return Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station
     *         will not present you with contacts shorter than this duration.
     */
    public final Integer minimumViableContactDurationSeconds() {
        return minimumViableContactDurationSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataflowEdges property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataflowEdges() {
        return dataflowEdges != null && !(dataflowEdges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i>
     * <code>Config</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataflowEdges} method.
     * </p>
     * 
     * @return A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a
     *         <i>to</i> <code>Config</code>.
     */
    public final List<List<String>> dataflowEdges() {
        return dataflowEdges;
    }

    /**
     * <p>
     * ARN of a tracking <code>Config</code>.
     * </p>
     * 
     * @return ARN of a tracking <code>Config</code>.
     */
    public final String trackingConfigArn() {
        return trackingConfigArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to a mission profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags assigned to a mission profile.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * KMS key to use for encrypting streams.
     * </p>
     * 
     * @return KMS key to use for encrypting streams.
     */
    public final KmsKey streamsKmsKey() {
        return streamsKmsKey;
    }

    /**
     * <p>
     * Role to use for encrypting streams with KMS key.
     * </p>
     * 
     * @return Role to use for encrypting streams with KMS key.
     */
    public final String streamsKmsRole() {
        return streamsKmsRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(contactPrePassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(contactPostPassDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(minimumViableContactDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataflowEdges() ? dataflowEdges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trackingConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(streamsKmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(streamsKmsRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMissionProfileRequest)) {
            return false;
        }
        CreateMissionProfileRequest other = (CreateMissionProfileRequest) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(contactPrePassDurationSeconds(), other.contactPrePassDurationSeconds())
                && Objects.equals(contactPostPassDurationSeconds(), other.contactPostPassDurationSeconds())
                && Objects.equals(minimumViableContactDurationSeconds(), other.minimumViableContactDurationSeconds())
                && hasDataflowEdges() == other.hasDataflowEdges() && Objects.equals(dataflowEdges(), other.dataflowEdges())
                && Objects.equals(trackingConfigArn(), other.trackingConfigArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(streamsKmsKey(), other.streamsKmsKey())
                && Objects.equals(streamsKmsRole(), other.streamsKmsRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMissionProfileRequest").add("Name", name())
                .add("ContactPrePassDurationSeconds", contactPrePassDurationSeconds())
                .add("ContactPostPassDurationSeconds", contactPostPassDurationSeconds())
                .add("MinimumViableContactDurationSeconds", minimumViableContactDurationSeconds())
                .add("DataflowEdges", hasDataflowEdges() ? dataflowEdges() : null).add("TrackingConfigArn", trackingConfigArn())
                .add("Tags", hasTags() ? tags() : null).add("StreamsKmsKey", streamsKmsKey())
                .add("StreamsKmsRole", streamsKmsRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "contactPrePassDurationSeconds":
            return Optional.ofNullable(clazz.cast(contactPrePassDurationSeconds()));
        case "contactPostPassDurationSeconds":
            return Optional.ofNullable(clazz.cast(contactPostPassDurationSeconds()));
        case "minimumViableContactDurationSeconds":
            return Optional.ofNullable(clazz.cast(minimumViableContactDurationSeconds()));
        case "dataflowEdges":
            return Optional.ofNullable(clazz.cast(dataflowEdges()));
        case "trackingConfigArn":
            return Optional.ofNullable(clazz.cast(trackingConfigArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "streamsKmsKey":
            return Optional.ofNullable(clazz.cast(streamsKmsKey()));
        case "streamsKmsRole":
            return Optional.ofNullable(clazz.cast(streamsKmsRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("contactPrePassDurationSeconds", CONTACT_PRE_PASS_DURATION_SECONDS_FIELD);
        map.put("contactPostPassDurationSeconds", CONTACT_POST_PASS_DURATION_SECONDS_FIELD);
        map.put("minimumViableContactDurationSeconds", MINIMUM_VIABLE_CONTACT_DURATION_SECONDS_FIELD);
        map.put("dataflowEdges", DATAFLOW_EDGES_FIELD);
        map.put("trackingConfigArn", TRACKING_CONFIG_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("streamsKmsKey", STREAMS_KMS_KEY_FIELD);
        map.put("streamsKmsRole", STREAMS_KMS_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMissionProfileRequest, T> g) {
        return obj -> g.apply((CreateMissionProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMissionProfileRequest> {
        /**
         * <p>
         * Name of a mission profile.
         * </p>
         * 
         * @param name
         *        Name of a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Amount of time prior to contact start you’d like to receive a Ground Station Contact State Change event
         * indicating an upcoming pass.
         * </p>
         * 
         * @param contactPrePassDurationSeconds
         *        Amount of time prior to contact start you’d like to receive a Ground Station Contact State Change
         *        event indicating an upcoming pass.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds);

        /**
         * <p>
         * Amount of time after a contact ends that you’d like to receive a Ground Station Contact State Change event
         * indicating the pass has finished.
         * </p>
         * 
         * @param contactPostPassDurationSeconds
         *        Amount of time after a contact ends that you’d like to receive a Ground Station Contact State Change
         *        event indicating the pass has finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds);

        /**
         * <p>
         * Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station will
         * not present you with contacts shorter than this duration.
         * </p>
         * 
         * @param minimumViableContactDurationSeconds
         *        Smallest amount of time in seconds that you’d like to see for an available contact. AWS Ground Station
         *        will not present you with contacts shorter than this duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds);

        /**
         * <p>
         * A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i>
         * <code>Config</code>.
         * </p>
         * 
         * @param dataflowEdges
         *        A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a
         *        <i>to</i> <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEdges(Collection<? extends Collection<String>> dataflowEdges);

        /**
         * <p>
         * A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a <i>to</i>
         * <code>Config</code>.
         * </p>
         * 
         * @param dataflowEdges
         *        A list of lists of ARNs. Each list of ARNs is an edge, with a <i>from</i> <code>Config</code> and a
         *        <i>to</i> <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEdges(Collection<String>... dataflowEdges);

        /**
         * <p>
         * ARN of a tracking <code>Config</code>.
         * </p>
         * 
         * @param trackingConfigArn
         *        ARN of a tracking <code>Config</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingConfigArn(String trackingConfigArn);

        /**
         * <p>
         * Tags assigned to a mission profile.
         * </p>
         * 
         * @param tags
         *        Tags assigned to a mission profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * KMS key to use for encrypting streams.
         * </p>
         * 
         * @param streamsKmsKey
         *        KMS key to use for encrypting streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamsKmsKey(KmsKey streamsKmsKey);

        /**
         * <p>
         * KMS key to use for encrypting streams.
         * </p>
         * This is a convenience method that creates an instance of the {@link KmsKey.Builder} avoiding the need to
         * create one manually via {@link KmsKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KmsKey.Builder#build()} is called immediately and its result is
         * passed to {@link #streamsKmsKey(KmsKey)}.
         * 
         * @param streamsKmsKey
         *        a consumer that will call methods on {@link KmsKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamsKmsKey(KmsKey)
         */
        default Builder streamsKmsKey(Consumer<KmsKey.Builder> streamsKmsKey) {
            return streamsKmsKey(KmsKey.builder().applyMutation(streamsKmsKey).build());
        }

        /**
         * <p>
         * Role to use for encrypting streams with KMS key.
         * </p>
         * 
         * @param streamsKmsRole
         *        Role to use for encrypting streams with KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamsKmsRole(String streamsKmsRole);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private String name;

        private Integer contactPrePassDurationSeconds;

        private Integer contactPostPassDurationSeconds;

        private Integer minimumViableContactDurationSeconds;

        private List<List<String>> dataflowEdges = DefaultSdkAutoConstructList.getInstance();

        private String trackingConfigArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private KmsKey streamsKmsKey;

        private String streamsKmsRole;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMissionProfileRequest model) {
            super(model);
            name(model.name);
            contactPrePassDurationSeconds(model.contactPrePassDurationSeconds);
            contactPostPassDurationSeconds(model.contactPostPassDurationSeconds);
            minimumViableContactDurationSeconds(model.minimumViableContactDurationSeconds);
            dataflowEdges(model.dataflowEdges);
            trackingConfigArn(model.trackingConfigArn);
            tags(model.tags);
            streamsKmsKey(model.streamsKmsKey);
            streamsKmsRole(model.streamsKmsRole);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getContactPrePassDurationSeconds() {
            return contactPrePassDurationSeconds;
        }

        public final void setContactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
        }

        @Override
        public final Builder contactPrePassDurationSeconds(Integer contactPrePassDurationSeconds) {
            this.contactPrePassDurationSeconds = contactPrePassDurationSeconds;
            return this;
        }

        public final Integer getContactPostPassDurationSeconds() {
            return contactPostPassDurationSeconds;
        }

        public final void setContactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
        }

        @Override
        public final Builder contactPostPassDurationSeconds(Integer contactPostPassDurationSeconds) {
            this.contactPostPassDurationSeconds = contactPostPassDurationSeconds;
            return this;
        }

        public final Integer getMinimumViableContactDurationSeconds() {
            return minimumViableContactDurationSeconds;
        }

        public final void setMinimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds) {
            this.minimumViableContactDurationSeconds = minimumViableContactDurationSeconds;
        }

        @Override
        public final Builder minimumViableContactDurationSeconds(Integer minimumViableContactDurationSeconds) {
            this.minimumViableContactDurationSeconds = minimumViableContactDurationSeconds;
            return this;
        }

        public final Collection<? extends Collection<String>> getDataflowEdges() {
            if (dataflowEdges instanceof SdkAutoConstructList) {
                return null;
            }
            return dataflowEdges;
        }

        public final void setDataflowEdges(Collection<? extends Collection<String>> dataflowEdges) {
            this.dataflowEdges = DataflowEdgeListCopier.copy(dataflowEdges);
        }

        @Override
        public final Builder dataflowEdges(Collection<? extends Collection<String>> dataflowEdges) {
            this.dataflowEdges = DataflowEdgeListCopier.copy(dataflowEdges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowEdges(Collection<String>... dataflowEdges) {
            dataflowEdges(Arrays.asList(dataflowEdges));
            return this;
        }

        public final String getTrackingConfigArn() {
            return trackingConfigArn;
        }

        public final void setTrackingConfigArn(String trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
        }

        @Override
        public final Builder trackingConfigArn(String trackingConfigArn) {
            this.trackingConfigArn = trackingConfigArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final KmsKey.Builder getStreamsKmsKey() {
            return streamsKmsKey != null ? streamsKmsKey.toBuilder() : null;
        }

        public final void setStreamsKmsKey(KmsKey.BuilderImpl streamsKmsKey) {
            this.streamsKmsKey = streamsKmsKey != null ? streamsKmsKey.build() : null;
        }

        @Override
        public final Builder streamsKmsKey(KmsKey streamsKmsKey) {
            this.streamsKmsKey = streamsKmsKey;
            return this;
        }

        public final String getStreamsKmsRole() {
            return streamsKmsRole;
        }

        public final void setStreamsKmsRole(String streamsKmsRole) {
            this.streamsKmsRole = streamsKmsRole;
        }

        @Override
        public final Builder streamsKmsRole(String streamsKmsRole) {
            this.streamsKmsRole = streamsKmsRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMissionProfileRequest build() {
            return new CreateMissionProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
