/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Item in a list of <code>DataflowEndpoint</code> groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataflowEndpointListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<DataflowEndpointListItem.Builder, DataflowEndpointListItem> {
    private static final SdkField<String> DATAFLOW_ENDPOINT_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataflowEndpointGroupId").getter(getter(DataflowEndpointListItem::dataflowEndpointGroupId))
            .setter(setter(Builder::dataflowEndpointGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointGroupId").build())
            .build();

    private static final SdkField<String> DATAFLOW_ENDPOINT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataflowEndpointGroupArn").getter(getter(DataflowEndpointListItem::dataflowEndpointGroupArn))
            .setter(setter(Builder::dataflowEndpointGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointGroupArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATAFLOW_ENDPOINT_GROUP_ID_FIELD, DATAFLOW_ENDPOINT_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataflowEndpointGroupId;

    private final String dataflowEndpointGroupArn;

    private DataflowEndpointListItem(BuilderImpl builder) {
        this.dataflowEndpointGroupId = builder.dataflowEndpointGroupId;
        this.dataflowEndpointGroupArn = builder.dataflowEndpointGroupArn;
    }

    /**
     * <p>
     * UUID of a dataflow endpoint group.
     * </p>
     * 
     * @return UUID of a dataflow endpoint group.
     */
    public final String dataflowEndpointGroupId() {
        return dataflowEndpointGroupId;
    }

    /**
     * <p>
     * ARN of a dataflow endpoint group.
     * </p>
     * 
     * @return ARN of a dataflow endpoint group.
     */
    public final String dataflowEndpointGroupArn() {
        return dataflowEndpointGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataflowEndpointGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(dataflowEndpointGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataflowEndpointListItem)) {
            return false;
        }
        DataflowEndpointListItem other = (DataflowEndpointListItem) obj;
        return Objects.equals(dataflowEndpointGroupId(), other.dataflowEndpointGroupId())
                && Objects.equals(dataflowEndpointGroupArn(), other.dataflowEndpointGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataflowEndpointListItem").add("DataflowEndpointGroupId", dataflowEndpointGroupId())
                .add("DataflowEndpointGroupArn", dataflowEndpointGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataflowEndpointGroupId":
            return Optional.ofNullable(clazz.cast(dataflowEndpointGroupId()));
        case "dataflowEndpointGroupArn":
            return Optional.ofNullable(clazz.cast(dataflowEndpointGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataflowEndpointGroupId", DATAFLOW_ENDPOINT_GROUP_ID_FIELD);
        map.put("dataflowEndpointGroupArn", DATAFLOW_ENDPOINT_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataflowEndpointListItem, T> g) {
        return obj -> g.apply((DataflowEndpointListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataflowEndpointListItem> {
        /**
         * <p>
         * UUID of a dataflow endpoint group.
         * </p>
         * 
         * @param dataflowEndpointGroupId
         *        UUID of a dataflow endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEndpointGroupId(String dataflowEndpointGroupId);

        /**
         * <p>
         * ARN of a dataflow endpoint group.
         * </p>
         * 
         * @param dataflowEndpointGroupArn
         *        ARN of a dataflow endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEndpointGroupArn(String dataflowEndpointGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String dataflowEndpointGroupId;

        private String dataflowEndpointGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataflowEndpointListItem model) {
            dataflowEndpointGroupId(model.dataflowEndpointGroupId);
            dataflowEndpointGroupArn(model.dataflowEndpointGroupArn);
        }

        public final String getDataflowEndpointGroupId() {
            return dataflowEndpointGroupId;
        }

        public final void setDataflowEndpointGroupId(String dataflowEndpointGroupId) {
            this.dataflowEndpointGroupId = dataflowEndpointGroupId;
        }

        @Override
        public final Builder dataflowEndpointGroupId(String dataflowEndpointGroupId) {
            this.dataflowEndpointGroupId = dataflowEndpointGroupId;
            return this;
        }

        public final String getDataflowEndpointGroupArn() {
            return dataflowEndpointGroupArn;
        }

        public final void setDataflowEndpointGroupArn(String dataflowEndpointGroupArn) {
            this.dataflowEndpointGroupArn = dataflowEndpointGroupArn;
        }

        @Override
        public final Builder dataflowEndpointGroupArn(String dataflowEndpointGroupArn) {
            this.dataflowEndpointGroupArn = dataflowEndpointGroupArn;
            return this;
        }

        @Override
        public DataflowEndpointListItem build() {
            return new DataflowEndpointListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
