/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for a downlink agent endpoint
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DownlinkAwsGroundStationAgentEndpointDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DownlinkAwsGroundStationAgentEndpointDetails.Builder, DownlinkAwsGroundStationAgentEndpointDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DownlinkAwsGroundStationAgentEndpointDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<DownlinkDataflowDetails> DATAFLOW_DETAILS_FIELD = SdkField
            .<DownlinkDataflowDetails> builder(MarshallingType.SDK_POJO).memberName("dataflowDetails")
            .getter(getter(DownlinkAwsGroundStationAgentEndpointDetails::dataflowDetails))
            .setter(setter(Builder::dataflowDetails)).constructor(DownlinkDataflowDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowDetails").build()).build();

    private static final SdkField<String> AGENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentStatus").getter(getter(DownlinkAwsGroundStationAgentEndpointDetails::agentStatusAsString))
            .setter(setter(Builder::agentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentStatus").build()).build();

    private static final SdkField<String> AUDIT_RESULTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("auditResults").getter(getter(DownlinkAwsGroundStationAgentEndpointDetails::auditResultsAsString))
            .setter(setter(Builder::auditResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DATAFLOW_DETAILS_FIELD, AGENT_STATUS_FIELD, AUDIT_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final DownlinkDataflowDetails dataflowDetails;

    private final String agentStatus;

    private final String auditResults;

    private DownlinkAwsGroundStationAgentEndpointDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.dataflowDetails = builder.dataflowDetails;
        this.agentStatus = builder.agentStatus;
        this.auditResults = builder.auditResults;
    }

    /**
     * <p>
     * Downlink dataflow endpoint name
     * </p>
     * 
     * @return Downlink dataflow endpoint name
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Dataflow details for the downlink endpoint
     * </p>
     * 
     * @return Dataflow details for the downlink endpoint
     */
    public final DownlinkDataflowDetails dataflowDetails() {
        return dataflowDetails;
    }

    /**
     * <p>
     * Status of the agent associated with the downlink dataflow endpoint
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentStatus} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentStatusAsString}.
     * </p>
     * 
     * @return Status of the agent associated with the downlink dataflow endpoint
     * @see AgentStatus
     */
    public final AgentStatus agentStatus() {
        return AgentStatus.fromValue(agentStatus);
    }

    /**
     * <p>
     * Status of the agent associated with the downlink dataflow endpoint
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #agentStatus} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #agentStatusAsString}.
     * </p>
     * 
     * @return Status of the agent associated with the downlink dataflow endpoint
     * @see AgentStatus
     */
    public final String agentStatusAsString() {
        return agentStatus;
    }

    /**
     * <p>
     * Health audit results for the downlink dataflow endpoint
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #auditResults} will
     * return {@link AuditResults#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #auditResultsAsString}.
     * </p>
     * 
     * @return Health audit results for the downlink dataflow endpoint
     * @see AuditResults
     */
    public final AuditResults auditResults() {
        return AuditResults.fromValue(auditResults);
    }

    /**
     * <p>
     * Health audit results for the downlink dataflow endpoint
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #auditResults} will
     * return {@link AuditResults#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #auditResultsAsString}.
     * </p>
     * 
     * @return Health audit results for the downlink dataflow endpoint
     * @see AuditResults
     */
    public final String auditResultsAsString() {
        return auditResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataflowDetails());
        hashCode = 31 * hashCode + Objects.hashCode(agentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(auditResultsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownlinkAwsGroundStationAgentEndpointDetails)) {
            return false;
        }
        DownlinkAwsGroundStationAgentEndpointDetails other = (DownlinkAwsGroundStationAgentEndpointDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(dataflowDetails(), other.dataflowDetails())
                && Objects.equals(agentStatusAsString(), other.agentStatusAsString())
                && Objects.equals(auditResultsAsString(), other.auditResultsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DownlinkAwsGroundStationAgentEndpointDetails").add("Name", name())
                .add("DataflowDetails", dataflowDetails()).add("AgentStatus", agentStatusAsString())
                .add("AuditResults", auditResultsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dataflowDetails":
            return Optional.ofNullable(clazz.cast(dataflowDetails()));
        case "agentStatus":
            return Optional.ofNullable(clazz.cast(agentStatusAsString()));
        case "auditResults":
            return Optional.ofNullable(clazz.cast(auditResultsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("dataflowDetails", DATAFLOW_DETAILS_FIELD);
        map.put("agentStatus", AGENT_STATUS_FIELD);
        map.put("auditResults", AUDIT_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DownlinkAwsGroundStationAgentEndpointDetails, T> g) {
        return obj -> g.apply((DownlinkAwsGroundStationAgentEndpointDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DownlinkAwsGroundStationAgentEndpointDetails> {
        /**
         * <p>
         * Downlink dataflow endpoint name
         * </p>
         * 
         * @param name
         *        Downlink dataflow endpoint name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Dataflow details for the downlink endpoint
         * </p>
         * 
         * @param dataflowDetails
         *        Dataflow details for the downlink endpoint
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowDetails(DownlinkDataflowDetails dataflowDetails);

        /**
         * <p>
         * Dataflow details for the downlink endpoint
         * </p>
         * This is a convenience method that creates an instance of the {@link DownlinkDataflowDetails.Builder} avoiding
         * the need to create one manually via {@link DownlinkDataflowDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DownlinkDataflowDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #dataflowDetails(DownlinkDataflowDetails)}.
         * 
         * @param dataflowDetails
         *        a consumer that will call methods on {@link DownlinkDataflowDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataflowDetails(DownlinkDataflowDetails)
         */
        default Builder dataflowDetails(Consumer<DownlinkDataflowDetails.Builder> dataflowDetails) {
            return dataflowDetails(DownlinkDataflowDetails.builder().applyMutation(dataflowDetails).build());
        }

        /**
         * <p>
         * Status of the agent associated with the downlink dataflow endpoint
         * </p>
         * 
         * @param agentStatus
         *        Status of the agent associated with the downlink dataflow endpoint
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder agentStatus(String agentStatus);

        /**
         * <p>
         * Status of the agent associated with the downlink dataflow endpoint
         * </p>
         * 
         * @param agentStatus
         *        Status of the agent associated with the downlink dataflow endpoint
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder agentStatus(AgentStatus agentStatus);

        /**
         * <p>
         * Health audit results for the downlink dataflow endpoint
         * </p>
         * 
         * @param auditResults
         *        Health audit results for the downlink dataflow endpoint
         * @see AuditResults
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditResults
         */
        Builder auditResults(String auditResults);

        /**
         * <p>
         * Health audit results for the downlink dataflow endpoint
         * </p>
         * 
         * @param auditResults
         *        Health audit results for the downlink dataflow endpoint
         * @see AuditResults
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditResults
         */
        Builder auditResults(AuditResults auditResults);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private DownlinkDataflowDetails dataflowDetails;

        private String agentStatus;

        private String auditResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DownlinkAwsGroundStationAgentEndpointDetails model) {
            name(model.name);
            dataflowDetails(model.dataflowDetails);
            agentStatus(model.agentStatus);
            auditResults(model.auditResults);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DownlinkDataflowDetails.Builder getDataflowDetails() {
            return dataflowDetails != null ? dataflowDetails.toBuilder() : null;
        }

        public final void setDataflowDetails(DownlinkDataflowDetails.BuilderImpl dataflowDetails) {
            this.dataflowDetails = dataflowDetails != null ? dataflowDetails.build() : null;
        }

        @Override
        public final Builder dataflowDetails(DownlinkDataflowDetails dataflowDetails) {
            this.dataflowDetails = dataflowDetails;
            return this;
        }

        public final String getAgentStatus() {
            return agentStatus;
        }

        public final void setAgentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
        }

        @Override
        public final Builder agentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
            return this;
        }

        @Override
        public final Builder agentStatus(AgentStatus agentStatus) {
            this.agentStatus(agentStatus == null ? null : agentStatus.toString());
            return this;
        }

        public final String getAuditResults() {
            return auditResults;
        }

        public final void setAuditResults(String auditResults) {
            this.auditResults = auditResults;
        }

        @Override
        public final Builder auditResults(String auditResults) {
            this.auditResults = auditResults;
            return this;
        }

        @Override
        public final Builder auditResults(AuditResults auditResults) {
            this.auditResults(auditResults == null ? null : auditResults.toString());
            return this;
        }

        @Override
        public DownlinkAwsGroundStationAgentEndpointDetails build() {
            return new DownlinkAwsGroundStationAgentEndpointDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
