/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Connection details for Ground Station to Agent and Agent to customer
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DownlinkConnectionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DownlinkConnectionDetails.Builder, DownlinkConnectionDetails> {
    private static final SdkField<RangedConnectionDetails> AGENT_IP_AND_PORT_ADDRESS_FIELD = SdkField
            .<RangedConnectionDetails> builder(MarshallingType.SDK_POJO).memberName("agentIpAndPortAddress")
            .getter(getter(DownlinkConnectionDetails::agentIpAndPortAddress)).setter(setter(Builder::agentIpAndPortAddress))
            .constructor(RangedConnectionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentIpAndPortAddress").build())
            .build();

    private static final SdkField<ConnectionDetails> EGRESS_ADDRESS_AND_PORT_FIELD = SdkField
            .<ConnectionDetails> builder(MarshallingType.SDK_POJO).memberName("egressAddressAndPort")
            .getter(getter(DownlinkConnectionDetails::egressAddressAndPort)).setter(setter(Builder::egressAddressAndPort))
            .constructor(ConnectionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressAddressAndPort").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AGENT_IP_AND_PORT_ADDRESS_FIELD, EGRESS_ADDRESS_AND_PORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RangedConnectionDetails agentIpAndPortAddress;

    private final ConnectionDetails egressAddressAndPort;

    private DownlinkConnectionDetails(BuilderImpl builder) {
        this.agentIpAndPortAddress = builder.agentIpAndPortAddress;
        this.egressAddressAndPort = builder.egressAddressAndPort;
    }

    /**
     * Returns the value of the AgentIpAndPortAddress property for this object.
     * 
     * @return The value of the AgentIpAndPortAddress property for this object.
     */
    public final RangedConnectionDetails agentIpAndPortAddress() {
        return agentIpAndPortAddress;
    }

    /**
     * Returns the value of the EgressAddressAndPort property for this object.
     * 
     * @return The value of the EgressAddressAndPort property for this object.
     */
    public final ConnectionDetails egressAddressAndPort() {
        return egressAddressAndPort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentIpAndPortAddress());
        hashCode = 31 * hashCode + Objects.hashCode(egressAddressAndPort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownlinkConnectionDetails)) {
            return false;
        }
        DownlinkConnectionDetails other = (DownlinkConnectionDetails) obj;
        return Objects.equals(agentIpAndPortAddress(), other.agentIpAndPortAddress())
                && Objects.equals(egressAddressAndPort(), other.egressAddressAndPort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DownlinkConnectionDetails").add("AgentIpAndPortAddress", agentIpAndPortAddress())
                .add("EgressAddressAndPort", egressAddressAndPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentIpAndPortAddress":
            return Optional.ofNullable(clazz.cast(agentIpAndPortAddress()));
        case "egressAddressAndPort":
            return Optional.ofNullable(clazz.cast(egressAddressAndPort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentIpAndPortAddress", AGENT_IP_AND_PORT_ADDRESS_FIELD);
        map.put("egressAddressAndPort", EGRESS_ADDRESS_AND_PORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DownlinkConnectionDetails, T> g) {
        return obj -> g.apply((DownlinkConnectionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DownlinkConnectionDetails> {
        /**
         * Sets the value of the AgentIpAndPortAddress property for this object.
         *
         * @param agentIpAndPortAddress
         *        The new value for the AgentIpAndPortAddress property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentIpAndPortAddress(RangedConnectionDetails agentIpAndPortAddress);

        /**
         * Sets the value of the AgentIpAndPortAddress property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RangedConnectionDetails.Builder} avoiding
         * the need to create one manually via {@link RangedConnectionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RangedConnectionDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #agentIpAndPortAddress(RangedConnectionDetails)}.
         * 
         * @param agentIpAndPortAddress
         *        a consumer that will call methods on {@link RangedConnectionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentIpAndPortAddress(RangedConnectionDetails)
         */
        default Builder agentIpAndPortAddress(Consumer<RangedConnectionDetails.Builder> agentIpAndPortAddress) {
            return agentIpAndPortAddress(RangedConnectionDetails.builder().applyMutation(agentIpAndPortAddress).build());
        }

        /**
         * Sets the value of the EgressAddressAndPort property for this object.
         *
         * @param egressAddressAndPort
         *        The new value for the EgressAddressAndPort property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressAddressAndPort(ConnectionDetails egressAddressAndPort);

        /**
         * Sets the value of the EgressAddressAndPort property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ConnectionDetails.Builder} avoiding the
         * need to create one manually via {@link ConnectionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #egressAddressAndPort(ConnectionDetails)}.
         * 
         * @param egressAddressAndPort
         *        a consumer that will call methods on {@link ConnectionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressAddressAndPort(ConnectionDetails)
         */
        default Builder egressAddressAndPort(Consumer<ConnectionDetails.Builder> egressAddressAndPort) {
            return egressAddressAndPort(ConnectionDetails.builder().applyMutation(egressAddressAndPort).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RangedConnectionDetails agentIpAndPortAddress;

        private ConnectionDetails egressAddressAndPort;

        private BuilderImpl() {
        }

        private BuilderImpl(DownlinkConnectionDetails model) {
            agentIpAndPortAddress(model.agentIpAndPortAddress);
            egressAddressAndPort(model.egressAddressAndPort);
        }

        public final RangedConnectionDetails.Builder getAgentIpAndPortAddress() {
            return agentIpAndPortAddress != null ? agentIpAndPortAddress.toBuilder() : null;
        }

        public final void setAgentIpAndPortAddress(RangedConnectionDetails.BuilderImpl agentIpAndPortAddress) {
            this.agentIpAndPortAddress = agentIpAndPortAddress != null ? agentIpAndPortAddress.build() : null;
        }

        @Override
        public final Builder agentIpAndPortAddress(RangedConnectionDetails agentIpAndPortAddress) {
            this.agentIpAndPortAddress = agentIpAndPortAddress;
            return this;
        }

        public final ConnectionDetails.Builder getEgressAddressAndPort() {
            return egressAddressAndPort != null ? egressAddressAndPort.toBuilder() : null;
        }

        public final void setEgressAddressAndPort(ConnectionDetails.BuilderImpl egressAddressAndPort) {
            this.egressAddressAndPort = egressAddressAndPort != null ? egressAddressAndPort.build() : null;
        }

        @Override
        public final Builder egressAddressAndPort(ConnectionDetails egressAddressAndPort) {
            this.egressAddressAndPort = egressAddressAndPort;
            return this;
        }

        @Override
        public DownlinkConnectionDetails build() {
            return new DownlinkConnectionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
