/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that represents EIRP.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Eirp implements SdkPojo, Serializable, ToCopyableBuilder<Eirp.Builder, Eirp> {
    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("value")
            .getter(getter(Eirp::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("units")
            .getter(getter(Eirp::unitsAsString)).setter(setter(Builder::units))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("units").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double value;

    private final String units;

    private Eirp(BuilderImpl builder) {
        this.value = builder.value;
        this.units = builder.units;
    }

    /**
     * <p>
     * Value of an EIRP. Valid values are between 20.0 to 50.0 dBW.
     * </p>
     * 
     * @return Value of an EIRP. Valid values are between 20.0 to 50.0 dBW.
     */
    public final Double value() {
        return value;
    }

    /**
     * <p>
     * Units of an EIRP.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #units} will return
     * {@link EirpUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitsAsString}.
     * </p>
     * 
     * @return Units of an EIRP.
     * @see EirpUnits
     */
    public final EirpUnits units() {
        return EirpUnits.fromValue(units);
    }

    /**
     * <p>
     * Units of an EIRP.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #units} will return
     * {@link EirpUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitsAsString}.
     * </p>
     * 
     * @return Units of an EIRP.
     * @see EirpUnits
     */
    public final String unitsAsString() {
        return units;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(unitsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Eirp)) {
            return false;
        }
        Eirp other = (Eirp) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(unitsAsString(), other.unitsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Eirp").add("Value", value()).add("Units", unitsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "units":
            return Optional.ofNullable(clazz.cast(unitsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("value", VALUE_FIELD);
        map.put("units", UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Eirp, T> g) {
        return obj -> g.apply((Eirp) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Eirp> {
        /**
         * <p>
         * Value of an EIRP. Valid values are between 20.0 to 50.0 dBW.
         * </p>
         * 
         * @param value
         *        Value of an EIRP. Valid values are between 20.0 to 50.0 dBW.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);

        /**
         * <p>
         * Units of an EIRP.
         * </p>
         * 
         * @param units
         *        Units of an EIRP.
         * @see EirpUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EirpUnits
         */
        Builder units(String units);

        /**
         * <p>
         * Units of an EIRP.
         * </p>
         * 
         * @param units
         *        Units of an EIRP.
         * @see EirpUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EirpUnits
         */
        Builder units(EirpUnits units);
    }

    static final class BuilderImpl implements Builder {
        private Double value;

        private String units;

        private BuilderImpl() {
        }

        private BuilderImpl(Eirp model) {
            value(model.value);
            units(model.units);
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final String getUnits() {
            return units;
        }

        public final void setUnits(String units) {
            this.units = units;
        }

        @Override
        public final Builder units(String units) {
            this.units = units;
            return this;
        }

        @Override
        public final Builder units(EirpUnits units) {
            this.units(units == null ? null : units.toString());
            return this;
        }

        @Override
        public Eirp build() {
            return new Eirp(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
