/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the endpoint details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointDetails implements SdkPojo, Serializable, ToCopyableBuilder<EndpointDetails.Builder, EndpointDetails> {
    private static final SdkField<SecurityDetails> SECURITY_DETAILS_FIELD = SdkField
            .<SecurityDetails> builder(MarshallingType.SDK_POJO).memberName("securityDetails")
            .getter(getter(EndpointDetails::securityDetails)).setter(setter(Builder::securityDetails))
            .constructor(SecurityDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityDetails").build()).build();

    private static final SdkField<DataflowEndpoint> ENDPOINT_FIELD = SdkField
            .<DataflowEndpoint> builder(MarshallingType.SDK_POJO).memberName("endpoint")
            .getter(getter(EndpointDetails::endpoint)).setter(setter(Builder::endpoint)).constructor(DataflowEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<AwsGroundStationAgentEndpoint> AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD = SdkField
            .<AwsGroundStationAgentEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("awsGroundStationAgentEndpoint")
            .getter(getter(EndpointDetails::awsGroundStationAgentEndpoint))
            .setter(setter(Builder::awsGroundStationAgentEndpoint))
            .constructor(AwsGroundStationAgentEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsGroundStationAgentEndpoint")
                    .build()).build();

    private static final SdkField<UplinkAwsGroundStationAgentEndpointDetails> UPLINK_AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD = SdkField
            .<UplinkAwsGroundStationAgentEndpointDetails> builder(MarshallingType.SDK_POJO)
            .memberName("uplinkAwsGroundStationAgentEndpoint")
            .getter(getter(EndpointDetails::uplinkAwsGroundStationAgentEndpoint))
            .setter(setter(Builder::uplinkAwsGroundStationAgentEndpoint))
            .constructor(UplinkAwsGroundStationAgentEndpointDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("uplinkAwsGroundStationAgentEndpoint").build()).build();

    private static final SdkField<DownlinkAwsGroundStationAgentEndpointDetails> DOWNLINK_AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD = SdkField
            .<DownlinkAwsGroundStationAgentEndpointDetails> builder(MarshallingType.SDK_POJO)
            .memberName("downlinkAwsGroundStationAgentEndpoint")
            .getter(getter(EndpointDetails::downlinkAwsGroundStationAgentEndpoint))
            .setter(setter(Builder::downlinkAwsGroundStationAgentEndpoint))
            .constructor(DownlinkAwsGroundStationAgentEndpointDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("downlinkAwsGroundStationAgentEndpoint").build()).build();

    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("healthStatus").getter(getter(EndpointDetails::healthStatusAsString))
            .setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()).build();

    private static final SdkField<List<String>> HEALTH_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("healthReasons")
            .getter(getter(EndpointDetails::healthReasonsAsStrings))
            .setter(setter(Builder::healthReasonsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_DETAILS_FIELD,
            ENDPOINT_FIELD, AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD, UPLINK_AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD,
            DOWNLINK_AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD, HEALTH_STATUS_FIELD, HEALTH_REASONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SecurityDetails securityDetails;

    private final DataflowEndpoint endpoint;

    private final AwsGroundStationAgentEndpoint awsGroundStationAgentEndpoint;

    private final UplinkAwsGroundStationAgentEndpointDetails uplinkAwsGroundStationAgentEndpoint;

    private final DownlinkAwsGroundStationAgentEndpointDetails downlinkAwsGroundStationAgentEndpoint;

    private final String healthStatus;

    private final List<String> healthReasons;

    private EndpointDetails(BuilderImpl builder) {
        this.securityDetails = builder.securityDetails;
        this.endpoint = builder.endpoint;
        this.awsGroundStationAgentEndpoint = builder.awsGroundStationAgentEndpoint;
        this.uplinkAwsGroundStationAgentEndpoint = builder.uplinkAwsGroundStationAgentEndpoint;
        this.downlinkAwsGroundStationAgentEndpoint = builder.downlinkAwsGroundStationAgentEndpoint;
        this.healthStatus = builder.healthStatus;
        this.healthReasons = builder.healthReasons;
    }

    /**
     * <p>
     * Endpoint security details including a list of subnets, a list of security groups and a role to connect streams to
     * instances.
     * </p>
     * 
     * @return Endpoint security details including a list of subnets, a list of security groups and a role to connect
     *         streams to instances.
     */
    public final SecurityDetails securityDetails() {
        return securityDetails;
    }

    /**
     * <p>
     * A dataflow endpoint.
     * </p>
     * 
     * @return A dataflow endpoint.
     */
    public final DataflowEndpoint endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * An agent endpoint.
     * </p>
     * 
     * @return An agent endpoint.
     */
    public final AwsGroundStationAgentEndpoint awsGroundStationAgentEndpoint() {
        return awsGroundStationAgentEndpoint;
    }

    /**
     * <p>
     * Definition for an uplink agent endpoint
     * </p>
     * 
     * @return Definition for an uplink agent endpoint
     */
    public final UplinkAwsGroundStationAgentEndpointDetails uplinkAwsGroundStationAgentEndpoint() {
        return uplinkAwsGroundStationAgentEndpoint;
    }

    /**
     * <p>
     * Definition for a downlink agent endpoint
     * </p>
     * 
     * @return Definition for a downlink agent endpoint
     */
    public final DownlinkAwsGroundStationAgentEndpointDetails downlinkAwsGroundStationAgentEndpoint() {
        return downlinkAwsGroundStationAgentEndpoint;
    }

    /**
     * <p>
     * A dataflow endpoint health status. This field is ignored when calling <code>CreateDataflowEndpointGroup</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link CapabilityHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthStatusAsString}.
     * </p>
     * 
     * @return A dataflow endpoint health status. This field is ignored when calling
     *         <code>CreateDataflowEndpointGroup</code>.
     * @see CapabilityHealth
     */
    public final CapabilityHealth healthStatus() {
        return CapabilityHealth.fromValue(healthStatus);
    }

    /**
     * <p>
     * A dataflow endpoint health status. This field is ignored when calling <code>CreateDataflowEndpointGroup</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link CapabilityHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthStatusAsString}.
     * </p>
     * 
     * @return A dataflow endpoint health status. This field is ignored when calling
     *         <code>CreateDataflowEndpointGroup</code>.
     * @see CapabilityHealth
     */
    public final String healthStatusAsString() {
        return healthStatus;
    }

    /**
     * <p>
     * Health reasons for a dataflow endpoint. This field is ignored when calling
     * <code>CreateDataflowEndpointGroup</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHealthReasons} method.
     * </p>
     * 
     * @return Health reasons for a dataflow endpoint. This field is ignored when calling
     *         <code>CreateDataflowEndpointGroup</code>.
     */
    public final List<CapabilityHealthReason> healthReasons() {
        return CapabilityHealthReasonListCopier.copyStringToEnum(healthReasons);
    }

    /**
     * For responses, this returns true if the service returned a value for the HealthReasons property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHealthReasons() {
        return healthReasons != null && !(healthReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Health reasons for a dataflow endpoint. This field is ignored when calling
     * <code>CreateDataflowEndpointGroup</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHealthReasons} method.
     * </p>
     * 
     * @return Health reasons for a dataflow endpoint. This field is ignored when calling
     *         <code>CreateDataflowEndpointGroup</code>.
     */
    public final List<String> healthReasonsAsStrings() {
        return healthReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(awsGroundStationAgentEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(uplinkAwsGroundStationAgentEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(downlinkAwsGroundStationAgentEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasHealthReasons() ? healthReasonsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointDetails)) {
            return false;
        }
        EndpointDetails other = (EndpointDetails) obj;
        return Objects.equals(securityDetails(), other.securityDetails()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(awsGroundStationAgentEndpoint(), other.awsGroundStationAgentEndpoint())
                && Objects.equals(uplinkAwsGroundStationAgentEndpoint(), other.uplinkAwsGroundStationAgentEndpoint())
                && Objects.equals(downlinkAwsGroundStationAgentEndpoint(), other.downlinkAwsGroundStationAgentEndpoint())
                && Objects.equals(healthStatusAsString(), other.healthStatusAsString())
                && hasHealthReasons() == other.hasHealthReasons()
                && Objects.equals(healthReasonsAsStrings(), other.healthReasonsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointDetails").add("SecurityDetails", securityDetails()).add("Endpoint", endpoint())
                .add("AwsGroundStationAgentEndpoint", awsGroundStationAgentEndpoint())
                .add("UplinkAwsGroundStationAgentEndpoint", uplinkAwsGroundStationAgentEndpoint())
                .add("DownlinkAwsGroundStationAgentEndpoint", downlinkAwsGroundStationAgentEndpoint())
                .add("HealthStatus", healthStatusAsString())
                .add("HealthReasons", hasHealthReasons() ? healthReasonsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityDetails":
            return Optional.ofNullable(clazz.cast(securityDetails()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "awsGroundStationAgentEndpoint":
            return Optional.ofNullable(clazz.cast(awsGroundStationAgentEndpoint()));
        case "uplinkAwsGroundStationAgentEndpoint":
            return Optional.ofNullable(clazz.cast(uplinkAwsGroundStationAgentEndpoint()));
        case "downlinkAwsGroundStationAgentEndpoint":
            return Optional.ofNullable(clazz.cast(downlinkAwsGroundStationAgentEndpoint()));
        case "healthStatus":
            return Optional.ofNullable(clazz.cast(healthStatusAsString()));
        case "healthReasons":
            return Optional.ofNullable(clazz.cast(healthReasonsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("securityDetails", SECURITY_DETAILS_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("awsGroundStationAgentEndpoint", AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD);
        map.put("uplinkAwsGroundStationAgentEndpoint", UPLINK_AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD);
        map.put("downlinkAwsGroundStationAgentEndpoint", DOWNLINK_AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD);
        map.put("healthStatus", HEALTH_STATUS_FIELD);
        map.put("healthReasons", HEALTH_REASONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointDetails, T> g) {
        return obj -> g.apply((EndpointDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointDetails> {
        /**
         * <p>
         * Endpoint security details including a list of subnets, a list of security groups and a role to connect
         * streams to instances.
         * </p>
         * 
         * @param securityDetails
         *        Endpoint security details including a list of subnets, a list of security groups and a role to connect
         *        streams to instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityDetails(SecurityDetails securityDetails);

        /**
         * <p>
         * Endpoint security details including a list of subnets, a list of security groups and a role to connect
         * streams to instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecurityDetails.Builder} avoiding the
         * need to create one manually via {@link SecurityDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecurityDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #securityDetails(SecurityDetails)}.
         * 
         * @param securityDetails
         *        a consumer that will call methods on {@link SecurityDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityDetails(SecurityDetails)
         */
        default Builder securityDetails(Consumer<SecurityDetails.Builder> securityDetails) {
            return securityDetails(SecurityDetails.builder().applyMutation(securityDetails).build());
        }

        /**
         * <p>
         * A dataflow endpoint.
         * </p>
         * 
         * @param endpoint
         *        A dataflow endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(DataflowEndpoint endpoint);

        /**
         * <p>
         * A dataflow endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataflowEndpoint.Builder} avoiding the
         * need to create one manually via {@link DataflowEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataflowEndpoint.Builder#build()} is called immediately and its
         * result is passed to {@link #endpoint(DataflowEndpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link DataflowEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(DataflowEndpoint)
         */
        default Builder endpoint(Consumer<DataflowEndpoint.Builder> endpoint) {
            return endpoint(DataflowEndpoint.builder().applyMutation(endpoint).build());
        }

        /**
         * <p>
         * An agent endpoint.
         * </p>
         * 
         * @param awsGroundStationAgentEndpoint
         *        An agent endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsGroundStationAgentEndpoint(AwsGroundStationAgentEndpoint awsGroundStationAgentEndpoint);

        /**
         * <p>
         * An agent endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsGroundStationAgentEndpoint.Builder}
         * avoiding the need to create one manually via {@link AwsGroundStationAgentEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsGroundStationAgentEndpoint.Builder#build()} is called
         * immediately and its result is passed to {@link #awsGroundStationAgentEndpoint(AwsGroundStationAgentEndpoint)}.
         * 
         * @param awsGroundStationAgentEndpoint
         *        a consumer that will call methods on {@link AwsGroundStationAgentEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsGroundStationAgentEndpoint(AwsGroundStationAgentEndpoint)
         */
        default Builder awsGroundStationAgentEndpoint(
                Consumer<AwsGroundStationAgentEndpoint.Builder> awsGroundStationAgentEndpoint) {
            return awsGroundStationAgentEndpoint(AwsGroundStationAgentEndpoint.builder()
                    .applyMutation(awsGroundStationAgentEndpoint).build());
        }

        /**
         * <p>
         * Definition for an uplink agent endpoint
         * </p>
         * 
         * @param uplinkAwsGroundStationAgentEndpoint
         *        Definition for an uplink agent endpoint
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uplinkAwsGroundStationAgentEndpoint(UplinkAwsGroundStationAgentEndpointDetails uplinkAwsGroundStationAgentEndpoint);

        /**
         * <p>
         * Definition for an uplink agent endpoint
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UplinkAwsGroundStationAgentEndpointDetails.Builder} avoiding the need to create one manually via
         * {@link UplinkAwsGroundStationAgentEndpointDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UplinkAwsGroundStationAgentEndpointDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #uplinkAwsGroundStationAgentEndpoint(UplinkAwsGroundStationAgentEndpointDetails)}.
         * 
         * @param uplinkAwsGroundStationAgentEndpoint
         *        a consumer that will call methods on {@link UplinkAwsGroundStationAgentEndpointDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uplinkAwsGroundStationAgentEndpoint(UplinkAwsGroundStationAgentEndpointDetails)
         */
        default Builder uplinkAwsGroundStationAgentEndpoint(
                Consumer<UplinkAwsGroundStationAgentEndpointDetails.Builder> uplinkAwsGroundStationAgentEndpoint) {
            return uplinkAwsGroundStationAgentEndpoint(UplinkAwsGroundStationAgentEndpointDetails.builder()
                    .applyMutation(uplinkAwsGroundStationAgentEndpoint).build());
        }

        /**
         * <p>
         * Definition for a downlink agent endpoint
         * </p>
         * 
         * @param downlinkAwsGroundStationAgentEndpoint
         *        Definition for a downlink agent endpoint
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downlinkAwsGroundStationAgentEndpoint(
                DownlinkAwsGroundStationAgentEndpointDetails downlinkAwsGroundStationAgentEndpoint);

        /**
         * <p>
         * Definition for a downlink agent endpoint
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DownlinkAwsGroundStationAgentEndpointDetails.Builder} avoiding the need to create one manually via
         * {@link DownlinkAwsGroundStationAgentEndpointDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DownlinkAwsGroundStationAgentEndpointDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #downlinkAwsGroundStationAgentEndpoint(DownlinkAwsGroundStationAgentEndpointDetails)}.
         * 
         * @param downlinkAwsGroundStationAgentEndpoint
         *        a consumer that will call methods on {@link DownlinkAwsGroundStationAgentEndpointDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #downlinkAwsGroundStationAgentEndpoint(DownlinkAwsGroundStationAgentEndpointDetails)
         */
        default Builder downlinkAwsGroundStationAgentEndpoint(
                Consumer<DownlinkAwsGroundStationAgentEndpointDetails.Builder> downlinkAwsGroundStationAgentEndpoint) {
            return downlinkAwsGroundStationAgentEndpoint(DownlinkAwsGroundStationAgentEndpointDetails.builder()
                    .applyMutation(downlinkAwsGroundStationAgentEndpoint).build());
        }

        /**
         * <p>
         * A dataflow endpoint health status. This field is ignored when calling
         * <code>CreateDataflowEndpointGroup</code>.
         * </p>
         * 
         * @param healthStatus
         *        A dataflow endpoint health status. This field is ignored when calling
         *        <code>CreateDataflowEndpointGroup</code>.
         * @see CapabilityHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityHealth
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * A dataflow endpoint health status. This field is ignored when calling
         * <code>CreateDataflowEndpointGroup</code>.
         * </p>
         * 
         * @param healthStatus
         *        A dataflow endpoint health status. This field is ignored when calling
         *        <code>CreateDataflowEndpointGroup</code>.
         * @see CapabilityHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapabilityHealth
         */
        Builder healthStatus(CapabilityHealth healthStatus);

        /**
         * <p>
         * Health reasons for a dataflow endpoint. This field is ignored when calling
         * <code>CreateDataflowEndpointGroup</code>.
         * </p>
         * 
         * @param healthReasons
         *        Health reasons for a dataflow endpoint. This field is ignored when calling
         *        <code>CreateDataflowEndpointGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthReasonsWithStrings(Collection<String> healthReasons);

        /**
         * <p>
         * Health reasons for a dataflow endpoint. This field is ignored when calling
         * <code>CreateDataflowEndpointGroup</code>.
         * </p>
         * 
         * @param healthReasons
         *        Health reasons for a dataflow endpoint. This field is ignored when calling
         *        <code>CreateDataflowEndpointGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthReasonsWithStrings(String... healthReasons);

        /**
         * <p>
         * Health reasons for a dataflow endpoint. This field is ignored when calling
         * <code>CreateDataflowEndpointGroup</code>.
         * </p>
         * 
         * @param healthReasons
         *        Health reasons for a dataflow endpoint. This field is ignored when calling
         *        <code>CreateDataflowEndpointGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthReasons(Collection<CapabilityHealthReason> healthReasons);

        /**
         * <p>
         * Health reasons for a dataflow endpoint. This field is ignored when calling
         * <code>CreateDataflowEndpointGroup</code>.
         * </p>
         * 
         * @param healthReasons
         *        Health reasons for a dataflow endpoint. This field is ignored when calling
         *        <code>CreateDataflowEndpointGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthReasons(CapabilityHealthReason... healthReasons);
    }

    static final class BuilderImpl implements Builder {
        private SecurityDetails securityDetails;

        private DataflowEndpoint endpoint;

        private AwsGroundStationAgentEndpoint awsGroundStationAgentEndpoint;

        private UplinkAwsGroundStationAgentEndpointDetails uplinkAwsGroundStationAgentEndpoint;

        private DownlinkAwsGroundStationAgentEndpointDetails downlinkAwsGroundStationAgentEndpoint;

        private String healthStatus;

        private List<String> healthReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointDetails model) {
            securityDetails(model.securityDetails);
            endpoint(model.endpoint);
            awsGroundStationAgentEndpoint(model.awsGroundStationAgentEndpoint);
            uplinkAwsGroundStationAgentEndpoint(model.uplinkAwsGroundStationAgentEndpoint);
            downlinkAwsGroundStationAgentEndpoint(model.downlinkAwsGroundStationAgentEndpoint);
            healthStatus(model.healthStatus);
            healthReasonsWithStrings(model.healthReasons);
        }

        public final SecurityDetails.Builder getSecurityDetails() {
            return securityDetails != null ? securityDetails.toBuilder() : null;
        }

        public final void setSecurityDetails(SecurityDetails.BuilderImpl securityDetails) {
            this.securityDetails = securityDetails != null ? securityDetails.build() : null;
        }

        @Override
        public final Builder securityDetails(SecurityDetails securityDetails) {
            this.securityDetails = securityDetails;
            return this;
        }

        public final DataflowEndpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        public final void setEndpoint(DataflowEndpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(DataflowEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final AwsGroundStationAgentEndpoint.Builder getAwsGroundStationAgentEndpoint() {
            return awsGroundStationAgentEndpoint != null ? awsGroundStationAgentEndpoint.toBuilder() : null;
        }

        public final void setAwsGroundStationAgentEndpoint(AwsGroundStationAgentEndpoint.BuilderImpl awsGroundStationAgentEndpoint) {
            this.awsGroundStationAgentEndpoint = awsGroundStationAgentEndpoint != null ? awsGroundStationAgentEndpoint.build()
                    : null;
        }

        @Override
        public final Builder awsGroundStationAgentEndpoint(AwsGroundStationAgentEndpoint awsGroundStationAgentEndpoint) {
            this.awsGroundStationAgentEndpoint = awsGroundStationAgentEndpoint;
            return this;
        }

        public final UplinkAwsGroundStationAgentEndpointDetails.Builder getUplinkAwsGroundStationAgentEndpoint() {
            return uplinkAwsGroundStationAgentEndpoint != null ? uplinkAwsGroundStationAgentEndpoint.toBuilder() : null;
        }

        public final void setUplinkAwsGroundStationAgentEndpoint(
                UplinkAwsGroundStationAgentEndpointDetails.BuilderImpl uplinkAwsGroundStationAgentEndpoint) {
            this.uplinkAwsGroundStationAgentEndpoint = uplinkAwsGroundStationAgentEndpoint != null ? uplinkAwsGroundStationAgentEndpoint
                    .build() : null;
        }

        @Override
        public final Builder uplinkAwsGroundStationAgentEndpoint(
                UplinkAwsGroundStationAgentEndpointDetails uplinkAwsGroundStationAgentEndpoint) {
            this.uplinkAwsGroundStationAgentEndpoint = uplinkAwsGroundStationAgentEndpoint;
            return this;
        }

        public final DownlinkAwsGroundStationAgentEndpointDetails.Builder getDownlinkAwsGroundStationAgentEndpoint() {
            return downlinkAwsGroundStationAgentEndpoint != null ? downlinkAwsGroundStationAgentEndpoint.toBuilder() : null;
        }

        public final void setDownlinkAwsGroundStationAgentEndpoint(
                DownlinkAwsGroundStationAgentEndpointDetails.BuilderImpl downlinkAwsGroundStationAgentEndpoint) {
            this.downlinkAwsGroundStationAgentEndpoint = downlinkAwsGroundStationAgentEndpoint != null ? downlinkAwsGroundStationAgentEndpoint
                    .build() : null;
        }

        @Override
        public final Builder downlinkAwsGroundStationAgentEndpoint(
                DownlinkAwsGroundStationAgentEndpointDetails downlinkAwsGroundStationAgentEndpoint) {
            this.downlinkAwsGroundStationAgentEndpoint = downlinkAwsGroundStationAgentEndpoint;
            return this;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(CapabilityHealth healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final Collection<String> getHealthReasons() {
            if (healthReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return healthReasons;
        }

        public final void setHealthReasons(Collection<String> healthReasons) {
            this.healthReasons = CapabilityHealthReasonListCopier.copy(healthReasons);
        }

        @Override
        public final Builder healthReasonsWithStrings(Collection<String> healthReasons) {
            this.healthReasons = CapabilityHealthReasonListCopier.copy(healthReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthReasonsWithStrings(String... healthReasons) {
            healthReasonsWithStrings(Arrays.asList(healthReasons));
            return this;
        }

        @Override
        public final Builder healthReasons(Collection<CapabilityHealthReason> healthReasons) {
            this.healthReasons = CapabilityHealthReasonListCopier.copyEnumToString(healthReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthReasons(CapabilityHealthReason... healthReasons) {
            healthReasons(Arrays.asList(healthReasons));
            return this;
        }

        @Override
        public EndpointDetails build() {
            return new EndpointDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
