/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Ephemeris data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EphemerisData implements SdkPojo, Serializable, ToCopyableBuilder<EphemerisData.Builder, EphemerisData> {
    private static final SdkField<TLEEphemeris> TLE_FIELD = SdkField.<TLEEphemeris> builder(MarshallingType.SDK_POJO)
            .memberName("tle").getter(getter(EphemerisData::tle)).setter(setter(Builder::tle)).constructor(TLEEphemeris::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tle").build()).build();

    private static final SdkField<OEMEphemeris> OEM_FIELD = SdkField.<OEMEphemeris> builder(MarshallingType.SDK_POJO)
            .memberName("oem").getter(getter(EphemerisData::oem)).setter(setter(Builder::oem)).constructor(OEMEphemeris::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oem").build()).build();

    private static final SdkField<AzElEphemeris> AZ_EL_FIELD = SdkField.<AzElEphemeris> builder(MarshallingType.SDK_POJO)
            .memberName("azEl").getter(getter(EphemerisData::azEl)).setter(setter(Builder::azEl))
            .constructor(AzElEphemeris::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azEl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TLE_FIELD, OEM_FIELD,
            AZ_EL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TLEEphemeris tle;

    private final OEMEphemeris oem;

    private final AzElEphemeris azEl;

    private final Type type;

    private EphemerisData(BuilderImpl builder) {
        this.tle = builder.tle;
        this.oem = builder.oem;
        this.azEl = builder.azEl;
        this.type = builder.type;
    }

    /**
     * Returns the value of the Tle property for this object.
     * 
     * @return The value of the Tle property for this object.
     */
    public final TLEEphemeris tle() {
        return tle;
    }

    /**
     * Returns the value of the Oem property for this object.
     * 
     * @return The value of the Oem property for this object.
     */
    public final OEMEphemeris oem() {
        return oem;
    }

    /**
     * Returns the value of the AzEl property for this object.
     * 
     * @return The value of the AzEl property for this object.
     */
    public final AzElEphemeris azEl() {
        return azEl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tle());
        hashCode = 31 * hashCode + Objects.hashCode(oem());
        hashCode = 31 * hashCode + Objects.hashCode(azEl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EphemerisData)) {
            return false;
        }
        EphemerisData other = (EphemerisData) obj;
        return Objects.equals(tle(), other.tle()) && Objects.equals(oem(), other.oem()) && Objects.equals(azEl(), other.azEl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EphemerisData").add("Tle", tle()).add("Oem", oem()).add("AzEl", azEl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tle":
            return Optional.ofNullable(clazz.cast(tle()));
        case "oem":
            return Optional.ofNullable(clazz.cast(oem()));
        case "azEl":
            return Optional.ofNullable(clazz.cast(azEl()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #tle()} initialized to the given value.
     *
     * Sets the value of the Tle property for this object.
     *
     * @param tle
     *        The new value for the Tle property for this object.
     */
    public static EphemerisData fromTle(TLEEphemeris tle) {
        return builder().tle(tle).build();
    }

    /**
     * Create an instance of this class with {@link #tle()} initialized to the given value.
     *
     * Sets the value of the Tle property for this object.
     *
     * @param tle
     *        The new value for the Tle property for this object.
     */
    public static EphemerisData fromTle(Consumer<TLEEphemeris.Builder> tle) {
        TLEEphemeris.Builder builder = TLEEphemeris.builder();
        tle.accept(builder);
        return fromTle(builder.build());
    }

    /**
     * Create an instance of this class with {@link #oem()} initialized to the given value.
     *
     * Sets the value of the Oem property for this object.
     *
     * @param oem
     *        The new value for the Oem property for this object.
     */
    public static EphemerisData fromOem(OEMEphemeris oem) {
        return builder().oem(oem).build();
    }

    /**
     * Create an instance of this class with {@link #oem()} initialized to the given value.
     *
     * Sets the value of the Oem property for this object.
     *
     * @param oem
     *        The new value for the Oem property for this object.
     */
    public static EphemerisData fromOem(Consumer<OEMEphemeris.Builder> oem) {
        OEMEphemeris.Builder builder = OEMEphemeris.builder();
        oem.accept(builder);
        return fromOem(builder.build());
    }

    /**
     * Create an instance of this class with {@link #azEl()} initialized to the given value.
     *
     * Sets the value of the AzEl property for this object.
     *
     * @param azEl
     *        The new value for the AzEl property for this object.
     */
    public static EphemerisData fromAzEl(AzElEphemeris azEl) {
        return builder().azEl(azEl).build();
    }

    /**
     * Create an instance of this class with {@link #azEl()} initialized to the given value.
     *
     * Sets the value of the AzEl property for this object.
     *
     * @param azEl
     *        The new value for the AzEl property for this object.
     */
    public static EphemerisData fromAzEl(Consumer<AzElEphemeris.Builder> azEl) {
        AzElEphemeris.Builder builder = AzElEphemeris.builder();
        azEl.accept(builder);
        return fromAzEl(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tle", TLE_FIELD);
        map.put("oem", OEM_FIELD);
        map.put("azEl", AZ_EL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EphemerisData, T> g) {
        return obj -> g.apply((EphemerisData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EphemerisData> {
        /**
         * Sets the value of the Tle property for this object.
         *
         * @param tle
         *        The new value for the Tle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tle(TLEEphemeris tle);

        /**
         * Sets the value of the Tle property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TLEEphemeris.Builder} avoiding the need
         * to create one manually via {@link TLEEphemeris#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TLEEphemeris.Builder#build()} is called immediately and its
         * result is passed to {@link #tle(TLEEphemeris)}.
         * 
         * @param tle
         *        a consumer that will call methods on {@link TLEEphemeris.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tle(TLEEphemeris)
         */
        default Builder tle(Consumer<TLEEphemeris.Builder> tle) {
            return tle(TLEEphemeris.builder().applyMutation(tle).build());
        }

        /**
         * Sets the value of the Oem property for this object.
         *
         * @param oem
         *        The new value for the Oem property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oem(OEMEphemeris oem);

        /**
         * Sets the value of the Oem property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OEMEphemeris.Builder} avoiding the need
         * to create one manually via {@link OEMEphemeris#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OEMEphemeris.Builder#build()} is called immediately and its
         * result is passed to {@link #oem(OEMEphemeris)}.
         * 
         * @param oem
         *        a consumer that will call methods on {@link OEMEphemeris.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oem(OEMEphemeris)
         */
        default Builder oem(Consumer<OEMEphemeris.Builder> oem) {
            return oem(OEMEphemeris.builder().applyMutation(oem).build());
        }

        /**
         * Sets the value of the AzEl property for this object.
         *
         * @param azEl
         *        The new value for the AzEl property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder azEl(AzElEphemeris azEl);

        /**
         * Sets the value of the AzEl property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AzElEphemeris.Builder} avoiding the need
         * to create one manually via {@link AzElEphemeris#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AzElEphemeris.Builder#build()} is called immediately and its
         * result is passed to {@link #azEl(AzElEphemeris)}.
         * 
         * @param azEl
         *        a consumer that will call methods on {@link AzElEphemeris.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #azEl(AzElEphemeris)
         */
        default Builder azEl(Consumer<AzElEphemeris.Builder> azEl) {
            return azEl(AzElEphemeris.builder().applyMutation(azEl).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TLEEphemeris tle;

        private OEMEphemeris oem;

        private AzElEphemeris azEl;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EphemerisData model) {
            tle(model.tle);
            oem(model.oem);
            azEl(model.azEl);
        }

        public final TLEEphemeris.Builder getTle() {
            return tle != null ? tle.toBuilder() : null;
        }

        public final void setTle(TLEEphemeris.BuilderImpl tle) {
            Object oldValue = this.tle;
            this.tle = tle != null ? tle.build() : null;
            handleUnionValueChange(Type.TLE, oldValue, this.tle);
        }

        @Override
        public final Builder tle(TLEEphemeris tle) {
            Object oldValue = this.tle;
            this.tle = tle;
            handleUnionValueChange(Type.TLE, oldValue, this.tle);
            return this;
        }

        public final OEMEphemeris.Builder getOem() {
            return oem != null ? oem.toBuilder() : null;
        }

        public final void setOem(OEMEphemeris.BuilderImpl oem) {
            Object oldValue = this.oem;
            this.oem = oem != null ? oem.build() : null;
            handleUnionValueChange(Type.OEM, oldValue, this.oem);
        }

        @Override
        public final Builder oem(OEMEphemeris oem) {
            Object oldValue = this.oem;
            this.oem = oem;
            handleUnionValueChange(Type.OEM, oldValue, this.oem);
            return this;
        }

        public final AzElEphemeris.Builder getAzEl() {
            return azEl != null ? azEl.toBuilder() : null;
        }

        public final void setAzEl(AzElEphemeris.BuilderImpl azEl) {
            Object oldValue = this.azEl;
            this.azEl = azEl != null ? azEl.build() : null;
            handleUnionValueChange(Type.AZ_EL, oldValue, this.azEl);
        }

        @Override
        public final Builder azEl(AzElEphemeris azEl) {
            Object oldValue = this.azEl;
            this.azEl = azEl;
            handleUnionValueChange(Type.AZ_EL, oldValue, this.azEl);
            return this;
        }

        @Override
        public EphemerisData build() {
            return new EphemerisData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EphemerisData#type()
     */
    public enum Type {
        TLE,

        OEM,

        AZ_EL,

        UNKNOWN_TO_SDK_VERSION
    }
}
