/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Description of ephemeris.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EphemerisDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<EphemerisDescription.Builder, EphemerisDescription> {
    private static final SdkField<S3Object> SOURCE_S3_OBJECT_FIELD = SdkField.<S3Object> builder(MarshallingType.SDK_POJO)
            .memberName("sourceS3Object").getter(getter(EphemerisDescription::sourceS3Object))
            .setter(setter(Builder::sourceS3Object)).constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceS3Object").build()).build();

    private static final SdkField<String> EPHEMERIS_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ephemerisData").getter(getter(EphemerisDescription::ephemerisData))
            .setter(setter(Builder::ephemerisData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerisData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_S3_OBJECT_FIELD,
            EPHEMERIS_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3Object sourceS3Object;

    private final String ephemerisData;

    private EphemerisDescription(BuilderImpl builder) {
        this.sourceS3Object = builder.sourceS3Object;
        this.ephemerisData = builder.ephemerisData;
    }

    /**
     * <p>
     * Source Amazon S3 object used for the ephemeris.
     * </p>
     * 
     * @return Source Amazon S3 object used for the ephemeris.
     */
    public final S3Object sourceS3Object() {
        return sourceS3Object;
    }

    /**
     * <p>
     * Supplied ephemeris data.
     * </p>
     * 
     * @return Supplied ephemeris data.
     */
    public final String ephemerisData() {
        return ephemerisData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3Object());
        hashCode = 31 * hashCode + Objects.hashCode(ephemerisData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EphemerisDescription)) {
            return false;
        }
        EphemerisDescription other = (EphemerisDescription) obj;
        return Objects.equals(sourceS3Object(), other.sourceS3Object()) && Objects.equals(ephemerisData(), other.ephemerisData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EphemerisDescription").add("SourceS3Object", sourceS3Object())
                .add("EphemerisData", ephemerisData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceS3Object":
            return Optional.ofNullable(clazz.cast(sourceS3Object()));
        case "ephemerisData":
            return Optional.ofNullable(clazz.cast(ephemerisData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceS3Object", SOURCE_S3_OBJECT_FIELD);
        map.put("ephemerisData", EPHEMERIS_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EphemerisDescription, T> g) {
        return obj -> g.apply((EphemerisDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EphemerisDescription> {
        /**
         * <p>
         * Source Amazon S3 object used for the ephemeris.
         * </p>
         * 
         * @param sourceS3Object
         *        Source Amazon S3 object used for the ephemeris.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3Object(S3Object sourceS3Object);

        /**
         * <p>
         * Source Amazon S3 object used for the ephemeris.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Object.Builder} avoiding the need to
         * create one manually via {@link S3Object#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #sourceS3Object(S3Object)}.
         * 
         * @param sourceS3Object
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceS3Object(S3Object)
         */
        default Builder sourceS3Object(Consumer<S3Object.Builder> sourceS3Object) {
            return sourceS3Object(S3Object.builder().applyMutation(sourceS3Object).build());
        }

        /**
         * <p>
         * Supplied ephemeris data.
         * </p>
         * 
         * @param ephemerisData
         *        Supplied ephemeris data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemerisData(String ephemerisData);
    }

    static final class BuilderImpl implements Builder {
        private S3Object sourceS3Object;

        private String ephemerisData;

        private BuilderImpl() {
        }

        private BuilderImpl(EphemerisDescription model) {
            sourceS3Object(model.sourceS3Object);
            ephemerisData(model.ephemerisData);
        }

        public final S3Object.Builder getSourceS3Object() {
            return sourceS3Object != null ? sourceS3Object.toBuilder() : null;
        }

        public final void setSourceS3Object(S3Object.BuilderImpl sourceS3Object) {
            this.sourceS3Object = sourceS3Object != null ? sourceS3Object.build() : null;
        }

        @Override
        public final Builder sourceS3Object(S3Object sourceS3Object) {
            this.sourceS3Object = sourceS3Object;
            return this;
        }

        public final String getEphemerisData() {
            return ephemerisData;
        }

        public final void setEphemerisData(String ephemerisData) {
            this.ephemerisData = ephemerisData;
        }

        @Override
        public final Builder ephemerisData(String ephemerisData) {
            this.ephemerisData = ephemerisData;
            return this;
        }

        @Override
        public EphemerisDescription build() {
            return new EphemerisDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
