/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum EphemerisErrorCode {
    INTERNAL_ERROR("INTERNAL_ERROR"),

    MISMATCHED_SATCAT_ID("MISMATCHED_SATCAT_ID"),

    OEM_VERSION_UNSUPPORTED("OEM_VERSION_UNSUPPORTED"),

    ORIGINATOR_MISSING("ORIGINATOR_MISSING"),

    CREATION_DATE_MISSING("CREATION_DATE_MISSING"),

    OBJECT_NAME_MISSING("OBJECT_NAME_MISSING"),

    OBJECT_ID_MISSING("OBJECT_ID_MISSING"),

    REF_FRAME_UNSUPPORTED("REF_FRAME_UNSUPPORTED"),

    REF_FRAME_EPOCH_UNSUPPORTED("REF_FRAME_EPOCH_UNSUPPORTED"),

    TIME_SYSTEM_UNSUPPORTED("TIME_SYSTEM_UNSUPPORTED"),

    CENTER_BODY_UNSUPPORTED("CENTER_BODY_UNSUPPORTED"),

    INTERPOLATION_MISSING("INTERPOLATION_MISSING"),

    INTERPOLATION_DEGREE_INVALID("INTERPOLATION_DEGREE_INVALID"),

    AZ_EL_SEGMENT_LIST_MISSING("AZ_EL_SEGMENT_LIST_MISSING"),

    INSUFFICIENT_TIME_AZ_EL("INSUFFICIENT_TIME_AZ_EL"),

    START_TIME_IN_FUTURE("START_TIME_IN_FUTURE"),

    END_TIME_IN_PAST("END_TIME_IN_PAST"),

    EXPIRATION_TIME_TOO_EARLY("EXPIRATION_TIME_TOO_EARLY"),

    START_TIME_METADATA_TOO_EARLY("START_TIME_METADATA_TOO_EARLY"),

    STOP_TIME_METADATA_TOO_LATE("STOP_TIME_METADATA_TOO_LATE"),

    AZ_EL_SEGMENT_END_TIME_BEFORE_START_TIME("AZ_EL_SEGMENT_END_TIME_BEFORE_START_TIME"),

    AZ_EL_SEGMENT_TIMES_OVERLAP("AZ_EL_SEGMENT_TIMES_OVERLAP"),

    AZ_EL_SEGMENTS_OUT_OF_ORDER("AZ_EL_SEGMENTS_OUT_OF_ORDER"),

    TIME_AZ_EL_ITEMS_OUT_OF_ORDER("TIME_AZ_EL_ITEMS_OUT_OF_ORDER"),

    MEAN_MOTION_INVALID("MEAN_MOTION_INVALID"),

    TIME_AZ_EL_AZ_RADIAN_RANGE_INVALID("TIME_AZ_EL_AZ_RADIAN_RANGE_INVALID"),

    TIME_AZ_EL_EL_RADIAN_RANGE_INVALID("TIME_AZ_EL_EL_RADIAN_RANGE_INVALID"),

    TIME_AZ_EL_AZ_DEGREE_RANGE_INVALID("TIME_AZ_EL_AZ_DEGREE_RANGE_INVALID"),

    TIME_AZ_EL_EL_DEGREE_RANGE_INVALID("TIME_AZ_EL_EL_DEGREE_RANGE_INVALID"),

    TIME_AZ_EL_ANGLE_UNITS_INVALID("TIME_AZ_EL_ANGLE_UNITS_INVALID"),

    INSUFFICIENT_KMS_PERMISSIONS("INSUFFICIENT_KMS_PERMISSIONS"),

    FILE_FORMAT_INVALID("FILE_FORMAT_INVALID"),

    AZ_EL_SEGMENT_REFERENCE_EPOCH_INVALID("AZ_EL_SEGMENT_REFERENCE_EPOCH_INVALID"),

    AZ_EL_SEGMENT_START_TIME_INVALID("AZ_EL_SEGMENT_START_TIME_INVALID"),

    AZ_EL_SEGMENT_END_TIME_INVALID("AZ_EL_SEGMENT_END_TIME_INVALID"),

    AZ_EL_SEGMENT_VALID_TIME_RANGE_INVALID("AZ_EL_SEGMENT_VALID_TIME_RANGE_INVALID"),

    AZ_EL_SEGMENT_END_TIME_TOO_LATE("AZ_EL_SEGMENT_END_TIME_TOO_LATE"),

    AZ_EL_TOTAL_DURATION_EXCEEDED("AZ_EL_TOTAL_DURATION_EXCEEDED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EphemerisErrorCode> VALUE_MAP = EnumUtils.uniqueIndex(EphemerisErrorCode.class,
            EphemerisErrorCode::toString);

    private final String value;

    private EphemerisErrorCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return EphemerisErrorCode corresponding to the value
     */
    public static EphemerisErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link EphemerisErrorCode}s
     */
    public static Set<EphemerisErrorCode> knownValues() {
        Set<EphemerisErrorCode> knownValues = EnumSet.allOf(EphemerisErrorCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
