/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter for selecting contacts that use a specific ephemeris".
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EphemerisFilter implements SdkPojo, Serializable, ToCopyableBuilder<EphemerisFilter.Builder, EphemerisFilter> {
    private static final SdkField<AzElEphemerisFilter> AZ_EL_FIELD = SdkField
            .<AzElEphemerisFilter> builder(MarshallingType.SDK_POJO).memberName("azEl").getter(getter(EphemerisFilter::azEl))
            .setter(setter(Builder::azEl)).constructor(AzElEphemerisFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azEl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AZ_EL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AzElEphemerisFilter azEl;

    private final Type type;

    private EphemerisFilter(BuilderImpl builder) {
        this.azEl = builder.azEl;
        this.type = builder.type;
    }

    /**
     * <p>
     * Filter for <a>AzElEphemeris</a>.
     * </p>
     * 
     * @return Filter for <a>AzElEphemeris</a>.
     */
    public final AzElEphemerisFilter azEl() {
        return azEl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(azEl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EphemerisFilter)) {
            return false;
        }
        EphemerisFilter other = (EphemerisFilter) obj;
        return Objects.equals(azEl(), other.azEl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EphemerisFilter").add("AzEl", azEl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "azEl":
            return Optional.ofNullable(clazz.cast(azEl()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #azEl()} initialized to the given value.
     *
     * <p>
     * Filter for <a>AzElEphemeris</a>.
     * </p>
     * 
     * @param azEl
     *        Filter for <a>AzElEphemeris</a>.
     */
    public static EphemerisFilter fromAzEl(AzElEphemerisFilter azEl) {
        return builder().azEl(azEl).build();
    }

    /**
     * Create an instance of this class with {@link #azEl()} initialized to the given value.
     *
     * <p>
     * Filter for <a>AzElEphemeris</a>.
     * </p>
     * 
     * @param azEl
     *        Filter for <a>AzElEphemeris</a>.
     */
    public static EphemerisFilter fromAzEl(Consumer<AzElEphemerisFilter.Builder> azEl) {
        AzElEphemerisFilter.Builder builder = AzElEphemerisFilter.builder();
        azEl.accept(builder);
        return fromAzEl(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("azEl", AZ_EL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EphemerisFilter, T> g) {
        return obj -> g.apply((EphemerisFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EphemerisFilter> {
        /**
         * <p>
         * Filter for <a>AzElEphemeris</a>.
         * </p>
         * 
         * @param azEl
         *        Filter for <a>AzElEphemeris</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder azEl(AzElEphemerisFilter azEl);

        /**
         * <p>
         * Filter for <a>AzElEphemeris</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AzElEphemerisFilter.Builder} avoiding the
         * need to create one manually via {@link AzElEphemerisFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AzElEphemerisFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #azEl(AzElEphemerisFilter)}.
         * 
         * @param azEl
         *        a consumer that will call methods on {@link AzElEphemerisFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #azEl(AzElEphemerisFilter)
         */
        default Builder azEl(Consumer<AzElEphemerisFilter.Builder> azEl) {
            return azEl(AzElEphemerisFilter.builder().applyMutation(azEl).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AzElEphemerisFilter azEl;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EphemerisFilter model) {
            azEl(model.azEl);
        }

        public final AzElEphemerisFilter.Builder getAzEl() {
            return azEl != null ? azEl.toBuilder() : null;
        }

        public final void setAzEl(AzElEphemerisFilter.BuilderImpl azEl) {
            Object oldValue = this.azEl;
            this.azEl = azEl != null ? azEl.build() : null;
            handleUnionValueChange(Type.AZ_EL, oldValue, this.azEl);
        }

        @Override
        public final Builder azEl(AzElEphemerisFilter azEl) {
            Object oldValue = this.azEl;
            this.azEl = azEl;
            handleUnionValueChange(Type.AZ_EL, oldValue, this.azEl);
            return this;
        }

        @Override
        public EphemerisFilter build() {
            return new EphemerisFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EphemerisFilter#type()
     */
    public enum Type {
        AZ_EL,

        UNKNOWN_TO_SDK_VERSION
    }
}
