/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Ephemeris data for a contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EphemerisResponseData implements SdkPojo, Serializable,
        ToCopyableBuilder<EphemerisResponseData.Builder, EphemerisResponseData> {
    private static final SdkField<String> EPHEMERIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ephemerisId").getter(getter(EphemerisResponseData::ephemerisId)).setter(setter(Builder::ephemerisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerisId").build()).build();

    private static final SdkField<String> EPHEMERIS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ephemerisType").getter(getter(EphemerisResponseData::ephemerisTypeAsString))
            .setter(setter(Builder::ephemerisType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerisType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EPHEMERIS_ID_FIELD,
            EPHEMERIS_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ephemerisId;

    private final String ephemerisType;

    private EphemerisResponseData(BuilderImpl builder) {
        this.ephemerisId = builder.ephemerisId;
        this.ephemerisType = builder.ephemerisType;
    }

    /**
     * <p>
     * Unique identifier of the ephemeris. Appears only for custom ephemerides.
     * </p>
     * 
     * @return Unique identifier of the ephemeris. Appears only for custom ephemerides.
     */
    public final String ephemerisId() {
        return ephemerisId;
    }

    /**
     * <p>
     * Type of ephemeris.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ephemerisType}
     * will return {@link EphemerisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ephemerisTypeAsString}.
     * </p>
     * 
     * @return Type of ephemeris.
     * @see EphemerisType
     */
    public final EphemerisType ephemerisType() {
        return EphemerisType.fromValue(ephemerisType);
    }

    /**
     * <p>
     * Type of ephemeris.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ephemerisType}
     * will return {@link EphemerisType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ephemerisTypeAsString}.
     * </p>
     * 
     * @return Type of ephemeris.
     * @see EphemerisType
     */
    public final String ephemerisTypeAsString() {
        return ephemerisType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ephemerisId());
        hashCode = 31 * hashCode + Objects.hashCode(ephemerisTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EphemerisResponseData)) {
            return false;
        }
        EphemerisResponseData other = (EphemerisResponseData) obj;
        return Objects.equals(ephemerisId(), other.ephemerisId())
                && Objects.equals(ephemerisTypeAsString(), other.ephemerisTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EphemerisResponseData").add("EphemerisId", ephemerisId())
                .add("EphemerisType", ephemerisTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ephemerisId":
            return Optional.ofNullable(clazz.cast(ephemerisId()));
        case "ephemerisType":
            return Optional.ofNullable(clazz.cast(ephemerisTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ephemerisId", EPHEMERIS_ID_FIELD);
        map.put("ephemerisType", EPHEMERIS_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EphemerisResponseData, T> g) {
        return obj -> g.apply((EphemerisResponseData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EphemerisResponseData> {
        /**
         * <p>
         * Unique identifier of the ephemeris. Appears only for custom ephemerides.
         * </p>
         * 
         * @param ephemerisId
         *        Unique identifier of the ephemeris. Appears only for custom ephemerides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemerisId(String ephemerisId);

        /**
         * <p>
         * Type of ephemeris.
         * </p>
         * 
         * @param ephemerisType
         *        Type of ephemeris.
         * @see EphemerisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EphemerisType
         */
        Builder ephemerisType(String ephemerisType);

        /**
         * <p>
         * Type of ephemeris.
         * </p>
         * 
         * @param ephemerisType
         *        Type of ephemeris.
         * @see EphemerisType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EphemerisType
         */
        Builder ephemerisType(EphemerisType ephemerisType);
    }

    static final class BuilderImpl implements Builder {
        private String ephemerisId;

        private String ephemerisType;

        private BuilderImpl() {
        }

        private BuilderImpl(EphemerisResponseData model) {
            ephemerisId(model.ephemerisId);
            ephemerisType(model.ephemerisType);
        }

        public final String getEphemerisId() {
            return ephemerisId;
        }

        public final void setEphemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
        }

        @Override
        public final Builder ephemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
            return this;
        }

        public final String getEphemerisType() {
            return ephemerisType;
        }

        public final void setEphemerisType(String ephemerisType) {
            this.ephemerisType = ephemerisType;
        }

        @Override
        public final Builder ephemerisType(String ephemerisType) {
            this.ephemerisType = ephemerisType;
            return this;
        }

        @Override
        public final Builder ephemerisType(EphemerisType ephemerisType) {
            this.ephemerisType(ephemerisType == null ? null : ephemerisType.toString());
            return this;
        }

        @Override
        public EphemerisResponseData build() {
            return new EphemerisResponseData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
