/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAgentTaskResponseUrlResponse extends GroundStationResponse implements
        ToCopyableBuilder<GetAgentTaskResponseUrlResponse.Builder, GetAgentTaskResponseUrlResponse> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(GetAgentTaskResponseUrlResponse::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(GetAgentTaskResponseUrlResponse::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> PRESIGNED_LOG_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("presignedLogUrl").getter(getter(GetAgentTaskResponseUrlResponse::presignedLogUrl))
            .setter(setter(Builder::presignedLogUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedLogUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, TASK_ID_FIELD,
            PRESIGNED_LOG_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentId;

    private final String taskId;

    private final String presignedLogUrl;

    private GetAgentTaskResponseUrlResponse(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.taskId = builder.taskId;
        this.presignedLogUrl = builder.presignedLogUrl;
    }

    /**
     * <p>
     * UUID of the agent.
     * </p>
     * 
     * @return UUID of the agent.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * GUID of the agent task.
     * </p>
     * 
     * @return GUID of the agent task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * Presigned URL for uploading agent task response logs.
     * </p>
     * 
     * @return Presigned URL for uploading agent task response logs.
     */
    public final String presignedLogUrl() {
        return presignedLogUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(presignedLogUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgentTaskResponseUrlResponse)) {
            return false;
        }
        GetAgentTaskResponseUrlResponse other = (GetAgentTaskResponseUrlResponse) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(taskId(), other.taskId())
                && Objects.equals(presignedLogUrl(), other.presignedLogUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAgentTaskResponseUrlResponse").add("AgentId", agentId()).add("TaskId", taskId())
                .add("PresignedLogUrl", presignedLogUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "presignedLogUrl":
            return Optional.ofNullable(clazz.cast(presignedLogUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("taskId", TASK_ID_FIELD);
        map.put("presignedLogUrl", PRESIGNED_LOG_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAgentTaskResponseUrlResponse, T> g) {
        return obj -> g.apply((GetAgentTaskResponseUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GroundStationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAgentTaskResponseUrlResponse> {
        /**
         * <p>
         * UUID of the agent.
         * </p>
         * 
         * @param agentId
         *        UUID of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * GUID of the agent task.
         * </p>
         * 
         * @param taskId
         *        GUID of the agent task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * Presigned URL for uploading agent task response logs.
         * </p>
         * 
         * @param presignedLogUrl
         *        Presigned URL for uploading agent task response logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presignedLogUrl(String presignedLogUrl);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private String agentId;

        private String taskId;

        private String presignedLogUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgentTaskResponseUrlResponse model) {
            super(model);
            agentId(model.agentId);
            taskId(model.taskId);
            presignedLogUrl(model.presignedLogUrl);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getPresignedLogUrl() {
            return presignedLogUrl;
        }

        public final void setPresignedLogUrl(String presignedLogUrl) {
            this.presignedLogUrl = presignedLogUrl;
        }

        @Override
        public final Builder presignedLogUrl(String presignedLogUrl) {
            this.presignedLogUrl = presignedLogUrl;
            return this;
        }

        @Override
        public GetAgentTaskResponseUrlResponse build() {
            return new GetAgentTaskResponseUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
