/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataflowEndpointGroupRequest extends GroundStationRequest implements
        ToCopyableBuilder<GetDataflowEndpointGroupRequest.Builder, GetDataflowEndpointGroupRequest> {
    private static final SdkField<String> DATAFLOW_ENDPOINT_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataflowEndpointGroupId").getter(getter(GetDataflowEndpointGroupRequest::dataflowEndpointGroupId))
            .setter(setter(Builder::dataflowEndpointGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataflowEndpointGroupId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DATAFLOW_ENDPOINT_GROUP_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataflowEndpointGroupId;

    private GetDataflowEndpointGroupRequest(BuilderImpl builder) {
        super(builder);
        this.dataflowEndpointGroupId = builder.dataflowEndpointGroupId;
    }

    /**
     * <p>
     * UUID of a dataflow endpoint group.
     * </p>
     * 
     * @return UUID of a dataflow endpoint group.
     */
    public final String dataflowEndpointGroupId() {
        return dataflowEndpointGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataflowEndpointGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataflowEndpointGroupRequest)) {
            return false;
        }
        GetDataflowEndpointGroupRequest other = (GetDataflowEndpointGroupRequest) obj;
        return Objects.equals(dataflowEndpointGroupId(), other.dataflowEndpointGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataflowEndpointGroupRequest").add("DataflowEndpointGroupId", dataflowEndpointGroupId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataflowEndpointGroupId":
            return Optional.ofNullable(clazz.cast(dataflowEndpointGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataflowEndpointGroupId", DATAFLOW_ENDPOINT_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataflowEndpointGroupRequest, T> g) {
        return obj -> g.apply((GetDataflowEndpointGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GroundStationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDataflowEndpointGroupRequest> {
        /**
         * <p>
         * UUID of a dataflow endpoint group.
         * </p>
         * 
         * @param dataflowEndpointGroupId
         *        UUID of a dataflow endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowEndpointGroupId(String dataflowEndpointGroupId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private String dataflowEndpointGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataflowEndpointGroupRequest model) {
            super(model);
            dataflowEndpointGroupId(model.dataflowEndpointGroupId);
        }

        public final String getDataflowEndpointGroupId() {
            return dataflowEndpointGroupId;
        }

        public final void setDataflowEndpointGroupId(String dataflowEndpointGroupId) {
            this.dataflowEndpointGroupId = dataflowEndpointGroupId;
        }

        @Override
        public final Builder dataflowEndpointGroupId(String dataflowEndpointGroupId) {
            this.dataflowEndpointGroupId = dataflowEndpointGroupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataflowEndpointGroupRequest build() {
            return new GetDataflowEndpointGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
