/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An integer range that has a minimum and maximum value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegerRange implements SdkPojo, Serializable, ToCopyableBuilder<IntegerRange.Builder, IntegerRange> {
    private static final SdkField<Integer> MINIMUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minimum").getter(getter(IntegerRange::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimum").build()).build();

    private static final SdkField<Integer> MAXIMUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximum").getter(getter(IntegerRange::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximum").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_FIELD, MAXIMUM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer minimum;

    private final Integer maximum;

    private IntegerRange(BuilderImpl builder) {
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
    }

    /**
     * <p>
     * A minimum value.
     * </p>
     * 
     * @return A minimum value.
     */
    public final Integer minimum() {
        return minimum;
    }

    /**
     * <p>
     * A maximum value.
     * </p>
     * 
     * @return A maximum value.
     */
    public final Integer maximum() {
        return maximum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerRange)) {
            return false;
        }
        IntegerRange other = (IntegerRange) obj;
        return Objects.equals(minimum(), other.minimum()) && Objects.equals(maximum(), other.maximum());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegerRange").add("Minimum", minimum()).add("Maximum", maximum()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "minimum":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("minimum", MINIMUM_FIELD);
        map.put("maximum", MAXIMUM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegerRange, T> g) {
        return obj -> g.apply((IntegerRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegerRange> {
        /**
         * <p>
         * A minimum value.
         * </p>
         * 
         * @param minimum
         *        A minimum value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Integer minimum);

        /**
         * <p>
         * A maximum value.
         * </p>
         * 
         * @param maximum
         *        A maximum value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Integer maximum);
    }

    static final class BuilderImpl implements Builder {
        private Integer minimum;

        private Integer maximum;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegerRange model) {
            minimum(model.minimum);
            maximum(model.maximum);
        }

        public final Integer getMinimum() {
            return minimum;
        }

        public final void setMinimum(Integer minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Integer minimum) {
            this.minimum = minimum;
            return this;
        }

        public final Integer getMaximum() {
            return maximum;
        }

        public final void setMaximum(Integer maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(Integer maximum) {
            this.maximum = maximum;
            return this;
        }

        @Override
        public IntegerRange build() {
            return new IntegerRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
