/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigsResponse extends GroundStationResponse implements
        ToCopyableBuilder<ListConfigsResponse.Builder, ListConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListConfigsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ConfigListItem>> CONFIG_LIST_FIELD = SdkField
            .<List<ConfigListItem>> builder(MarshallingType.LIST)
            .memberName("configList")
            .getter(getter(ListConfigsResponse::configList))
            .setter(setter(Builder::configList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CONFIG_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ConfigListItem> configList;

    private ListConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.configList = builder.configList;
    }

    /**
     * <p>
     * Next token returned in the response of a previous <code>ListConfigs</code> call. Used to get the next page of
     * results.
     * </p>
     * 
     * @return Next token returned in the response of a previous <code>ListConfigs</code> call. Used to get the next
     *         page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConfigList() {
        return configList != null && !(configList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of <code>Config</code> items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigList} method.
     * </p>
     * 
     * @return List of <code>Config</code> items.
     */
    public final List<ConfigListItem> configList() {
        return configList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigList() ? configList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigsResponse)) {
            return false;
        }
        ListConfigsResponse other = (ListConfigsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasConfigList() == other.hasConfigList()
                && Objects.equals(configList(), other.configList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConfigsResponse").add("NextToken", nextToken())
                .add("ConfigList", hasConfigList() ? configList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "configList":
            return Optional.ofNullable(clazz.cast(configList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("configList", CONFIG_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigsResponse, T> g) {
        return obj -> g.apply((ListConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GroundStationResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListConfigsResponse> {
        /**
         * <p>
         * Next token returned in the response of a previous <code>ListConfigs</code> call. Used to get the next page of
         * results.
         * </p>
         * 
         * @param nextToken
         *        Next token returned in the response of a previous <code>ListConfigs</code> call. Used to get the next
         *        page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of <code>Config</code> items.
         * </p>
         * 
         * @param configList
         *        List of <code>Config</code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configList(Collection<ConfigListItem> configList);

        /**
         * <p>
         * List of <code>Config</code> items.
         * </p>
         * 
         * @param configList
         *        List of <code>Config</code> items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configList(ConfigListItem... configList);

        /**
         * <p>
         * List of <code>Config</code> items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.groundstation.model.ConfigListItem.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.groundstation.model.ConfigListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.groundstation.model.ConfigListItem.Builder#build()} is called
         * immediately and its result is passed to {@link #configList(List<ConfigListItem>)}.
         * 
         * @param configList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.groundstation.model.ConfigListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configList(java.util.Collection<ConfigListItem>)
         */
        Builder configList(Consumer<ConfigListItem.Builder>... configList);
    }

    static final class BuilderImpl extends GroundStationResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ConfigListItem> configList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigsResponse model) {
            super(model);
            nextToken(model.nextToken);
            configList(model.configList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ConfigListItem.Builder> getConfigList() {
            List<ConfigListItem.Builder> result = ConfigListCopier.copyToBuilder(this.configList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigList(Collection<ConfigListItem.BuilderImpl> configList) {
            this.configList = ConfigListCopier.copyFromBuilder(configList);
        }

        @Override
        public final Builder configList(Collection<ConfigListItem> configList) {
            this.configList = ConfigListCopier.copy(configList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configList(ConfigListItem... configList) {
            configList(Arrays.asList(configList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configList(Consumer<ConfigListItem.Builder>... configList) {
            configList(Stream.of(configList).map(c -> ConfigListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListConfigsResponse build() {
            return new ListConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
