/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterAgentRequest extends GroundStationRequest implements
        ToCopyableBuilder<RegisterAgentRequest.Builder, RegisterAgentRequest> {
    private static final SdkField<DiscoveryData> DISCOVERY_DATA_FIELD = SdkField
            .<DiscoveryData> builder(MarshallingType.SDK_POJO).memberName("discoveryData")
            .getter(getter(RegisterAgentRequest::discoveryData)).setter(setter(Builder::discoveryData))
            .constructor(DiscoveryData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryData").build()).build();

    private static final SdkField<AgentDetails> AGENT_DETAILS_FIELD = SdkField.<AgentDetails> builder(MarshallingType.SDK_POJO)
            .memberName("agentDetails").getter(getter(RegisterAgentRequest::agentDetails)).setter(setter(Builder::agentDetails))
            .constructor(AgentDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentDetails").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(RegisterAgentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_DATA_FIELD,
            AGENT_DETAILS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DiscoveryData discoveryData;

    private final AgentDetails agentDetails;

    private final Map<String, String> tags;

    private RegisterAgentRequest(BuilderImpl builder) {
        super(builder);
        this.discoveryData = builder.discoveryData;
        this.agentDetails = builder.agentDetails;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Data for associating an agent with the capabilities it is managing.
     * </p>
     * 
     * @return Data for associating an agent with the capabilities it is managing.
     */
    public final DiscoveryData discoveryData() {
        return discoveryData;
    }

    /**
     * <p>
     * Detailed information about the agent being registered.
     * </p>
     * 
     * @return Detailed information about the agent being registered.
     */
    public final AgentDetails agentDetails() {
        return agentDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to an <code>Agent</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags assigned to an <code>Agent</code>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(discoveryData());
        hashCode = 31 * hashCode + Objects.hashCode(agentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAgentRequest)) {
            return false;
        }
        RegisterAgentRequest other = (RegisterAgentRequest) obj;
        return Objects.equals(discoveryData(), other.discoveryData()) && Objects.equals(agentDetails(), other.agentDetails())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterAgentRequest").add("DiscoveryData", discoveryData()).add("AgentDetails", agentDetails())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "discoveryData":
            return Optional.ofNullable(clazz.cast(discoveryData()));
        case "agentDetails":
            return Optional.ofNullable(clazz.cast(agentDetails()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("discoveryData", DISCOVERY_DATA_FIELD);
        map.put("agentDetails", AGENT_DETAILS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterAgentRequest, T> g) {
        return obj -> g.apply((RegisterAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterAgentRequest> {
        /**
         * <p>
         * Data for associating an agent with the capabilities it is managing.
         * </p>
         * 
         * @param discoveryData
         *        Data for associating an agent with the capabilities it is managing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryData(DiscoveryData discoveryData);

        /**
         * <p>
         * Data for associating an agent with the capabilities it is managing.
         * </p>
         * This is a convenience method that creates an instance of the {@link DiscoveryData.Builder} avoiding the need
         * to create one manually via {@link DiscoveryData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiscoveryData.Builder#build()} is called immediately and its
         * result is passed to {@link #discoveryData(DiscoveryData)}.
         * 
         * @param discoveryData
         *        a consumer that will call methods on {@link DiscoveryData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #discoveryData(DiscoveryData)
         */
        default Builder discoveryData(Consumer<DiscoveryData.Builder> discoveryData) {
            return discoveryData(DiscoveryData.builder().applyMutation(discoveryData).build());
        }

        /**
         * <p>
         * Detailed information about the agent being registered.
         * </p>
         * 
         * @param agentDetails
         *        Detailed information about the agent being registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentDetails(AgentDetails agentDetails);

        /**
         * <p>
         * Detailed information about the agent being registered.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentDetails.Builder} avoiding the need
         * to create one manually via {@link AgentDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #agentDetails(AgentDetails)}.
         * 
         * @param agentDetails
         *        a consumer that will call methods on {@link AgentDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentDetails(AgentDetails)
         */
        default Builder agentDetails(Consumer<AgentDetails.Builder> agentDetails) {
            return agentDetails(AgentDetails.builder().applyMutation(agentDetails).build());
        }

        /**
         * <p>
         * Tags assigned to an <code>Agent</code>.
         * </p>
         * 
         * @param tags
         *        Tags assigned to an <code>Agent</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private DiscoveryData discoveryData;

        private AgentDetails agentDetails;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAgentRequest model) {
            super(model);
            discoveryData(model.discoveryData);
            agentDetails(model.agentDetails);
            tags(model.tags);
        }

        public final DiscoveryData.Builder getDiscoveryData() {
            return discoveryData != null ? discoveryData.toBuilder() : null;
        }

        public final void setDiscoveryData(DiscoveryData.BuilderImpl discoveryData) {
            this.discoveryData = discoveryData != null ? discoveryData.build() : null;
        }

        @Override
        public final Builder discoveryData(DiscoveryData discoveryData) {
            this.discoveryData = discoveryData;
            return this;
        }

        public final AgentDetails.Builder getAgentDetails() {
            return agentDetails != null ? agentDetails.toBuilder() : null;
        }

        public final void setAgentDetails(AgentDetails.BuilderImpl agentDetails) {
            this.agentDetails = agentDetails != null ? agentDetails.build() : null;
        }

        @Override
        public final Builder agentDetails(AgentDetails agentDetails) {
            this.agentDetails = agentDetails;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterAgentRequest build() {
            return new RegisterAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
