/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Time-tagged azimuth elevation pointing data.
 * </p>
 * <p>
 * Specifies the antenna pointing direction at a specific time offset from the segment's reference epoch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeAzEl implements SdkPojo, Serializable, ToCopyableBuilder<TimeAzEl.Builder, TimeAzEl> {
    private static final SdkField<Double> DT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("dt")
            .getter(getter(TimeAzEl::dt)).setter(setter(Builder::dt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dt").build()).build();

    private static final SdkField<Double> AZ_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("az")
            .getter(getter(TimeAzEl::az)).setter(setter(Builder::az))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("az").build()).build();

    private static final SdkField<Double> EL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("el")
            .getter(getter(TimeAzEl::el)).setter(setter(Builder::el))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("el").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DT_FIELD, AZ_FIELD, EL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double dt;

    private final Double az;

    private final Double el;

    private TimeAzEl(BuilderImpl builder) {
        this.dt = builder.dt;
        this.az = builder.az;
        this.el = builder.el;
    }

    /**
     * <p>
     * Time offset in atomic seconds from the segment's reference epoch.
     * </p>
     * <p>
     * All <code>dt</code> values within a segment must be in ascending order with no duplicates.
     * </p>
     * <p>
     * <code>dt</code> values may be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * negative
     * </p>
     * </li>
     * <li>
     * <p>
     * expressed as fractions of a second
     * </p>
     * </li>
     * <li>
     * <p>
     * expressed in scientific notation
     * </p>
     * </li>
     * </ul>
     * 
     * @return Time offset in atomic seconds from the segment's reference epoch.</p>
     *         <p>
     *         All <code>dt</code> values within a segment must be in ascending order with no duplicates.
     *         </p>
     *         <p>
     *         <code>dt</code> values may be:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         negative
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         expressed as fractions of a second
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         expressed in scientific notation
     *         </p>
     *         </li>
     */
    public final Double dt() {
        return dt;
    }

    /**
     * <p>
     * Azimuth angle at the specified time.
     * </p>
     * <p>
     * Valid ranges by unit:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DEGREE_ANGLE</code>: -180 to 360 degrees, measured clockwise from true north
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RADIAN</code>: -π to 2π radians, measured clockwise from true north
     * </p>
     * </li>
     * </ul>
     * 
     * @return Azimuth angle at the specified time.</p>
     *         <p>
     *         Valid ranges by unit:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DEGREE_ANGLE</code>: -180 to 360 degrees, measured clockwise from true north
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RADIAN</code>: -π to 2π radians, measured clockwise from true north
     *         </p>
     *         </li>
     */
    public final Double az() {
        return az;
    }

    /**
     * <p>
     * Elevation angle at the specified time.
     * </p>
     * <p>
     * Valid ranges by unit:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DEGREE_ANGLE</code>: -90 to 90 degrees, where 0 is the horizon, 90 is zenith, and negative values are below
     * the horizon
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RADIAN</code>: -π/2 to π/2 radians, where 0 is the horizon, π/2 is zenith, and negative values are below
     * the horizon
     * </p>
     * </li>
     * </ul>
     * 
     * @return Elevation angle at the specified time.</p>
     *         <p>
     *         Valid ranges by unit:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DEGREE_ANGLE</code>: -90 to 90 degrees, where 0 is the horizon, 90 is zenith, and negative values
     *         are below the horizon
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RADIAN</code>: -π/2 to π/2 radians, where 0 is the horizon, π/2 is zenith, and negative values are
     *         below the horizon
     *         </p>
     *         </li>
     */
    public final Double el() {
        return el;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dt());
        hashCode = 31 * hashCode + Objects.hashCode(az());
        hashCode = 31 * hashCode + Objects.hashCode(el());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeAzEl)) {
            return false;
        }
        TimeAzEl other = (TimeAzEl) obj;
        return Objects.equals(dt(), other.dt()) && Objects.equals(az(), other.az()) && Objects.equals(el(), other.el());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeAzEl").add("Dt", dt()).add("Az", az()).add("El", el()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dt":
            return Optional.ofNullable(clazz.cast(dt()));
        case "az":
            return Optional.ofNullable(clazz.cast(az()));
        case "el":
            return Optional.ofNullable(clazz.cast(el()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dt", DT_FIELD);
        map.put("az", AZ_FIELD);
        map.put("el", EL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeAzEl, T> g) {
        return obj -> g.apply((TimeAzEl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeAzEl> {
        /**
         * <p>
         * Time offset in atomic seconds from the segment's reference epoch.
         * </p>
         * <p>
         * All <code>dt</code> values within a segment must be in ascending order with no duplicates.
         * </p>
         * <p>
         * <code>dt</code> values may be:
         * </p>
         * <ul>
         * <li>
         * <p>
         * negative
         * </p>
         * </li>
         * <li>
         * <p>
         * expressed as fractions of a second
         * </p>
         * </li>
         * <li>
         * <p>
         * expressed in scientific notation
         * </p>
         * </li>
         * </ul>
         * 
         * @param dt
         *        Time offset in atomic seconds from the segment's reference epoch.</p>
         *        <p>
         *        All <code>dt</code> values within a segment must be in ascending order with no duplicates.
         *        </p>
         *        <p>
         *        <code>dt</code> values may be:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        negative
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        expressed as fractions of a second
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        expressed in scientific notation
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dt(Double dt);

        /**
         * <p>
         * Azimuth angle at the specified time.
         * </p>
         * <p>
         * Valid ranges by unit:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DEGREE_ANGLE</code>: -180 to 360 degrees, measured clockwise from true north
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RADIAN</code>: -π to 2π radians, measured clockwise from true north
         * </p>
         * </li>
         * </ul>
         * 
         * @param az
         *        Azimuth angle at the specified time.</p>
         *        <p>
         *        Valid ranges by unit:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DEGREE_ANGLE</code>: -180 to 360 degrees, measured clockwise from true north
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RADIAN</code>: -π to 2π radians, measured clockwise from true north
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder az(Double az);

        /**
         * <p>
         * Elevation angle at the specified time.
         * </p>
         * <p>
         * Valid ranges by unit:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DEGREE_ANGLE</code>: -90 to 90 degrees, where 0 is the horizon, 90 is zenith, and negative values are
         * below the horizon
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RADIAN</code>: -π/2 to π/2 radians, where 0 is the horizon, π/2 is zenith, and negative values are
         * below the horizon
         * </p>
         * </li>
         * </ul>
         * 
         * @param el
         *        Elevation angle at the specified time.</p>
         *        <p>
         *        Valid ranges by unit:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DEGREE_ANGLE</code>: -90 to 90 degrees, where 0 is the horizon, 90 is zenith, and negative
         *        values are below the horizon
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RADIAN</code>: -π/2 to π/2 radians, where 0 is the horizon, π/2 is zenith, and negative values
         *        are below the horizon
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder el(Double el);
    }

    static final class BuilderImpl implements Builder {
        private Double dt;

        private Double az;

        private Double el;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeAzEl model) {
            dt(model.dt);
            az(model.az);
            el(model.el);
        }

        public final Double getDt() {
            return dt;
        }

        public final void setDt(Double dt) {
            this.dt = dt;
        }

        @Override
        public final Builder dt(Double dt) {
            this.dt = dt;
            return this;
        }

        public final Double getAz() {
            return az;
        }

        public final void setAz(Double az) {
            this.az = az;
        }

        @Override
        public final Builder az(Double az) {
            this.az = az;
            return this;
        }

        public final Double getEl() {
            return el;
        }

        public final void setEl(Double el) {
            this.el = el;
        }

        @Override
        public final Builder el(Double el) {
            this.el = el;
            return this;
        }

        @Override
        public TimeAzEl build() {
            return new TimeAzEl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
