/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Overrides the default tracking configuration on an antenna during a contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrackingOverrides implements SdkPojo, Serializable,
        ToCopyableBuilder<TrackingOverrides.Builder, TrackingOverrides> {
    private static final SdkField<ProgramTrackSettings> PROGRAM_TRACK_SETTINGS_FIELD = SdkField
            .<ProgramTrackSettings> builder(MarshallingType.SDK_POJO).memberName("programTrackSettings")
            .getter(getter(TrackingOverrides::programTrackSettings)).setter(setter(Builder::programTrackSettings))
            .constructor(ProgramTrackSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programTrackSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRAM_TRACK_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProgramTrackSettings programTrackSettings;

    private TrackingOverrides(BuilderImpl builder) {
        this.programTrackSettings = builder.programTrackSettings;
    }

    /**
     * <p>
     * Program track settings to override for antenna tracking during the contact.
     * </p>
     * 
     * @return Program track settings to override for antenna tracking during the contact.
     */
    public final ProgramTrackSettings programTrackSettings() {
        return programTrackSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(programTrackSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrackingOverrides)) {
            return false;
        }
        TrackingOverrides other = (TrackingOverrides) obj;
        return Objects.equals(programTrackSettings(), other.programTrackSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrackingOverrides").add("ProgramTrackSettings", programTrackSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "programTrackSettings":
            return Optional.ofNullable(clazz.cast(programTrackSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("programTrackSettings", PROGRAM_TRACK_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrackingOverrides, T> g) {
        return obj -> g.apply((TrackingOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrackingOverrides> {
        /**
         * <p>
         * Program track settings to override for antenna tracking during the contact.
         * </p>
         * 
         * @param programTrackSettings
         *        Program track settings to override for antenna tracking during the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programTrackSettings(ProgramTrackSettings programTrackSettings);

        /**
         * <p>
         * Program track settings to override for antenna tracking during the contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProgramTrackSettings.Builder} avoiding
         * the need to create one manually via {@link ProgramTrackSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProgramTrackSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #programTrackSettings(ProgramTrackSettings)}.
         * 
         * @param programTrackSettings
         *        a consumer that will call methods on {@link ProgramTrackSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #programTrackSettings(ProgramTrackSettings)
         */
        default Builder programTrackSettings(Consumer<ProgramTrackSettings.Builder> programTrackSettings) {
            return programTrackSettings(ProgramTrackSettings.builder().applyMutation(programTrackSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProgramTrackSettings programTrackSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(TrackingOverrides model) {
            programTrackSettings(model.programTrackSettings);
        }

        public final ProgramTrackSettings.Builder getProgramTrackSettings() {
            return programTrackSettings != null ? programTrackSettings.toBuilder() : null;
        }

        public final void setProgramTrackSettings(ProgramTrackSettings.BuilderImpl programTrackSettings) {
            this.programTrackSettings = programTrackSettings != null ? programTrackSettings.build() : null;
        }

        @Override
        public final Builder programTrackSettings(ProgramTrackSettings programTrackSettings) {
            this.programTrackSettings = programTrackSettings;
            return this;
        }

        @Override
        public TrackingOverrides build() {
            return new TrackingOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
