/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAgentStatusRequest extends GroundStationRequest implements
        ToCopyableBuilder<UpdateAgentStatusRequest.Builder, UpdateAgentStatusRequest> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(UpdateAgentStatusRequest::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(UpdateAgentStatusRequest::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<AggregateStatus> AGGREGATE_STATUS_FIELD = SdkField
            .<AggregateStatus> builder(MarshallingType.SDK_POJO).memberName("aggregateStatus")
            .getter(getter(UpdateAgentStatusRequest::aggregateStatus)).setter(setter(Builder::aggregateStatus))
            .constructor(AggregateStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateStatus").build()).build();

    private static final SdkField<List<ComponentStatusData>> COMPONENT_STATUSES_FIELD = SdkField
            .<List<ComponentStatusData>> builder(MarshallingType.LIST)
            .memberName("componentStatuses")
            .getter(getter(UpdateAgentStatusRequest::componentStatuses))
            .setter(setter(Builder::componentStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentStatusData> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentStatusData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, TASK_ID_FIELD,
            AGGREGATE_STATUS_FIELD, COMPONENT_STATUSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentId;

    private final String taskId;

    private final AggregateStatus aggregateStatus;

    private final List<ComponentStatusData> componentStatuses;

    private UpdateAgentStatusRequest(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.taskId = builder.taskId;
        this.aggregateStatus = builder.aggregateStatus;
        this.componentStatuses = builder.componentStatuses;
    }

    /**
     * <p>
     * UUID of agent to update.
     * </p>
     * 
     * @return UUID of agent to update.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * GUID of agent task.
     * </p>
     * 
     * @return GUID of agent task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * Aggregate status for agent.
     * </p>
     * 
     * @return Aggregate status for agent.
     */
    public final AggregateStatus aggregateStatus() {
        return aggregateStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComponentStatuses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComponentStatuses() {
        return componentStatuses != null && !(componentStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of component statuses for agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponentStatuses} method.
     * </p>
     * 
     * @return List of component statuses for agent.
     */
    public final List<ComponentStatusData> componentStatuses() {
        return componentStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(aggregateStatus());
        hashCode = 31 * hashCode + Objects.hashCode(hasComponentStatuses() ? componentStatuses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentStatusRequest)) {
            return false;
        }
        UpdateAgentStatusRequest other = (UpdateAgentStatusRequest) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(taskId(), other.taskId())
                && Objects.equals(aggregateStatus(), other.aggregateStatus())
                && hasComponentStatuses() == other.hasComponentStatuses()
                && Objects.equals(componentStatuses(), other.componentStatuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAgentStatusRequest").add("AgentId", agentId()).add("TaskId", taskId())
                .add("AggregateStatus", aggregateStatus())
                .add("ComponentStatuses", hasComponentStatuses() ? componentStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "aggregateStatus":
            return Optional.ofNullable(clazz.cast(aggregateStatus()));
        case "componentStatuses":
            return Optional.ofNullable(clazz.cast(componentStatuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("taskId", TASK_ID_FIELD);
        map.put("aggregateStatus", AGGREGATE_STATUS_FIELD);
        map.put("componentStatuses", COMPONENT_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentStatusRequest, T> g) {
        return obj -> g.apply((UpdateAgentStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAgentStatusRequest> {
        /**
         * <p>
         * UUID of agent to update.
         * </p>
         * 
         * @param agentId
         *        UUID of agent to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * GUID of agent task.
         * </p>
         * 
         * @param taskId
         *        GUID of agent task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * Aggregate status for agent.
         * </p>
         * 
         * @param aggregateStatus
         *        Aggregate status for agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregateStatus(AggregateStatus aggregateStatus);

        /**
         * <p>
         * Aggregate status for agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregateStatus.Builder} avoiding the
         * need to create one manually via {@link AggregateStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregateStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregateStatus(AggregateStatus)}.
         * 
         * @param aggregateStatus
         *        a consumer that will call methods on {@link AggregateStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregateStatus(AggregateStatus)
         */
        default Builder aggregateStatus(Consumer<AggregateStatus.Builder> aggregateStatus) {
            return aggregateStatus(AggregateStatus.builder().applyMutation(aggregateStatus).build());
        }

        /**
         * <p>
         * List of component statuses for agent.
         * </p>
         * 
         * @param componentStatuses
         *        List of component statuses for agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentStatuses(Collection<ComponentStatusData> componentStatuses);

        /**
         * <p>
         * List of component statuses for agent.
         * </p>
         * 
         * @param componentStatuses
         *        List of component statuses for agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentStatuses(ComponentStatusData... componentStatuses);

        /**
         * <p>
         * List of component statuses for agent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.groundstation.model.ComponentStatusData.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.groundstation.model.ComponentStatusData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.groundstation.model.ComponentStatusData.Builder#build()} is called
         * immediately and its result is passed to {@link #componentStatuses(List<ComponentStatusData>)}.
         * 
         * @param componentStatuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.groundstation.model.ComponentStatusData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #componentStatuses(java.util.Collection<ComponentStatusData>)
         */
        Builder componentStatuses(Consumer<ComponentStatusData.Builder>... componentStatuses);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private String agentId;

        private String taskId;

        private AggregateStatus aggregateStatus;

        private List<ComponentStatusData> componentStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentStatusRequest model) {
            super(model);
            agentId(model.agentId);
            taskId(model.taskId);
            aggregateStatus(model.aggregateStatus);
            componentStatuses(model.componentStatuses);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final AggregateStatus.Builder getAggregateStatus() {
            return aggregateStatus != null ? aggregateStatus.toBuilder() : null;
        }

        public final void setAggregateStatus(AggregateStatus.BuilderImpl aggregateStatus) {
            this.aggregateStatus = aggregateStatus != null ? aggregateStatus.build() : null;
        }

        @Override
        public final Builder aggregateStatus(AggregateStatus aggregateStatus) {
            this.aggregateStatus = aggregateStatus;
            return this;
        }

        public final List<ComponentStatusData.Builder> getComponentStatuses() {
            List<ComponentStatusData.Builder> result = ComponentStatusListCopier.copyToBuilder(this.componentStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentStatuses(Collection<ComponentStatusData.BuilderImpl> componentStatuses) {
            this.componentStatuses = ComponentStatusListCopier.copyFromBuilder(componentStatuses);
        }

        @Override
        public final Builder componentStatuses(Collection<ComponentStatusData> componentStatuses) {
            this.componentStatuses = ComponentStatusListCopier.copy(componentStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentStatuses(ComponentStatusData... componentStatuses) {
            componentStatuses(Arrays.asList(componentStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentStatuses(Consumer<ComponentStatusData.Builder>... componentStatuses) {
            componentStatuses(Stream.of(componentStatuses).map(c -> ComponentStatusData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgentStatusRequest build() {
            return new UpdateAgentStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
