/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Definition for an uplink agent endpoint
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UplinkAwsGroundStationAgentEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<UplinkAwsGroundStationAgentEndpoint.Builder, UplinkAwsGroundStationAgentEndpoint> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UplinkAwsGroundStationAgentEndpoint::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<UplinkDataflowDetails> DATAFLOW_DETAILS_FIELD = SdkField
            .<UplinkDataflowDetails> builder(MarshallingType.SDK_POJO).memberName("dataflowDetails")
            .getter(getter(UplinkAwsGroundStationAgentEndpoint::dataflowDetails)).setter(setter(Builder::dataflowDetails))
            .constructor(UplinkDataflowDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DATAFLOW_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final UplinkDataflowDetails dataflowDetails;

    private UplinkAwsGroundStationAgentEndpoint(BuilderImpl builder) {
        this.name = builder.name;
        this.dataflowDetails = builder.dataflowDetails;
    }

    /**
     * <p>
     * Uplink dataflow endpoint name
     * </p>
     * 
     * @return Uplink dataflow endpoint name
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Dataflow details for the uplink endpoint
     * </p>
     * 
     * @return Dataflow details for the uplink endpoint
     */
    public final UplinkDataflowDetails dataflowDetails() {
        return dataflowDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataflowDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UplinkAwsGroundStationAgentEndpoint)) {
            return false;
        }
        UplinkAwsGroundStationAgentEndpoint other = (UplinkAwsGroundStationAgentEndpoint) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(dataflowDetails(), other.dataflowDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UplinkAwsGroundStationAgentEndpoint").add("Name", name())
                .add("DataflowDetails", dataflowDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dataflowDetails":
            return Optional.ofNullable(clazz.cast(dataflowDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("dataflowDetails", DATAFLOW_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UplinkAwsGroundStationAgentEndpoint, T> g) {
        return obj -> g.apply((UplinkAwsGroundStationAgentEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UplinkAwsGroundStationAgentEndpoint> {
        /**
         * <p>
         * Uplink dataflow endpoint name
         * </p>
         * 
         * @param name
         *        Uplink dataflow endpoint name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Dataflow details for the uplink endpoint
         * </p>
         * 
         * @param dataflowDetails
         *        Dataflow details for the uplink endpoint
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataflowDetails(UplinkDataflowDetails dataflowDetails);

        /**
         * <p>
         * Dataflow details for the uplink endpoint
         * </p>
         * This is a convenience method that creates an instance of the {@link UplinkDataflowDetails.Builder} avoiding
         * the need to create one manually via {@link UplinkDataflowDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UplinkDataflowDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #dataflowDetails(UplinkDataflowDetails)}.
         * 
         * @param dataflowDetails
         *        a consumer that will call methods on {@link UplinkDataflowDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataflowDetails(UplinkDataflowDetails)
         */
        default Builder dataflowDetails(Consumer<UplinkDataflowDetails.Builder> dataflowDetails) {
            return dataflowDetails(UplinkDataflowDetails.builder().applyMutation(dataflowDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private UplinkDataflowDetails dataflowDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(UplinkAwsGroundStationAgentEndpoint model) {
            name(model.name);
            dataflowDetails(model.dataflowDetails);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final UplinkDataflowDetails.Builder getDataflowDetails() {
            return dataflowDetails != null ? dataflowDetails.toBuilder() : null;
        }

        public final void setDataflowDetails(UplinkDataflowDetails.BuilderImpl dataflowDetails) {
            this.dataflowDetails = dataflowDetails != null ? dataflowDetails.build() : null;
        }

        @Override
        public final Builder dataflowDetails(UplinkDataflowDetails dataflowDetails) {
            this.dataflowDetails = dataflowDetails;
            return this;
        }

        @Override
        public UplinkAwsGroundStationAgentEndpoint build() {
            return new UplinkAwsGroundStationAgentEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
