/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Connection details for customer to Agent and Agent to Ground Station
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UplinkConnectionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<UplinkConnectionDetails.Builder, UplinkConnectionDetails> {
    private static final SdkField<ConnectionDetails> INGRESS_ADDRESS_AND_PORT_FIELD = SdkField
            .<ConnectionDetails> builder(MarshallingType.SDK_POJO).memberName("ingressAddressAndPort")
            .getter(getter(UplinkConnectionDetails::ingressAddressAndPort)).setter(setter(Builder::ingressAddressAndPort))
            .constructor(ConnectionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressAddressAndPort").build())
            .build();

    private static final SdkField<RangedConnectionDetails> AGENT_IP_AND_PORT_ADDRESS_FIELD = SdkField
            .<RangedConnectionDetails> builder(MarshallingType.SDK_POJO).memberName("agentIpAndPortAddress")
            .getter(getter(UplinkConnectionDetails::agentIpAndPortAddress)).setter(setter(Builder::agentIpAndPortAddress))
            .constructor(RangedConnectionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentIpAndPortAddress").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INGRESS_ADDRESS_AND_PORT_FIELD, AGENT_IP_AND_PORT_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConnectionDetails ingressAddressAndPort;

    private final RangedConnectionDetails agentIpAndPortAddress;

    private UplinkConnectionDetails(BuilderImpl builder) {
        this.ingressAddressAndPort = builder.ingressAddressAndPort;
        this.agentIpAndPortAddress = builder.agentIpAndPortAddress;
    }

    /**
     * Returns the value of the IngressAddressAndPort property for this object.
     * 
     * @return The value of the IngressAddressAndPort property for this object.
     */
    public final ConnectionDetails ingressAddressAndPort() {
        return ingressAddressAndPort;
    }

    /**
     * Returns the value of the AgentIpAndPortAddress property for this object.
     * 
     * @return The value of the AgentIpAndPortAddress property for this object.
     */
    public final RangedConnectionDetails agentIpAndPortAddress() {
        return agentIpAndPortAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ingressAddressAndPort());
        hashCode = 31 * hashCode + Objects.hashCode(agentIpAndPortAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UplinkConnectionDetails)) {
            return false;
        }
        UplinkConnectionDetails other = (UplinkConnectionDetails) obj;
        return Objects.equals(ingressAddressAndPort(), other.ingressAddressAndPort())
                && Objects.equals(agentIpAndPortAddress(), other.agentIpAndPortAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UplinkConnectionDetails").add("IngressAddressAndPort", ingressAddressAndPort())
                .add("AgentIpAndPortAddress", agentIpAndPortAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ingressAddressAndPort":
            return Optional.ofNullable(clazz.cast(ingressAddressAndPort()));
        case "agentIpAndPortAddress":
            return Optional.ofNullable(clazz.cast(agentIpAndPortAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ingressAddressAndPort", INGRESS_ADDRESS_AND_PORT_FIELD);
        map.put("agentIpAndPortAddress", AGENT_IP_AND_PORT_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UplinkConnectionDetails, T> g) {
        return obj -> g.apply((UplinkConnectionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UplinkConnectionDetails> {
        /**
         * Sets the value of the IngressAddressAndPort property for this object.
         *
         * @param ingressAddressAndPort
         *        The new value for the IngressAddressAndPort property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressAddressAndPort(ConnectionDetails ingressAddressAndPort);

        /**
         * Sets the value of the IngressAddressAndPort property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ConnectionDetails.Builder} avoiding the
         * need to create one manually via {@link ConnectionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #ingressAddressAndPort(ConnectionDetails)}.
         * 
         * @param ingressAddressAndPort
         *        a consumer that will call methods on {@link ConnectionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressAddressAndPort(ConnectionDetails)
         */
        default Builder ingressAddressAndPort(Consumer<ConnectionDetails.Builder> ingressAddressAndPort) {
            return ingressAddressAndPort(ConnectionDetails.builder().applyMutation(ingressAddressAndPort).build());
        }

        /**
         * Sets the value of the AgentIpAndPortAddress property for this object.
         *
         * @param agentIpAndPortAddress
         *        The new value for the AgentIpAndPortAddress property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentIpAndPortAddress(RangedConnectionDetails agentIpAndPortAddress);

        /**
         * Sets the value of the AgentIpAndPortAddress property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RangedConnectionDetails.Builder} avoiding
         * the need to create one manually via {@link RangedConnectionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RangedConnectionDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #agentIpAndPortAddress(RangedConnectionDetails)}.
         * 
         * @param agentIpAndPortAddress
         *        a consumer that will call methods on {@link RangedConnectionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentIpAndPortAddress(RangedConnectionDetails)
         */
        default Builder agentIpAndPortAddress(Consumer<RangedConnectionDetails.Builder> agentIpAndPortAddress) {
            return agentIpAndPortAddress(RangedConnectionDetails.builder().applyMutation(agentIpAndPortAddress).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConnectionDetails ingressAddressAndPort;

        private RangedConnectionDetails agentIpAndPortAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(UplinkConnectionDetails model) {
            ingressAddressAndPort(model.ingressAddressAndPort);
            agentIpAndPortAddress(model.agentIpAndPortAddress);
        }

        public final ConnectionDetails.Builder getIngressAddressAndPort() {
            return ingressAddressAndPort != null ? ingressAddressAndPort.toBuilder() : null;
        }

        public final void setIngressAddressAndPort(ConnectionDetails.BuilderImpl ingressAddressAndPort) {
            this.ingressAddressAndPort = ingressAddressAndPort != null ? ingressAddressAndPort.build() : null;
        }

        @Override
        public final Builder ingressAddressAndPort(ConnectionDetails ingressAddressAndPort) {
            this.ingressAddressAndPort = ingressAddressAndPort;
            return this;
        }

        public final RangedConnectionDetails.Builder getAgentIpAndPortAddress() {
            return agentIpAndPortAddress != null ? agentIpAndPortAddress.toBuilder() : null;
        }

        public final void setAgentIpAndPortAddress(RangedConnectionDetails.BuilderImpl agentIpAndPortAddress) {
            this.agentIpAndPortAddress = agentIpAndPortAddress != null ? agentIpAndPortAddress.build() : null;
        }

        @Override
        public final Builder agentIpAndPortAddress(RangedConnectionDetails agentIpAndPortAddress) {
            this.agentIpAndPortAddress = agentIpAndPortAddress;
            return this;
        }

        @Override
        public UplinkConnectionDetails build() {
            return new UplinkConnectionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
