/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.guardduty.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.guardduty.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.guardduty.model.ArchiveFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ArchiveFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.BadRequestException;
import software.amazon.awssdk.services.guardduty.model.CreateDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.CreateDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.CreateFilterRequest;
import software.amazon.awssdk.services.guardduty.model.CreateFilterResponse;
import software.amazon.awssdk.services.guardduty.model.CreateIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.CreateIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.CreateMembersRequest;
import software.amazon.awssdk.services.guardduty.model.CreateMembersResponse;
import software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.CreatePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.CreateSampleFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.CreateThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteFilterRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteFilterResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteMembersRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteMembersResponse;
import software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.DeletePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.DeleteThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.DescribePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.guardduty.model.DisassociateMembersRequest;
import software.amazon.awssdk.services.guardduty.model.DisassociateMembersResponse;
import software.amazon.awssdk.services.guardduty.model.GetDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.GetDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.GetFilterRequest;
import software.amazon.awssdk.services.guardduty.model.GetFilterResponse;
import software.amazon.awssdk.services.guardduty.model.GetFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.GetFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsRequest;
import software.amazon.awssdk.services.guardduty.model.GetFindingsStatisticsResponse;
import software.amazon.awssdk.services.guardduty.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.guardduty.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.guardduty.model.GetIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.GetIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.guardduty.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.guardduty.model.GetMembersRequest;
import software.amazon.awssdk.services.guardduty.model.GetMembersResponse;
import software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.GetThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.model.GuardDutyException;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.InternalServerErrorException;
import software.amazon.awssdk.services.guardduty.model.InviteMembersRequest;
import software.amazon.awssdk.services.guardduty.model.InviteMembersResponse;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest;
import software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse;
import software.amazon.awssdk.services.guardduty.model.ListFiltersRequest;
import software.amazon.awssdk.services.guardduty.model.ListFiltersResponse;
import software.amazon.awssdk.services.guardduty.model.ListFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.ListFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse;
import software.amazon.awssdk.services.guardduty.model.ListMembersRequest;
import software.amazon.awssdk.services.guardduty.model.ListMembersResponse;
import software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest;
import software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse;
import software.amazon.awssdk.services.guardduty.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.guardduty.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse;
import software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersRequest;
import software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersResponse;
import software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersRequest;
import software.amazon.awssdk.services.guardduty.model.StopMonitoringMembersResponse;
import software.amazon.awssdk.services.guardduty.model.TagResourceRequest;
import software.amazon.awssdk.services.guardduty.model.TagResourceResponse;
import software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest;
import software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsResponse;
import software.amazon.awssdk.services.guardduty.model.UntagResourceRequest;
import software.amazon.awssdk.services.guardduty.model.UntagResourceResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateDetectorRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateDetectorResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateFilterRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateFilterResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateIpSetRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateIpSetResponse;
import software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationRequest;
import software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationResponse;
import software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetRequest;
import software.amazon.awssdk.services.guardduty.model.UpdateThreatIntelSetResponse;
import software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListFiltersIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListFindingsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListIPSetsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListMembersIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsIterable;
import software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsIterable;
import software.amazon.awssdk.services.guardduty.transform.AcceptInvitationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ArchiveFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateFilterRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreatePublishingDestinationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateSampleFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.CreateThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeclineInvitationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteFilterRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteInvitationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeletePublishingDestinationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DeleteThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DescribePublishingDestinationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisassociateFromMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.DisassociateMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFilterRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetFindingsStatisticsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetInvitationsCountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.GetThreatIntelSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.InviteMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListDetectorsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListFiltersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListInvitationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListIpSetsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListPublishingDestinationsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.ListThreatIntelSetsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.StartMonitoringMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.StopMonitoringMembersRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UnarchiveFindingsRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateDetectorRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateFilterRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateFindingsFeedbackRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateIpSetRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdatePublishingDestinationRequestMarshaller;
import software.amazon.awssdk.services.guardduty.transform.UpdateThreatIntelSetRequestMarshaller;

/**
 * Internal implementation of {@link GuardDutyClient}.
 *
 * @see GuardDutyClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultGuardDutyClient implements GuardDutyClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultGuardDutyClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Accepts the invitation to be monitored by a master GuardDuty account.
     * </p>
     *
     * @param acceptInvitationRequest
     * @return Result of the AcceptInvitation operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.AcceptInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AcceptInvitation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AcceptInvitationResponse acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptInvitationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AcceptInvitationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<AcceptInvitationRequest, AcceptInvitationResponse>()
                .withOperationName("AcceptInvitation").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(acceptInvitationRequest)
                .withMarshaller(new AcceptInvitationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Archives GuardDuty findings specified by the list of finding IDs.
     * </p>
     * <note>
     * <p>
     * Only the master account can archive findings. Member accounts do not have permission to archive findings from
     * their accounts.
     * </p>
     * </note>
     *
     * @param archiveFindingsRequest
     * @return Result of the ArchiveFindings operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ArchiveFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ArchiveFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ArchiveFindingsResponse archiveFindings(ArchiveFindingsRequest archiveFindingsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ArchiveFindingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ArchiveFindingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ArchiveFindingsRequest, ArchiveFindingsResponse>()
                .withOperationName("ArchiveFindings").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(archiveFindingsRequest)
                .withMarshaller(new ArchiveFindingsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a single Amazon GuardDuty detector. A detector is a resource that represents the GuardDuty service. To
     * start using GuardDuty, you must create a detector in each region that you enable the service. You can have only
     * one detector per account per region.
     * </p>
     *
     * @param createDetectorRequest
     * @return Result of the CreateDetector operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateDetector" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDetectorResponse createDetector(CreateDetectorRequest createDetectorRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDetectorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateDetectorRequest, CreateDetectorResponse>()
                .withOperationName("CreateDetector").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createDetectorRequest)
                .withMarshaller(new CreateDetectorRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a filter using the specified finding criteria.
     * </p>
     *
     * @param createFilterRequest
     * @return Result of the CreateFilter operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFilterResponse createFilter(CreateFilterRequest createFilterRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFilterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateFilterRequest, CreateFilterResponse>()
                .withOperationName("CreateFilter").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createFilterRequest)
                .withMarshaller(new CreateFilterRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new IPSet, called Trusted IP list in the consoler user interface. An IPSet is a list IP addresses
     * trusted for secure communication with AWS infrastructure and applications. GuardDuty does not generate findings
     * for IP addresses included in IPSets. Only users from the master account can use this operation.
     * </p>
     *
     * @param createIpSetRequest
     * @return Result of the CreateIPSet operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateIPSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateIpSetResponse createIPSet(CreateIpSetRequest createIpSetRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIpSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateIpSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateIpSetRequest, CreateIpSetResponse>()
                .withOperationName("CreateIPSet").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createIpSetRequest)
                .withMarshaller(new CreateIpSetRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates member accounts of the current AWS account by specifying a list of AWS account IDs. The current AWS
     * account can then invite these members to manage GuardDuty in their accounts.
     * </p>
     *
     * @param createMembersRequest
     * @return Result of the CreateMembers operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateMembersResponse createMembers(CreateMembersRequest createMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateMembersRequest, CreateMembersResponse>()
                .withOperationName("CreateMembers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createMembersRequest)
                .withMarshaller(new CreateMembersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a publishing destination to send findings to. The resource to send findings to must exist before you use
     * this operation.
     * </p>
     *
     * @param createPublishingDestinationRequest
     * @return Result of the CreatePublishingDestination operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreatePublishingDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreatePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePublishingDestinationResponse createPublishingDestination(
            CreatePublishingDestinationRequest createPublishingDestinationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePublishingDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePublishingDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreatePublishingDestinationRequest, CreatePublishingDestinationResponse>()
                        .withOperationName("CreatePublishingDestination").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createPublishingDestinationRequest)
                        .withMarshaller(new CreatePublishingDestinationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Generates example findings of types specified by the list of finding types. If 'NULL' is specified for
     * <code>findingTypes</code>, the API generates example findings of all supported finding types.
     * </p>
     *
     * @param createSampleFindingsRequest
     * @return Result of the CreateSampleFindings operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateSampleFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateSampleFindings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateSampleFindingsResponse createSampleFindings(CreateSampleFindingsRequest createSampleFindingsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSampleFindingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSampleFindingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateSampleFindingsRequest, CreateSampleFindingsResponse>()
                .withOperationName("CreateSampleFindings").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createSampleFindingsRequest)
                .withMarshaller(new CreateSampleFindingsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Create a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses. GuardDuty generates
     * findings based on ThreatIntelSets. Only users of the master account can use this operation.
     * </p>
     *
     * @param createThreatIntelSetRequest
     * @return Result of the CreateThreatIntelSet operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.CreateThreatIntelSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateThreatIntelSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateThreatIntelSetResponse createThreatIntelSet(CreateThreatIntelSetRequest createThreatIntelSetRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateThreatIntelSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateThreatIntelSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateThreatIntelSetRequest, CreateThreatIntelSetResponse>()
                .withOperationName("CreateThreatIntelSet").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createThreatIntelSetRequest)
                .withMarshaller(new CreateThreatIntelSetRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Declines invitations sent to the current member account by AWS account specified by their account IDs.
     * </p>
     *
     * @param declineInvitationsRequest
     * @return Result of the DeclineInvitations operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeclineInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeclineInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeclineInvitationsResponse declineInvitations(DeclineInvitationsRequest declineInvitationsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeclineInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeclineInvitationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeclineInvitationsRequest, DeclineInvitationsResponse>()
                .withOperationName("DeclineInvitations").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(declineInvitationsRequest)
                .withMarshaller(new DeclineInvitationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a Amazon GuardDuty detector specified by the detector ID.
     * </p>
     *
     * @param deleteDetectorRequest
     * @return Result of the DeleteDetector operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteDetector" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDetectorResponse deleteDetector(DeleteDetectorRequest deleteDetectorRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDetectorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteDetectorRequest, DeleteDetectorResponse>()
                .withOperationName("DeleteDetector").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteDetectorRequest)
                .withMarshaller(new DeleteDetectorRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the filter specified by the filter name.
     * </p>
     *
     * @param deleteFilterRequest
     * @return Result of the DeleteFilter operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFilterResponse deleteFilter(DeleteFilterRequest deleteFilterRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFilterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteFilterRequest, DeleteFilterResponse>()
                .withOperationName("DeleteFilter").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteFilterRequest)
                .withMarshaller(new DeleteFilterRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the IPSet specified by the <code>ipSetId</code>. IPSets are called Trusted IP lists in the console user
     * interface.
     * </p>
     *
     * @param deleteIpSetRequest
     * @return Result of the DeleteIPSet operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteIPSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteIpSetResponse deleteIPSet(DeleteIpSetRequest deleteIpSetRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIpSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteIpSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteIpSetRequest, DeleteIpSetResponse>()
                .withOperationName("DeleteIPSet").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteIpSetRequest)
                .withMarshaller(new DeleteIpSetRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes invitations sent to the current member account by AWS accounts specified by their account IDs.
     * </p>
     *
     * @param deleteInvitationsRequest
     * @return Result of the DeleteInvitations operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteInvitationsResponse deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteInvitationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteInvitationsRequest, DeleteInvitationsResponse>()
                .withOperationName("DeleteInvitations").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteInvitationsRequest)
                .withMarshaller(new DeleteInvitationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes GuardDuty member accounts (to the current GuardDuty master account) specified by the account IDs.
     * </p>
     *
     * @param deleteMembersRequest
     * @return Result of the DeleteMembers operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteMembersResponse deleteMembers(DeleteMembersRequest deleteMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteMembersRequest, DeleteMembersResponse>()
                .withOperationName("DeleteMembers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteMembersRequest)
                .withMarshaller(new DeleteMembersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the publishing definition with the specified <code>destinationId</code>.
     * </p>
     *
     * @param deletePublishingDestinationRequest
     * @return Result of the DeletePublishingDestination operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeletePublishingDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeletePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeletePublishingDestinationResponse deletePublishingDestination(
            DeletePublishingDestinationRequest deletePublishingDestinationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePublishingDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePublishingDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeletePublishingDestinationRequest, DeletePublishingDestinationResponse>()
                        .withOperationName("DeletePublishingDestination").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deletePublishingDestinationRequest)
                        .withMarshaller(new DeletePublishingDestinationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes ThreatIntelSet specified by the ThreatIntelSet ID.
     * </p>
     *
     * @param deleteThreatIntelSetRequest
     * @return Result of the DeleteThreatIntelSet operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DeleteThreatIntelSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DeleteThreatIntelSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteThreatIntelSetResponse deleteThreatIntelSet(DeleteThreatIntelSetRequest deleteThreatIntelSetRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteThreatIntelSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteThreatIntelSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteThreatIntelSetRequest, DeleteThreatIntelSetResponse>()
                .withOperationName("DeleteThreatIntelSet").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteThreatIntelSetRequest)
                .withMarshaller(new DeleteThreatIntelSetRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about the publishing destination specified by the provided <code>destinationId</code>.
     * </p>
     *
     * @param describePublishingDestinationRequest
     * @return Result of the DescribePublishingDestination operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DescribePublishingDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DescribePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePublishingDestinationResponse describePublishingDestination(
            DescribePublishingDestinationRequest describePublishingDestinationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePublishingDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePublishingDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DescribePublishingDestinationRequest, DescribePublishingDestinationResponse>()
                        .withOperationName("DescribePublishingDestination").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(describePublishingDestinationRequest)
                        .withMarshaller(new DescribePublishingDestinationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disassociates the current GuardDuty member account from its master account.
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     * @return Result of the DisassociateFromMasterAccount operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DisassociateFromMasterAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateFromMasterAccountResponse disassociateFromMasterAccount(
            DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateFromMasterAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateFromMasterAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateFromMasterAccountRequest, DisassociateFromMasterAccountResponse>()
                        .withOperationName("DisassociateFromMasterAccount").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(disassociateFromMasterAccountRequest)
                        .withMarshaller(new DisassociateFromMasterAccountRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disassociates GuardDuty member accounts (to the current GuardDuty master account) specified by the account IDs.
     * </p>
     *
     * @param disassociateMembersRequest
     * @return Result of the DisassociateMembers operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.DisassociateMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DisassociateMembers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DisassociateMembersResponse disassociateMembers(DisassociateMembersRequest disassociateMembersRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DisassociateMembersRequest, DisassociateMembersResponse>()
                .withOperationName("DisassociateMembers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(disassociateMembersRequest)
                .withMarshaller(new DisassociateMembersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves an Amazon GuardDuty detector specified by the detectorId.
     * </p>
     *
     * @param getDetectorRequest
     * @return Result of the GetDetector operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetDetector" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDetectorResponse getDetector(GetDetectorRequest getDetectorRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDetectorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetDetectorRequest, GetDetectorResponse>()
                .withOperationName("GetDetector").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDetectorRequest)
                .withMarshaller(new GetDetectorRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the details of the filter specified by the filter name.
     * </p>
     *
     * @param getFilterRequest
     * @return Result of the GetFilter operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetFilterResponse getFilter(GetFilterRequest getFilterRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFilterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetFilterRequest, GetFilterResponse>()
                .withOperationName("GetFilter").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getFilterRequest)
                .withMarshaller(new GetFilterRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describes Amazon GuardDuty findings specified by finding IDs.
     * </p>
     *
     * @param getFindingsRequest
     * @return Result of the GetFindings operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetFindingsResponse getFindings(GetFindingsRequest getFindingsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFindingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFindingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetFindingsRequest, GetFindingsResponse>()
                .withOperationName("GetFindings").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getFindingsRequest)
                .withMarshaller(new GetFindingsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists Amazon GuardDuty findings' statistics for the specified detector ID.
     * </p>
     *
     * @param getFindingsStatisticsRequest
     * @return Result of the GetFindingsStatistics operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetFindingsStatistics
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetFindingsStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFindingsStatisticsResponse getFindingsStatistics(GetFindingsStatisticsRequest getFindingsStatisticsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFindingsStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetFindingsStatisticsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetFindingsStatisticsRequest, GetFindingsStatisticsResponse>()
                .withOperationName("GetFindingsStatistics").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getFindingsStatisticsRequest)
                .withMarshaller(new GetFindingsStatisticsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the IPSet specified by the <code>ipSetId</code>.
     * </p>
     *
     * @param getIpSetRequest
     * @return Result of the GetIPSet operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetIPSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetIpSetResponse getIPSet(GetIpSetRequest getIpSetRequest) throws BadRequestException, InternalServerErrorException,
            AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIpSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetIpSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetIpSetRequest, GetIpSetResponse>().withOperationName("GetIPSet")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getIpSetRequest)
                .withMarshaller(new GetIpSetRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the count of all GuardDuty membership invitations that were sent to the current member account except the
     * currently accepted invitation.
     * </p>
     *
     * @param getInvitationsCountRequest
     * @return Result of the GetInvitationsCount operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetInvitationsCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetInvitationsCount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetInvitationsCountResponse getInvitationsCount(GetInvitationsCountRequest getInvitationsCountRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetInvitationsCountResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetInvitationsCountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetInvitationsCountRequest, GetInvitationsCountResponse>()
                .withOperationName("GetInvitationsCount").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getInvitationsCountRequest)
                .withMarshaller(new GetInvitationsCountRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Provides the details for the GuardDuty master account associated with the current GuardDuty member account.
     * </p>
     *
     * @param getMasterAccountRequest
     * @return Result of the GetMasterAccount operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetMasterAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMasterAccount" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMasterAccountResponse getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMasterAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMasterAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetMasterAccountRequest, GetMasterAccountResponse>()
                .withOperationName("GetMasterAccount").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getMasterAccountRequest)
                .withMarshaller(new GetMasterAccountRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves GuardDuty member accounts (to the current GuardDuty master account) specified by the account IDs.
     * </p>
     *
     * @param getMembersRequest
     * @return Result of the GetMembers operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMembersResponse getMembers(GetMembersRequest getMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetMembersRequest, GetMembersResponse>()
                .withOperationName("GetMembers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getMembersRequest)
                .withMarshaller(new GetMembersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.
     * </p>
     *
     * @param getThreatIntelSetRequest
     * @return Result of the GetThreatIntelSet operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.GetThreatIntelSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GetThreatIntelSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetThreatIntelSetResponse getThreatIntelSet(GetThreatIntelSetRequest getThreatIntelSetRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetThreatIntelSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetThreatIntelSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetThreatIntelSetRequest, GetThreatIntelSetResponse>()
                .withOperationName("GetThreatIntelSet").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getThreatIntelSetRequest)
                .withMarshaller(new GetThreatIntelSetRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Invites other AWS accounts (created as members of the current AWS account by CreateMembers) to enable GuardDuty
     * and allow the current AWS account to view and manage these accounts' GuardDuty findings on their behalf as the
     * master account.
     * </p>
     *
     * @param inviteMembersRequest
     * @return Result of the InviteMembers operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.InviteMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public InviteMembersResponse inviteMembers(InviteMembersRequest inviteMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<InviteMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                InviteMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<InviteMembersRequest, InviteMembersResponse>()
                .withOperationName("InviteMembers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(inviteMembersRequest)
                .withMarshaller(new InviteMembersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists detectorIds of all the existing Amazon GuardDuty detector resources.
     * </p>
     *
     * @param listDetectorsRequest
     * @return Result of the ListDetectors operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListDetectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDetectorsResponse listDetectors(ListDetectorsRequest listDetectorsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDetectorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDetectorsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListDetectorsRequest, ListDetectorsResponse>()
                .withOperationName("ListDetectors").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listDetectorsRequest)
                .withMarshaller(new ListDetectorsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists detectorIds of all the existing Amazon GuardDuty detector resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable responses = client.listDetectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable responses = client.listDetectorsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListDetectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListDetectorsIterable responses = client.listDetectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDetectors(software.amazon.awssdk.services.guardduty.model.ListDetectorsRequest)} operation.</b>
     * </p>
     *
     * @param listDetectorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListDetectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDetectorsIterable listDetectorsPaginator(ListDetectorsRequest listDetectorsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListDetectorsIterable(this, applyPaginatorUserAgent(listDetectorsRequest));
    }

    /**
     * <p>
     * Returns a paginated list of the current filters.
     * </p>
     *
     * @param listFiltersRequest
     * @return Result of the ListFilters operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListFilters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFiltersResponse listFilters(ListFiltersRequest listFiltersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFiltersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFiltersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListFiltersRequest, ListFiltersResponse>()
                .withOperationName("ListFilters").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listFiltersRequest)
                .withMarshaller(new ListFiltersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a paginated list of the current filters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFilters(software.amazon.awssdk.services.guardduty.model.ListFiltersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListFiltersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFiltersIterable responses = client.listFiltersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFilters(software.amazon.awssdk.services.guardduty.model.ListFiltersRequest)} operation.</b>
     * </p>
     *
     * @param listFiltersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListFilters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFiltersIterable listFiltersPaginator(ListFiltersRequest listFiltersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListFiltersIterable(this, applyPaginatorUserAgent(listFiltersRequest));
    }

    /**
     * <p>
     * Lists Amazon GuardDuty findings for the specified detector ID.
     * </p>
     *
     * @param listFindingsRequest
     * @return Result of the ListFindings operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFindingsResponse listFindings(ListFindingsRequest listFindingsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFindingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFindingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListFindingsRequest, ListFindingsResponse>()
                .withOperationName("ListFindings").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listFindingsRequest)
                .withMarshaller(new ListFindingsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists Amazon GuardDuty findings for the specified detector ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.guardduty.model.ListFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.guardduty.model.ListFindingsRequest)} operation.</b>
     * </p>
     *
     * @param listFindingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFindingsIterable listFindingsPaginator(ListFindingsRequest listFindingsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListFindingsIterable(this, applyPaginatorUserAgent(listFindingsRequest));
    }

    /**
     * <p>
     * Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this operation from a member
     * account, the IPSets returned are the IPSets from the associated master account.
     * </p>
     *
     * @param listIpSetsRequest
     * @return Result of the ListIPSets operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListIPSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListIpSetsResponse listIPSets(ListIpSetsRequest listIpSetsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIpSetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListIpSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListIpSetsRequest, ListIpSetsResponse>()
                .withOperationName("ListIPSets").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listIpSetsRequest)
                .withMarshaller(new ListIpSetsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this operation from a member
     * account, the IPSets returned are the IPSets from the associated master account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIPSets(software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListIPSetsIterable responses = client.listIPSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListIPSetsIterable responses = client.listIPSetsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListIpSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListIPSetsIterable responses = client.listIPSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIPSets(software.amazon.awssdk.services.guardduty.model.ListIpSetsRequest)} operation.</b>
     * </p>
     *
     * @param listIpSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListIPSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListIPSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListIPSetsIterable listIPSetsPaginator(ListIpSetsRequest listIpSetsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListIPSetsIterable(this, applyPaginatorUserAgent(listIpSetsRequest));
    }

    /**
     * <p>
     * Lists all GuardDuty membership invitations that were sent to the current AWS account.
     * </p>
     *
     * @param listInvitationsRequest
     * @return Result of the ListInvitations operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListInvitationsResponse listInvitations(ListInvitationsRequest listInvitationsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListInvitationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListInvitationsRequest, ListInvitationsResponse>()
                .withOperationName("ListInvitations").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listInvitationsRequest)
                .withMarshaller(new ListInvitationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all GuardDuty membership invitations that were sent to the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable responses = client
     *             .listInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.guardduty.model.ListInvitationsRequest)} operation.</b>
     * </p>
     *
     * @param listInvitationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListInvitations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListInvitationsIterable listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListInvitationsIterable(this, applyPaginatorUserAgent(listInvitationsRequest));
    }

    /**
     * <p>
     * Lists details about all member accounts for the current GuardDuty master account.
     * </p>
     *
     * @param listMembersRequest
     * @return Result of the ListMembers operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListMembersRequest, ListMembersResponse>()
                .withOperationName("ListMembers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listMembersRequest)
                .withMarshaller(new ListMembersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists details about all member accounts for the current GuardDuty master account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.guardduty.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.guardduty.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListMembersIterable listMembersPaginator(ListMembersRequest listMembersRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListMembersIterable(this, applyPaginatorUserAgent(listMembersRequest));
    }

    /**
     * <p>
     * Returns a list of publishing destinations associated with the specified <code>dectectorId</code>.
     * </p>
     *
     * @param listPublishingDestinationsRequest
     * @return Result of the ListPublishingDestinations operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListPublishingDestinations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListPublishingDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPublishingDestinationsResponse listPublishingDestinations(
            ListPublishingDestinationsRequest listPublishingDestinationsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPublishingDestinationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPublishingDestinationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListPublishingDestinationsRequest, ListPublishingDestinationsResponse>()
                        .withOperationName("ListPublishingDestinations").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(listPublishingDestinationsRequest)
                        .withMarshaller(new ListPublishingDestinationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of publishing destinations associated with the specified <code>dectectorId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPublishingDestinations(software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsIterable responses = client.listPublishingDestinationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsIterable responses = client
     *             .listPublishingDestinationsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListPublishingDestinationsIterable responses = client.listPublishingDestinationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPublishingDestinations(software.amazon.awssdk.services.guardduty.model.ListPublishingDestinationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPublishingDestinationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListPublishingDestinations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListPublishingDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPublishingDestinationsIterable listPublishingDestinationsPaginator(
            ListPublishingDestinationsRequest listPublishingDestinationsRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListPublishingDestinationsIterable(this, applyPaginatorUserAgent(listPublishingDestinationsRequest));
    }

    /**
     * <p>
     * Lists tags for a resource. Tagging is currently supported for detectors, finding filters, IP sets, and Threat
     * Intel sets, with a limit of 50 tags per resource. When invoked, this operation returns all assigned tags for a
     * given resource..
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use this operation from a
     * member account, the ThreatIntelSets associated with the master account are returned.
     * </p>
     *
     * @param listThreatIntelSetsRequest
     * @return Result of the ListThreatIntelSets operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListThreatIntelSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListThreatIntelSetsResponse listThreatIntelSets(ListThreatIntelSetsRequest listThreatIntelSetsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThreatIntelSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListThreatIntelSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListThreatIntelSetsRequest, ListThreatIntelSetsResponse>()
                .withOperationName("ListThreatIntelSets").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listThreatIntelSetsRequest)
                .withMarshaller(new ListThreatIntelSetsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use this operation from a
     * member account, the ThreatIntelSets associated with the master account are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listThreatIntelSets(software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsIterable responses = client.listThreatIntelSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsIterable responses = client
     *             .listThreatIntelSetsPaginator(request);
     *     for (software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.guardduty.paginators.ListThreatIntelSetsIterable responses = client.listThreatIntelSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThreatIntelSets(software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listThreatIntelSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.ListThreatIntelSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ListThreatIntelSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListThreatIntelSetsIterable listThreatIntelSetsPaginator(ListThreatIntelSetsRequest listThreatIntelSetsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        return new ListThreatIntelSetsIterable(this, applyPaginatorUserAgent(listThreatIntelSetsRequest));
    }

    /**
     * <p>
     * Turns on GuardDuty monitoring of the specified member accounts. Use this operation to restart monitoring of
     * accounts that you stopped monitoring with the <code>StopMonitoringMembers</code> operation.
     * </p>
     *
     * @param startMonitoringMembersRequest
     * @return Result of the StartMonitoringMembers operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.StartMonitoringMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StartMonitoringMembers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartMonitoringMembersResponse startMonitoringMembers(StartMonitoringMembersRequest startMonitoringMembersRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartMonitoringMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartMonitoringMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StartMonitoringMembersRequest, StartMonitoringMembersResponse>()
                .withOperationName("StartMonitoringMembers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(startMonitoringMembersRequest)
                .withMarshaller(new StartMonitoringMembersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Stops GuardDuty monitoring for the specified member accounnts. Use the <code>StartMonitoringMembers</code> to
     * restart monitoring for those accounts.
     * </p>
     *
     * @param stopMonitoringMembersRequest
     * @return Result of the StopMonitoringMembers operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.StopMonitoringMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/StopMonitoringMembers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopMonitoringMembersResponse stopMonitoringMembers(StopMonitoringMembersRequest stopMonitoringMembersRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopMonitoringMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopMonitoringMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StopMonitoringMembersRequest, StopMonitoringMembersResponse>()
                .withOperationName("StopMonitoringMembers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(stopMonitoringMembersRequest)
                .withMarshaller(new StopMonitoringMembersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                .withOperationName("TagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Unarchives GuardDuty findings specified by the <code>findingIds</code>.
     * </p>
     *
     * @param unarchiveFindingsRequest
     * @return Result of the UnarchiveFindings operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UnarchiveFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UnarchiveFindings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UnarchiveFindingsResponse unarchiveFindings(UnarchiveFindingsRequest unarchiveFindingsRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UnarchiveFindingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UnarchiveFindingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UnarchiveFindingsRequest, UnarchiveFindingsResponse>()
                .withOperationName("UnarchiveFindings").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(unarchiveFindingsRequest)
                .withMarshaller(new UnarchiveFindingsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                .withOperationName("UntagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the Amazon GuardDuty detector specified by the detectorId.
     * </p>
     *
     * @param updateDetectorRequest
     * @return Result of the UpdateDetector operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateDetector" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateDetectorResponse updateDetector(UpdateDetectorRequest updateDetectorRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDetectorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDetectorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateDetectorRequest, UpdateDetectorResponse>()
                .withOperationName("UpdateDetector").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateDetectorRequest)
                .withMarshaller(new UpdateDetectorRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the filter specified by the filter name.
     * </p>
     *
     * @param updateFilterRequest
     * @return Result of the UpdateFilter operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateFilter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateFilterResponse updateFilter(UpdateFilterRequest updateFilterRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFilterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateFilterRequest, UpdateFilterResponse>()
                .withOperationName("UpdateFilter").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateFilterRequest)
                .withMarshaller(new UpdateFilterRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Marks the specified GuardDuty findings as useful or not useful.
     * </p>
     *
     * @param updateFindingsFeedbackRequest
     * @return Result of the UpdateFindingsFeedback operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateFindingsFeedback
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateFindingsFeedback"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFindingsFeedbackResponse updateFindingsFeedback(UpdateFindingsFeedbackRequest updateFindingsFeedbackRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFindingsFeedbackResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFindingsFeedbackResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateFindingsFeedbackRequest, UpdateFindingsFeedbackResponse>()
                .withOperationName("UpdateFindingsFeedback").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateFindingsFeedbackRequest)
                .withMarshaller(new UpdateFindingsFeedbackRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the IPSet specified by the IPSet ID.
     * </p>
     *
     * @param updateIpSetRequest
     * @return Result of the UpdateIPSet operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateIPSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateIPSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateIpSetResponse updateIPSet(UpdateIpSetRequest updateIpSetRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIpSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateIpSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateIpSetRequest, UpdateIpSetResponse>()
                .withOperationName("UpdateIPSet").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateIpSetRequest)
                .withMarshaller(new UpdateIpSetRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates information about the publishing destination specified by the <code>destinationId</code>.
     * </p>
     *
     * @param updatePublishingDestinationRequest
     * @return Result of the UpdatePublishingDestination operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdatePublishingDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdatePublishingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePublishingDestinationResponse updatePublishingDestination(
            UpdatePublishingDestinationRequest updatePublishingDestinationRequest) throws BadRequestException,
            InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePublishingDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePublishingDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdatePublishingDestinationRequest, UpdatePublishingDestinationResponse>()
                        .withOperationName("UpdatePublishingDestination").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updatePublishingDestinationRequest)
                        .withMarshaller(new UpdatePublishingDestinationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the ThreatIntelSet specified by ThreatIntelSet ID.
     * </p>
     *
     * @param updateThreatIntelSetRequest
     * @return Result of the UpdateThreatIntelSet operation returned by the service.
     * @throws BadRequestException
     *         Bad request exception object.
     * @throws InternalServerErrorException
     *         Internal server error exception object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GuardDutyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GuardDutyClient.UpdateThreatIntelSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UpdateThreatIntelSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateThreatIntelSetResponse updateThreatIntelSet(UpdateThreatIntelSetRequest updateThreatIntelSetRequest)
            throws BadRequestException, InternalServerErrorException, AwsServiceException, SdkClientException, GuardDutyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateThreatIntelSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateThreatIntelSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateThreatIntelSetRequest, UpdateThreatIntelSetResponse>()
                .withOperationName("UpdateThreatIntelSet").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateThreatIntelSetRequest)
                .withMarshaller(new UpdateThreatIntelSetRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(GuardDutyException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends GuardDutyRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
