/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIpSetResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetIpSetResponse.Builder, GetIpSetResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetIpSetResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetIpSetResponse::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetIpSetResponse::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetIpSetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetIpSetResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FORMAT_FIELD,
            LOCATION_FIELD, STATUS_FIELD, TAGS_FIELD));

    private final String name;

    private final String format;

    private final String location;

    private final String status;

    private final Map<String, String> tags;

    private GetIpSetResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.format = builder.format;
        this.location = builder.location;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The user friendly name for the IPSet.
     * </p>
     * 
     * @return The user friendly name for the IPSet.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The format of the file that contains the IPSet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link IpSetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the file that contains the IPSet.
     * @see IpSetFormat
     */
    public IpSetFormat format() {
        return IpSetFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the file that contains the IPSet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link IpSetFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the file that contains the IPSet.
     * @see IpSetFormat
     */
    public String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The URI of the file that contains the IPSet. For example
     * (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key)
     * </p>
     * 
     * @return The URI of the file that contains the IPSet. For example
     *         (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key)
     */
    public String location() {
        return location;
    }

    /**
     * <p>
     * The status of ipSet file uploaded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IpSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of ipSet file uploaded.
     * @see IpSetStatus
     */
    public IpSetStatus status() {
        return IpSetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of ipSet file uploaded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IpSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of ipSet file uploaded.
     * @see IpSetStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The tags of the IP set resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags of the IP set resource.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpSetResponse)) {
            return false;
        }
        GetIpSetResponse other = (GetIpSetResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(location(), other.location()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetIpSetResponse").add("Name", name()).add("Format", formatAsString())
                .add("Location", location()).add("Status", statusAsString()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIpSetResponse, T> g) {
        return obj -> g.apply((GetIpSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIpSetResponse> {
        /**
         * <p>
         * The user friendly name for the IPSet.
         * </p>
         * 
         * @param name
         *        The user friendly name for the IPSet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The format of the file that contains the IPSet.
         * </p>
         * 
         * @param format
         *        The format of the file that contains the IPSet.
         * @see IpSetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpSetFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the file that contains the IPSet.
         * </p>
         * 
         * @param format
         *        The format of the file that contains the IPSet.
         * @see IpSetFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpSetFormat
         */
        Builder format(IpSetFormat format);

        /**
         * <p>
         * The URI of the file that contains the IPSet. For example
         * (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key)
         * </p>
         * 
         * @param location
         *        The URI of the file that contains the IPSet. For example
         *        (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The status of ipSet file uploaded.
         * </p>
         * 
         * @param status
         *        The status of ipSet file uploaded.
         * @see IpSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpSetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of ipSet file uploaded.
         * </p>
         * 
         * @param status
         *        The status of ipSet file uploaded.
         * @see IpSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpSetStatus
         */
        Builder status(IpSetStatus status);

        /**
         * <p>
         * The tags of the IP set resource.
         * </p>
         * 
         * @param tags
         *        The tags of the IP set resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private String name;

        private String format;

        private String location;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpSetResponse model) {
            super(model);
            name(model.name);
            format(model.format);
            location(model.location);
            status(model.status);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFormatAsString() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(IpSetFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IpSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public GetIpSetResponse build() {
            return new GetIpSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
