/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class InvitationsCopier {
    static List<Invitation> copy(Collection<Invitation> invitationsParam) {
        if (invitationsParam == null || invitationsParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<Invitation> invitationsParamCopy = new ArrayList<>(invitationsParam);
        return Collections.unmodifiableList(invitationsParamCopy);
    }

    static List<Invitation> copyFromBuilder(Collection<? extends Invitation.Builder> invitationsParam) {
        if (invitationsParam == null) {
            return null;
        }
        return copy(invitationsParam.stream().map(Invitation.Builder::build).collect(toList()));
    }
}
