/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Continas information about the ISP organization of the remote IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Organization implements SdkPojo, Serializable, ToCopyableBuilder<Organization.Builder, Organization> {
    private static final SdkField<String> ASN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Organization::asn)).setter(setter(Builder::asn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()).build();

    private static final SdkField<String> ASN_ORG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Organization::asnOrg)).setter(setter(Builder::asnOrg))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asnOrg").build()).build();

    private static final SdkField<String> ISP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Organization::isp)).setter(setter(Builder::isp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isp").build()).build();

    private static final SdkField<String> ORG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Organization::org)).setter(setter(Builder::org))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("org").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASN_FIELD, ASN_ORG_FIELD,
            ISP_FIELD, ORG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String asn;

    private final String asnOrg;

    private final String isp;

    private final String org;

    private Organization(BuilderImpl builder) {
        this.asn = builder.asn;
        this.asnOrg = builder.asnOrg;
        this.isp = builder.isp;
        this.org = builder.org;
    }

    /**
     * <p>
     * Autonomous system number of the internet provider of the remote IP address.
     * </p>
     * 
     * @return Autonomous system number of the internet provider of the remote IP address.
     */
    public String asn() {
        return asn;
    }

    /**
     * <p>
     * Organization that registered this ASN.
     * </p>
     * 
     * @return Organization that registered this ASN.
     */
    public String asnOrg() {
        return asnOrg;
    }

    /**
     * <p>
     * ISP information for the internet provider.
     * </p>
     * 
     * @return ISP information for the internet provider.
     */
    public String isp() {
        return isp;
    }

    /**
     * <p>
     * Name of the internet provider.
     * </p>
     * 
     * @return Name of the internet provider.
     */
    public String org() {
        return org;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(asn());
        hashCode = 31 * hashCode + Objects.hashCode(asnOrg());
        hashCode = 31 * hashCode + Objects.hashCode(isp());
        hashCode = 31 * hashCode + Objects.hashCode(org());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Organization)) {
            return false;
        }
        Organization other = (Organization) obj;
        return Objects.equals(asn(), other.asn()) && Objects.equals(asnOrg(), other.asnOrg())
                && Objects.equals(isp(), other.isp()) && Objects.equals(org(), other.org());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Organization").add("Asn", asn()).add("AsnOrg", asnOrg()).add("Isp", isp()).add("Org", org())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Asn":
            return Optional.ofNullable(clazz.cast(asn()));
        case "AsnOrg":
            return Optional.ofNullable(clazz.cast(asnOrg()));
        case "Isp":
            return Optional.ofNullable(clazz.cast(isp()));
        case "Org":
            return Optional.ofNullable(clazz.cast(org()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Organization, T> g) {
        return obj -> g.apply((Organization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Organization> {
        /**
         * <p>
         * Autonomous system number of the internet provider of the remote IP address.
         * </p>
         * 
         * @param asn
         *        Autonomous system number of the internet provider of the remote IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asn(String asn);

        /**
         * <p>
         * Organization that registered this ASN.
         * </p>
         * 
         * @param asnOrg
         *        Organization that registered this ASN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asnOrg(String asnOrg);

        /**
         * <p>
         * ISP information for the internet provider.
         * </p>
         * 
         * @param isp
         *        ISP information for the internet provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isp(String isp);

        /**
         * <p>
         * Name of the internet provider.
         * </p>
         * 
         * @param org
         *        Name of the internet provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder org(String org);
    }

    static final class BuilderImpl implements Builder {
        private String asn;

        private String asnOrg;

        private String isp;

        private String org;

        private BuilderImpl() {
        }

        private BuilderImpl(Organization model) {
            asn(model.asn);
            asnOrg(model.asnOrg);
            isp(model.isp);
            org(model.org);
        }

        public final String getAsn() {
            return asn;
        }

        @Override
        public final Builder asn(String asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(String asn) {
            this.asn = asn;
        }

        public final String getAsnOrg() {
            return asnOrg;
        }

        @Override
        public final Builder asnOrg(String asnOrg) {
            this.asnOrg = asnOrg;
            return this;
        }

        public final void setAsnOrg(String asnOrg) {
            this.asnOrg = asnOrg;
        }

        public final String getIsp() {
            return isp;
        }

        @Override
        public final Builder isp(String isp) {
            this.isp = isp;
            return this;
        }

        public final void setIsp(String isp) {
            this.isp = isp;
        }

        public final String getOrg() {
            return org;
        }

        @Override
        public final Builder org(String org) {
            this.org = org;
            return this;
        }

        public final void setOrg(String org) {
            this.org = org;
        }

        @Override
        public Organization build() {
            return new Organization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
