/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the AWS resource associated with the activity that prompted GuardDuty to generate a
 * finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<AccessKeyDetails> ACCESS_KEY_DETAILS_FIELD = SdkField
            .<AccessKeyDetails> builder(MarshallingType.SDK_POJO).getter(getter(Resource::accessKeyDetails))
            .setter(setter(Builder::accessKeyDetails)).constructor(AccessKeyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyDetails").build()).build();

    private static final SdkField<InstanceDetails> INSTANCE_DETAILS_FIELD = SdkField
            .<InstanceDetails> builder(MarshallingType.SDK_POJO).getter(getter(Resource::instanceDetails))
            .setter(setter(Builder::instanceDetails)).constructor(InstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceDetails").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Resource::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_DETAILS_FIELD,
            INSTANCE_DETAILS_FIELD, RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AccessKeyDetails accessKeyDetails;

    private final InstanceDetails instanceDetails;

    private final String resourceType;

    private Resource(BuilderImpl builder) {
        this.accessKeyDetails = builder.accessKeyDetails;
        this.instanceDetails = builder.instanceDetails;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The IAM access key details (IAM user information) of a user that engaged in the activity that prompted GuardDuty
     * to generate a finding.
     * </p>
     * 
     * @return The IAM access key details (IAM user information) of a user that engaged in the activity that prompted
     *         GuardDuty to generate a finding.
     */
    public AccessKeyDetails accessKeyDetails() {
        return accessKeyDetails;
    }

    /**
     * <p>
     * The information about the EC2 instance associated with the activity that prompted GuardDuty to generate a
     * finding.
     * </p>
     * 
     * @return The information about the EC2 instance associated with the activity that prompted GuardDuty to generate a
     *         finding.
     */
    public InstanceDetails instanceDetails() {
        return instanceDetails;
    }

    /**
     * <p>
     * The type of the AWS resource.
     * </p>
     * 
     * @return The type of the AWS resource.
     */
    public String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(instanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(accessKeyDetails(), other.accessKeyDetails())
                && Objects.equals(instanceDetails(), other.instanceDetails())
                && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Resource").add("AccessKeyDetails", accessKeyDetails()).add("InstanceDetails", instanceDetails())
                .add("ResourceType", resourceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessKeyDetails":
            return Optional.ofNullable(clazz.cast(accessKeyDetails()));
        case "InstanceDetails":
            return Optional.ofNullable(clazz.cast(instanceDetails()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * <p>
         * The IAM access key details (IAM user information) of a user that engaged in the activity that prompted
         * GuardDuty to generate a finding.
         * </p>
         * 
         * @param accessKeyDetails
         *        The IAM access key details (IAM user information) of a user that engaged in the activity that prompted
         *        GuardDuty to generate a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyDetails(AccessKeyDetails accessKeyDetails);

        /**
         * <p>
         * The IAM access key details (IAM user information) of a user that engaged in the activity that prompted
         * GuardDuty to generate a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link AccessKeyDetails.Builder} avoiding the need to
         * create one manually via {@link AccessKeyDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessKeyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #accessKeyDetails(AccessKeyDetails)}.
         * 
         * @param accessKeyDetails
         *        a consumer that will call methods on {@link AccessKeyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessKeyDetails(AccessKeyDetails)
         */
        default Builder accessKeyDetails(Consumer<AccessKeyDetails.Builder> accessKeyDetails) {
            return accessKeyDetails(AccessKeyDetails.builder().applyMutation(accessKeyDetails).build());
        }

        /**
         * <p>
         * The information about the EC2 instance associated with the activity that prompted GuardDuty to generate a
         * finding.
         * </p>
         * 
         * @param instanceDetails
         *        The information about the EC2 instance associated with the activity that prompted GuardDuty to
         *        generate a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceDetails(InstanceDetails instanceDetails);

        /**
         * <p>
         * The information about the EC2 instance associated with the activity that prompted GuardDuty to generate a
         * finding.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceDetails.Builder} avoiding the need to
         * create one manually via {@link InstanceDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceDetails(InstanceDetails)}.
         * 
         * @param instanceDetails
         *        a consumer that will call methods on {@link InstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceDetails(InstanceDetails)
         */
        default Builder instanceDetails(Consumer<InstanceDetails.Builder> instanceDetails) {
            return instanceDetails(InstanceDetails.builder().applyMutation(instanceDetails).build());
        }

        /**
         * <p>
         * The type of the AWS resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the AWS resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl implements Builder {
        private AccessKeyDetails accessKeyDetails;

        private InstanceDetails instanceDetails;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            accessKeyDetails(model.accessKeyDetails);
            instanceDetails(model.instanceDetails);
            resourceType(model.resourceType);
        }

        public final AccessKeyDetails.Builder getAccessKeyDetails() {
            return accessKeyDetails != null ? accessKeyDetails.toBuilder() : null;
        }

        @Override
        public final Builder accessKeyDetails(AccessKeyDetails accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails;
            return this;
        }

        public final void setAccessKeyDetails(AccessKeyDetails.BuilderImpl accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails != null ? accessKeyDetails.build() : null;
        }

        public final InstanceDetails.Builder getInstanceDetails() {
            return instanceDetails != null ? instanceDetails.toBuilder() : null;
        }

        @Override
        public final Builder instanceDetails(InstanceDetails instanceDetails) {
            this.instanceDetails = instanceDetails;
            return this;
        }

        public final void setInstanceDetails(InstanceDetails.BuilderImpl instanceDetails) {
            this.instanceDetails = instanceDetails != null ? instanceDetails.build() : null;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
