/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFilterRequest extends GuardDutyRequest implements
        ToCopyableBuilder<UpdateFilterRequest.Builder, UpdateFilterRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFilterRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFilterRequest::filterName)).setter(setter(Builder::filterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("filterName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFilterRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFilterRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Integer> RANK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateFilterRequest::rank)).setter(setter(Builder::rank))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rank").build()).build();

    private static final SdkField<FindingCriteria> FINDING_CRITERIA_FIELD = SdkField
            .<FindingCriteria> builder(MarshallingType.SDK_POJO).getter(getter(UpdateFilterRequest::findingCriteria))
            .setter(setter(Builder::findingCriteria)).constructor(FindingCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            FILTER_NAME_FIELD, DESCRIPTION_FIELD, ACTION_FIELD, RANK_FIELD, FINDING_CRITERIA_FIELD));

    private final String detectorId;

    private final String filterName;

    private final String description;

    private final String action;

    private final Integer rank;

    private final FindingCriteria findingCriteria;

    private UpdateFilterRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.filterName = builder.filterName;
        this.description = builder.description;
        this.action = builder.action;
        this.rank = builder.rank;
        this.findingCriteria = builder.findingCriteria;
    }

    /**
     * <p>
     * The unique ID of the detector that specifies the GuardDuty service where you want to update a filter.
     * </p>
     * 
     * @return The unique ID of the detector that specifies the GuardDuty service where you want to update a filter.
     */
    public String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * 
     * @return The name of the filter.
     */
    public String filterName() {
        return filterName;
    }

    /**
     * <p>
     * The description of the filter.
     * </p>
     * 
     * @return The description of the filter.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the action that is to be applied to the findings that match the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies the action that is to be applied to the findings that match the filter.
     * @see FilterAction
     */
    public FilterAction action() {
        return FilterAction.fromValue(action);
    }

    /**
     * <p>
     * Specifies the action that is to be applied to the findings that match the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specifies the action that is to be applied to the findings that match the filter.
     * @see FilterAction
     */
    public String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Specifies the position of the filter in the list of current filters. Also specifies the order in which this
     * filter is applied to the findings.
     * </p>
     * 
     * @return Specifies the position of the filter in the list of current filters. Also specifies the order in which
     *         this filter is applied to the findings.
     */
    public Integer rank() {
        return rank;
    }

    /**
     * <p>
     * Represents the criteria to be used in the filter for querying findings.
     * </p>
     * 
     * @return Represents the criteria to be used in the filter for querying findings.
     */
    public FindingCriteria findingCriteria() {
        return findingCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(filterName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rank());
        hashCode = 31 * hashCode + Objects.hashCode(findingCriteria());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFilterRequest)) {
            return false;
        }
        UpdateFilterRequest other = (UpdateFilterRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(filterName(), other.filterName())
                && Objects.equals(description(), other.description()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(rank(), other.rank()) && Objects.equals(findingCriteria(), other.findingCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateFilterRequest").add("DetectorId", detectorId()).add("FilterName", filterName())
                .add("Description", description()).add("Action", actionAsString()).add("Rank", rank())
                .add("FindingCriteria", findingCriteria()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "FilterName":
            return Optional.ofNullable(clazz.cast(filterName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Rank":
            return Optional.ofNullable(clazz.cast(rank()));
        case "FindingCriteria":
            return Optional.ofNullable(clazz.cast(findingCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFilterRequest, T> g) {
        return obj -> g.apply((UpdateFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFilterRequest> {
        /**
         * <p>
         * The unique ID of the detector that specifies the GuardDuty service where you want to update a filter.
         * </p>
         * 
         * @param detectorId
         *        The unique ID of the detector that specifies the GuardDuty service where you want to update a filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param filterName
         *        The name of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterName(String filterName);

        /**
         * <p>
         * The description of the filter.
         * </p>
         * 
         * @param description
         *        The description of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the action that is to be applied to the findings that match the filter.
         * </p>
         * 
         * @param action
         *        Specifies the action that is to be applied to the findings that match the filter.
         * @see FilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specifies the action that is to be applied to the findings that match the filter.
         * </p>
         * 
         * @param action
         *        Specifies the action that is to be applied to the findings that match the filter.
         * @see FilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterAction
         */
        Builder action(FilterAction action);

        /**
         * <p>
         * Specifies the position of the filter in the list of current filters. Also specifies the order in which this
         * filter is applied to the findings.
         * </p>
         * 
         * @param rank
         *        Specifies the position of the filter in the list of current filters. Also specifies the order in which
         *        this filter is applied to the findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rank(Integer rank);

        /**
         * <p>
         * Represents the criteria to be used in the filter for querying findings.
         * </p>
         * 
         * @param findingCriteria
         *        Represents the criteria to be used in the filter for querying findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingCriteria(FindingCriteria findingCriteria);

        /**
         * <p>
         * Represents the criteria to be used in the filter for querying findings.
         * </p>
         * This is a convenience that creates an instance of the {@link FindingCriteria.Builder} avoiding the need to
         * create one manually via {@link FindingCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link FindingCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #findingCriteria(FindingCriteria)}.
         * 
         * @param findingCriteria
         *        a consumer that will call methods on {@link FindingCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingCriteria(FindingCriteria)
         */
        default Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return findingCriteria(FindingCriteria.builder().applyMutation(findingCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String filterName;

        private String description;

        private String action;

        private Integer rank;

        private FindingCriteria findingCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFilterRequest model) {
            super(model);
            detectorId(model.detectorId);
            filterName(model.filterName);
            description(model.description);
            action(model.action);
            rank(model.rank);
            findingCriteria(model.findingCriteria);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getFilterName() {
            return filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getActionAsString() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(FilterAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Integer getRank() {
            return rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return findingCriteria != null ? findingCriteria.toBuilder() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFilterRequest build() {
            return new UpdateFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
