/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsRequest;
import software.amazon.awssdk.services.guardduty.model.ListThreatIntelSetsResponse;

public class ListThreatIntelSetsIterable
implements SdkIterable<ListThreatIntelSetsResponse> {
    private final GuardDutyClient client;
    private final ListThreatIntelSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThreatIntelSetsIterable(GuardDutyClient client, ListThreatIntelSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListThreatIntelSetsResponseFetcher();
    }

    public Iterator<ListThreatIntelSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> threatIntelSetIds() {
        Function<ListThreatIntelSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.threatIntelSetIds() != null) {
                return response.threatIntelSetIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThreatIntelSetsResponseFetcher
    implements SyncPageFetcher<ListThreatIntelSetsResponse> {
        private ListThreatIntelSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListThreatIntelSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThreatIntelSetsResponse nextPage(ListThreatIntelSetsResponse previousPage) {
            if (previousPage == null) {
                return ListThreatIntelSetsIterable.this.client.listThreatIntelSets(ListThreatIntelSetsIterable.this.firstRequest);
            }
            return ListThreatIntelSetsIterable.this.client.listThreatIntelSets((ListThreatIntelSetsRequest)((Object)ListThreatIntelSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

