/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the finding, which is generated when abnormal or suspicious activity is detected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Finding implements SdkPojo, Serializable, ToCopyableBuilder<Finding.Builder, Finding> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(Finding::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Finding::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Confidence").getter(getter(Finding::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidence").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedAt").getter(getter(Finding::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Finding::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Finding::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> PARTITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Partition").getter(getter(Finding::partition)).setter(setter(Builder::partition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partition").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(Finding::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("Resource").getter(getter(Finding::resource)).setter(setter(Builder::resource))
            .constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersion").getter(getter(Finding::schemaVersion)).setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final SdkField<Service> SERVICE_FIELD = SdkField.<Service> builder(MarshallingType.SDK_POJO)
            .memberName("Service").getter(getter(Finding::service)).setter(setter(Builder::service))
            .constructor(Service::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<Double> SEVERITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Severity").getter(getter(Finding::severity)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(Finding::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Finding::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> UPDATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedAt").getter(getter(Finding::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ARN_FIELD,
            CONFIDENCE_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, ID_FIELD, PARTITION_FIELD, REGION_FIELD, RESOURCE_FIELD,
            SCHEMA_VERSION_FIELD, SERVICE_FIELD, SEVERITY_FIELD, TITLE_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String arn;

    private final Double confidence;

    private final String createdAt;

    private final String description;

    private final String id;

    private final String partition;

    private final String region;

    private final Resource resource;

    private final String schemaVersion;

    private final Service service;

    private final Double severity;

    private final String title;

    private final String type;

    private final String updatedAt;

    private Finding(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.arn = builder.arn;
        this.confidence = builder.confidence;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.partition = builder.partition;
        this.region = builder.region;
        this.resource = builder.resource;
        this.schemaVersion = builder.schemaVersion;
        this.service = builder.service;
        this.severity = builder.severity;
        this.title = builder.title;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The ID of the account in which the finding was generated.
     * </p>
     * 
     * @return The ID of the account in which the finding was generated.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ARN of the finding.
     * </p>
     * 
     * @return The ARN of the finding.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The confidence score for the finding.
     * </p>
     * 
     * @return The confidence score for the finding.
     */
    public Double confidence() {
        return confidence;
    }

    /**
     * <p>
     * The time and date when the finding was created.
     * </p>
     * 
     * @return The time and date when the finding was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description of the finding.
     * </p>
     * 
     * @return The description of the finding.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the finding.
     * </p>
     * 
     * @return The ID of the finding.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The partition associated with the finding.
     * </p>
     * 
     * @return The partition associated with the finding.
     */
    public String partition() {
        return partition;
    }

    /**
     * <p>
     * The Region where the finding was generated.
     * </p>
     * 
     * @return The Region where the finding was generated.
     */
    public String region() {
        return region;
    }

    /**
     * Returns the value of the Resource property for this object.
     * 
     * @return The value of the Resource property for this object.
     */
    public Resource resource() {
        return resource;
    }

    /**
     * <p>
     * The version of the schema used for the finding.
     * </p>
     * 
     * @return The version of the schema used for the finding.
     */
    public String schemaVersion() {
        return schemaVersion;
    }

    /**
     * Returns the value of the Service property for this object.
     * 
     * @return The value of the Service property for this object.
     */
    public Service service() {
        return service;
    }

    /**
     * <p>
     * The severity of the finding.
     * </p>
     * 
     * @return The severity of the finding.
     */
    public Double severity() {
        return severity;
    }

    /**
     * <p>
     * The title of the finding.
     * </p>
     * 
     * @return The title of the finding.
     */
    public String title() {
        return title;
    }

    /**
     * <p>
     * The type of finding.
     * </p>
     * 
     * @return The type of finding.
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The time and date when the finding was last updated.
     * </p>
     * 
     * @return The time and date when the finding was last updated.
     */
    public String updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(partition());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(confidence(), other.confidence()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(description(), other.description()) && Objects.equals(id(), other.id())
                && Objects.equals(partition(), other.partition()) && Objects.equals(region(), other.region())
                && Objects.equals(resource(), other.resource()) && Objects.equals(schemaVersion(), other.schemaVersion())
                && Objects.equals(service(), other.service()) && Objects.equals(severity(), other.severity())
                && Objects.equals(title(), other.title()) && Objects.equals(type(), other.type())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Finding").add("AccountId", accountId()).add("Arn", arn()).add("Confidence", confidence())
                .add("CreatedAt", createdAt()).add("Description", description()).add("Id", id()).add("Partition", partition())
                .add("Region", region()).add("Resource", resource()).add("SchemaVersion", schemaVersion())
                .add("Service", service()).add("Severity", severity()).add("Title", title()).add("Type", type())
                .add("UpdatedAt", updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Partition":
            return Optional.ofNullable(clazz.cast(partition()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "SchemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Finding, T> g) {
        return obj -> g.apply((Finding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Finding> {
        /**
         * <p>
         * The ID of the account in which the finding was generated.
         * </p>
         * 
         * @param accountId
         *        The ID of the account in which the finding was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ARN of the finding.
         * </p>
         * 
         * @param arn
         *        The ARN of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The confidence score for the finding.
         * </p>
         * 
         * @param confidence
         *        The confidence score for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Double confidence);

        /**
         * <p>
         * The time and date when the finding was created.
         * </p>
         * 
         * @param createdAt
         *        The time and date when the finding was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * The description of the finding.
         * </p>
         * 
         * @param description
         *        The description of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the finding.
         * </p>
         * 
         * @param id
         *        The ID of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The partition associated with the finding.
         * </p>
         * 
         * @param partition
         *        The partition associated with the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partition(String partition);

        /**
         * <p>
         * The Region where the finding was generated.
         * </p>
         * 
         * @param region
         *        The Region where the finding was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * Sets the value of the Resource property for this object.
         *
         * @param resource
         *        The new value for the Resource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(Resource resource);

        /**
         * Sets the value of the Resource property for this object.
         *
         * This is a convenience that creates an instance of the {@link Resource.Builder} avoiding the need to create
         * one manually via {@link Resource#builder()}.
         *
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #resource(Resource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(Resource)
         */
        default Builder resource(Consumer<Resource.Builder> resource) {
            return resource(Resource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * The version of the schema used for the finding.
         * </p>
         * 
         * @param schemaVersion
         *        The version of the schema used for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * Sets the value of the Service property for this object.
         *
         * @param service
         *        The new value for the Service property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(Service service);

        /**
         * Sets the value of the Service property for this object.
         *
         * This is a convenience that creates an instance of the {@link Service.Builder} avoiding the need to create one
         * manually via {@link Service#builder()}.
         *
         * When the {@link Consumer} completes, {@link Service.Builder#build()} is called immediately and its result is
         * passed to {@link #service(Service)}.
         * 
         * @param service
         *        a consumer that will call methods on {@link Service.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #service(Service)
         */
        default Builder service(Consumer<Service.Builder> service) {
            return service(Service.builder().applyMutation(service).build());
        }

        /**
         * <p>
         * The severity of the finding.
         * </p>
         * 
         * @param severity
         *        The severity of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(Double severity);

        /**
         * <p>
         * The title of the finding.
         * </p>
         * 
         * @param title
         *        The title of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The type of finding.
         * </p>
         * 
         * @param type
         *        The type of finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The time and date when the finding was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The time and date when the finding was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(String updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String arn;

        private Double confidence;

        private String createdAt;

        private String description;

        private String id;

        private String partition;

        private String region;

        private Resource resource;

        private String schemaVersion;

        private Service service;

        private Double severity;

        private String title;

        private String type;

        private String updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Finding model) {
            accountId(model.accountId);
            arn(model.arn);
            confidence(model.confidence);
            createdAt(model.createdAt);
            description(model.description);
            id(model.id);
            partition(model.partition);
            region(model.region);
            resource(model.resource);
            schemaVersion(model.schemaVersion);
            service(model.service);
            severity(model.severity);
            title(model.title);
            type(model.type);
            updatedAt(model.updatedAt);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Double getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getPartition() {
            return partition;
        }

        @Override
        public final Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        public final void setPartition(String partition) {
            this.partition = partition;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final Resource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final Service.Builder getService() {
            return service != null ? service.toBuilder() : null;
        }

        @Override
        public final Builder service(Service service) {
            this.service = service;
            return this;
        }

        public final void setService(Service.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        public final Double getSeverity() {
            return severity;
        }

        @Override
        public final Builder severity(Double severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(Double severity) {
            this.severity = severity;
        }

        public final String getTitle() {
            return title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public Finding build() {
            return new Finding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
