/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDetectorResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetDetectorResponse.Builder, GetDetectorResponse> {
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedAt").getter(getter(GetDetectorResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> FINDING_PUBLISHING_FREQUENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FindingPublishingFrequency")
            .getter(getter(GetDetectorResponse::findingPublishingFrequencyAsString))
            .setter(setter(Builder::findingPublishingFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingPublishingFrequency").build())
            .build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(GetDetectorResponse::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetDetectorResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> UPDATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedAt").getter(getter(GetDetectorResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<DataSourceConfigurationsResult> DATA_SOURCES_FIELD = SdkField
            .<DataSourceConfigurationsResult> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(GetDetectorResponse::dataSources)).setter(setter(Builder::dataSources))
            .constructor(DataSourceConfigurationsResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetDetectorResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            FINDING_PUBLISHING_FREQUENCY_FIELD, SERVICE_ROLE_FIELD, STATUS_FIELD, UPDATED_AT_FIELD, DATA_SOURCES_FIELD,
            TAGS_FIELD));

    private final String createdAt;

    private final String findingPublishingFrequency;

    private final String serviceRole;

    private final String status;

    private final String updatedAt;

    private final DataSourceConfigurationsResult dataSources;

    private final Map<String, String> tags;

    private GetDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.findingPublishingFrequency = builder.findingPublishingFrequency;
        this.serviceRole = builder.serviceRole;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.dataSources = builder.dataSources;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The timestamp of when the detector was created.
     * </p>
     * 
     * @return The timestamp of when the detector was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The publishing frequency of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #findingPublishingFrequency} will return {@link FindingPublishingFrequency#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #findingPublishingFrequencyAsString}.
     * </p>
     * 
     * @return The publishing frequency of the finding.
     * @see FindingPublishingFrequency
     */
    public FindingPublishingFrequency findingPublishingFrequency() {
        return FindingPublishingFrequency.fromValue(findingPublishingFrequency);
    }

    /**
     * <p>
     * The publishing frequency of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #findingPublishingFrequency} will return {@link FindingPublishingFrequency#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #findingPublishingFrequencyAsString}.
     * </p>
     * 
     * @return The publishing frequency of the finding.
     * @see FindingPublishingFrequency
     */
    public String findingPublishingFrequencyAsString() {
        return findingPublishingFrequency;
    }

    /**
     * <p>
     * The GuardDuty service role.
     * </p>
     * 
     * @return The GuardDuty service role.
     */
    public String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The detector status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DetectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The detector status.
     * @see DetectorStatus
     */
    public DetectorStatus status() {
        return DetectorStatus.fromValue(status);
    }

    /**
     * <p>
     * The detector status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DetectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The detector status.
     * @see DetectorStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The last-updated timestamp for the detector.
     * </p>
     * 
     * @return The last-updated timestamp for the detector.
     */
    public String updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * An object that describes which data sources are enabled for the detector.
     * </p>
     * 
     * @return An object that describes which data sources are enabled for the detector.
     */
    public DataSourceConfigurationsResult dataSources() {
        return dataSources;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the detector resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags of the detector resource.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(findingPublishingFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDetectorResponse)) {
            return false;
        }
        GetDetectorResponse other = (GetDetectorResponse) obj;
        return Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(findingPublishingFrequencyAsString(), other.findingPublishingFrequencyAsString())
                && Objects.equals(serviceRole(), other.serviceRole()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(dataSources(), other.dataSources())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDetectorResponse").add("CreatedAt", createdAt())
                .add("FindingPublishingFrequency", findingPublishingFrequencyAsString()).add("ServiceRole", serviceRole())
                .add("Status", statusAsString()).add("UpdatedAt", updatedAt()).add("DataSources", dataSources())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "FindingPublishingFrequency":
            return Optional.ofNullable(clazz.cast(findingPublishingFrequencyAsString()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDetectorResponse, T> g) {
        return obj -> g.apply((GetDetectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDetectorResponse> {
        /**
         * <p>
         * The timestamp of when the detector was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the detector was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * The publishing frequency of the finding.
         * </p>
         * 
         * @param findingPublishingFrequency
         *        The publishing frequency of the finding.
         * @see FindingPublishingFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingPublishingFrequency
         */
        Builder findingPublishingFrequency(String findingPublishingFrequency);

        /**
         * <p>
         * The publishing frequency of the finding.
         * </p>
         * 
         * @param findingPublishingFrequency
         *        The publishing frequency of the finding.
         * @see FindingPublishingFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingPublishingFrequency
         */
        Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency);

        /**
         * <p>
         * The GuardDuty service role.
         * </p>
         * 
         * @param serviceRole
         *        The GuardDuty service role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The detector status.
         * </p>
         * 
         * @param status
         *        The detector status.
         * @see DetectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The detector status.
         * </p>
         * 
         * @param status
         *        The detector status.
         * @see DetectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetectorStatus
         */
        Builder status(DetectorStatus status);

        /**
         * <p>
         * The last-updated timestamp for the detector.
         * </p>
         * 
         * @param updatedAt
         *        The last-updated timestamp for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(String updatedAt);

        /**
         * <p>
         * An object that describes which data sources are enabled for the detector.
         * </p>
         * 
         * @param dataSources
         *        An object that describes which data sources are enabled for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSourceConfigurationsResult dataSources);

        /**
         * <p>
         * An object that describes which data sources are enabled for the detector.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSourceConfigurationsResult.Builder} avoiding
         * the need to create one manually via {@link DataSourceConfigurationsResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceConfigurationsResult.Builder#build()} is called
         * immediately and its result is passed to {@link #dataSources(DataSourceConfigurationsResult)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link DataSourceConfigurationsResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(DataSourceConfigurationsResult)
         */
        default Builder dataSources(Consumer<DataSourceConfigurationsResult.Builder> dataSources) {
            return dataSources(DataSourceConfigurationsResult.builder().applyMutation(dataSources).build());
        }

        /**
         * <p>
         * The tags of the detector resource.
         * </p>
         * 
         * @param tags
         *        The tags of the detector resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private String createdAt;

        private String findingPublishingFrequency;

        private String serviceRole;

        private String status;

        private String updatedAt;

        private DataSourceConfigurationsResult dataSources;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDetectorResponse model) {
            super(model);
            createdAt(model.createdAt);
            findingPublishingFrequency(model.findingPublishingFrequency);
            serviceRole(model.serviceRole);
            status(model.status);
            updatedAt(model.updatedAt);
            dataSources(model.dataSources);
            tags(model.tags);
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getFindingPublishingFrequency() {
            return findingPublishingFrequency;
        }

        @Override
        public final Builder findingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
            return this;
        }

        @Override
        public final Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency) {
            this.findingPublishingFrequency(findingPublishingFrequency == null ? null : findingPublishingFrequency.toString());
            return this;
        }

        public final void setFindingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DetectorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final DataSourceConfigurationsResult.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        @Override
        public final Builder dataSources(DataSourceConfigurationsResult dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final void setDataSources(DataSourceConfigurationsResult.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public GetDetectorResponse build() {
            return new GetDetectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
