/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the member account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Member implements SdkPojo, Serializable, ToCopyableBuilder<Member.Builder, Member> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(Member::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(Member::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> MASTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterId").getter(getter(Member::masterId)).setter(setter(Builder::masterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterId").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(Member::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()).build();

    private static final SdkField<String> RELATIONSHIP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelationshipStatus").getter(getter(Member::relationshipStatus))
            .setter(setter(Builder::relationshipStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipStatus").build())
            .build();

    private static final SdkField<String> INVITED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvitedAt").getter(getter(Member::invitedAt)).setter(setter(Builder::invitedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitedAt").build()).build();

    private static final SdkField<String> UPDATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedAt").getter(getter(Member::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            DETECTOR_ID_FIELD, MASTER_ID_FIELD, EMAIL_FIELD, RELATIONSHIP_STATUS_FIELD, INVITED_AT_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String detectorId;

    private final String masterId;

    private final String email;

    private final String relationshipStatus;

    private final String invitedAt;

    private final String updatedAt;

    private Member(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.detectorId = builder.detectorId;
        this.masterId = builder.masterId;
        this.email = builder.email;
        this.relationshipStatus = builder.relationshipStatus;
        this.invitedAt = builder.invitedAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The ID of the member account.
     * </p>
     * 
     * @return The ID of the member account.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The detector ID of the member account.
     * </p>
     * 
     * @return The detector ID of the member account.
     */
    public String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The master account ID.
     * </p>
     * 
     * @return The master account ID.
     */
    public String masterId() {
        return masterId;
    }

    /**
     * <p>
     * The email address of the member account.
     * </p>
     * 
     * @return The email address of the member account.
     */
    public String email() {
        return email;
    }

    /**
     * <p>
     * The status of the relationship between the member and the master.
     * </p>
     * 
     * @return The status of the relationship between the member and the master.
     */
    public String relationshipStatus() {
        return relationshipStatus;
    }

    /**
     * <p>
     * The timestamp when the invitation was sent.
     * </p>
     * 
     * @return The timestamp when the invitation was sent.
     */
    public String invitedAt() {
        return invitedAt;
    }

    /**
     * <p>
     * The last-updated timestamp of the member.
     * </p>
     * 
     * @return The last-updated timestamp of the member.
     */
    public String updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(masterId());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(relationshipStatus());
        hashCode = 31 * hashCode + Objects.hashCode(invitedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Member)) {
            return false;
        }
        Member other = (Member) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(detectorId(), other.detectorId())
                && Objects.equals(masterId(), other.masterId()) && Objects.equals(email(), other.email())
                && Objects.equals(relationshipStatus(), other.relationshipStatus())
                && Objects.equals(invitedAt(), other.invitedAt()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Member").add("AccountId", accountId()).add("DetectorId", detectorId())
                .add("MasterId", masterId()).add("Email", email()).add("RelationshipStatus", relationshipStatus())
                .add("InvitedAt", invitedAt()).add("UpdatedAt", updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "MasterId":
            return Optional.ofNullable(clazz.cast(masterId()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "RelationshipStatus":
            return Optional.ofNullable(clazz.cast(relationshipStatus()));
        case "InvitedAt":
            return Optional.ofNullable(clazz.cast(invitedAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Member, T> g) {
        return obj -> g.apply((Member) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Member> {
        /**
         * <p>
         * The ID of the member account.
         * </p>
         * 
         * @param accountId
         *        The ID of the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The detector ID of the member account.
         * </p>
         * 
         * @param detectorId
         *        The detector ID of the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The master account ID.
         * </p>
         * 
         * @param masterId
         *        The master account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterId(String masterId);

        /**
         * <p>
         * The email address of the member account.
         * </p>
         * 
         * @param email
         *        The email address of the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The status of the relationship between the member and the master.
         * </p>
         * 
         * @param relationshipStatus
         *        The status of the relationship between the member and the master.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationshipStatus(String relationshipStatus);

        /**
         * <p>
         * The timestamp when the invitation was sent.
         * </p>
         * 
         * @param invitedAt
         *        The timestamp when the invitation was sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitedAt(String invitedAt);

        /**
         * <p>
         * The last-updated timestamp of the member.
         * </p>
         * 
         * @param updatedAt
         *        The last-updated timestamp of the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(String updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String detectorId;

        private String masterId;

        private String email;

        private String relationshipStatus;

        private String invitedAt;

        private String updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Member model) {
            accountId(model.accountId);
            detectorId(model.detectorId);
            masterId(model.masterId);
            email(model.email);
            relationshipStatus(model.relationshipStatus);
            invitedAt(model.invitedAt);
            updatedAt(model.updatedAt);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getMasterId() {
            return masterId;
        }

        @Override
        public final Builder masterId(String masterId) {
            this.masterId = masterId;
            return this;
        }

        public final void setMasterId(String masterId) {
            this.masterId = masterId;
        }

        public final String getEmail() {
            return email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getRelationshipStatus() {
            return relationshipStatus;
        }

        @Override
        public final Builder relationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
            return this;
        }

        public final void setRelationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
        }

        public final String getInvitedAt() {
            return invitedAt;
        }

        @Override
        public final Builder invitedAt(String invitedAt) {
            this.invitedAt = invitedAt;
            return this;
        }

        public final void setInvitedAt(String invitedAt) {
            this.invitedAt = invitedAt;
        }

        public final String getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public Member build() {
            return new Member(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
