/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the remote IP address of the connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoteIpDetails implements SdkPojo, Serializable, ToCopyableBuilder<RemoteIpDetails.Builder, RemoteIpDetails> {
    private static final SdkField<City> CITY_FIELD = SdkField.<City> builder(MarshallingType.SDK_POJO).memberName("City")
            .getter(getter(RemoteIpDetails::city)).setter(setter(Builder::city)).constructor(City::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("city").build()).build();

    private static final SdkField<Country> COUNTRY_FIELD = SdkField.<Country> builder(MarshallingType.SDK_POJO)
            .memberName("Country").getter(getter(RemoteIpDetails::country)).setter(setter(Builder::country))
            .constructor(Country::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("country").build()).build();

    private static final SdkField<GeoLocation> GEO_LOCATION_FIELD = SdkField.<GeoLocation> builder(MarshallingType.SDK_POJO)
            .memberName("GeoLocation").getter(getter(RemoteIpDetails::geoLocation)).setter(setter(Builder::geoLocation))
            .constructor(GeoLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("geoLocation").build()).build();

    private static final SdkField<String> IP_ADDRESS_V4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressV4").getter(getter(RemoteIpDetails::ipAddressV4)).setter(setter(Builder::ipAddressV4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressV4").build()).build();

    private static final SdkField<Organization> ORGANIZATION_FIELD = SdkField.<Organization> builder(MarshallingType.SDK_POJO)
            .memberName("Organization").getter(getter(RemoteIpDetails::organization)).setter(setter(Builder::organization))
            .constructor(Organization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organization").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITY_FIELD, COUNTRY_FIELD,
            GEO_LOCATION_FIELD, IP_ADDRESS_V4_FIELD, ORGANIZATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final City city;

    private final Country country;

    private final GeoLocation geoLocation;

    private final String ipAddressV4;

    private final Organization organization;

    private RemoteIpDetails(BuilderImpl builder) {
        this.city = builder.city;
        this.country = builder.country;
        this.geoLocation = builder.geoLocation;
        this.ipAddressV4 = builder.ipAddressV4;
        this.organization = builder.organization;
    }

    /**
     * <p>
     * The city information of the remote IP address.
     * </p>
     * 
     * @return The city information of the remote IP address.
     */
    public City city() {
        return city;
    }

    /**
     * <p>
     * The country code of the remote IP address.
     * </p>
     * 
     * @return The country code of the remote IP address.
     */
    public Country country() {
        return country;
    }

    /**
     * <p>
     * The location information of the remote IP address.
     * </p>
     * 
     * @return The location information of the remote IP address.
     */
    public GeoLocation geoLocation() {
        return geoLocation;
    }

    /**
     * <p>
     * The IPv4 remote address of the connection.
     * </p>
     * 
     * @return The IPv4 remote address of the connection.
     */
    public String ipAddressV4() {
        return ipAddressV4;
    }

    /**
     * <p>
     * The ISP organization information of the remote IP address.
     * </p>
     * 
     * @return The ISP organization information of the remote IP address.
     */
    public Organization organization() {
        return organization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(geoLocation());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressV4());
        hashCode = 31 * hashCode + Objects.hashCode(organization());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoteIpDetails)) {
            return false;
        }
        RemoteIpDetails other = (RemoteIpDetails) obj;
        return Objects.equals(city(), other.city()) && Objects.equals(country(), other.country())
                && Objects.equals(geoLocation(), other.geoLocation()) && Objects.equals(ipAddressV4(), other.ipAddressV4())
                && Objects.equals(organization(), other.organization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RemoteIpDetails").add("City", city()).add("Country", country())
                .add("GeoLocation", geoLocation()).add("IpAddressV4", ipAddressV4()).add("Organization", organization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "GeoLocation":
            return Optional.ofNullable(clazz.cast(geoLocation()));
        case "IpAddressV4":
            return Optional.ofNullable(clazz.cast(ipAddressV4()));
        case "Organization":
            return Optional.ofNullable(clazz.cast(organization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoteIpDetails, T> g) {
        return obj -> g.apply((RemoteIpDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemoteIpDetails> {
        /**
         * <p>
         * The city information of the remote IP address.
         * </p>
         * 
         * @param city
         *        The city information of the remote IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(City city);

        /**
         * <p>
         * The city information of the remote IP address.
         * </p>
         * This is a convenience that creates an instance of the {@link City.Builder} avoiding the need to create one
         * manually via {@link City#builder()}.
         *
         * When the {@link Consumer} completes, {@link City.Builder#build()} is called immediately and its result is
         * passed to {@link #city(City)}.
         * 
         * @param city
         *        a consumer that will call methods on {@link City.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #city(City)
         */
        default Builder city(Consumer<City.Builder> city) {
            return city(City.builder().applyMutation(city).build());
        }

        /**
         * <p>
         * The country code of the remote IP address.
         * </p>
         * 
         * @param country
         *        The country code of the remote IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(Country country);

        /**
         * <p>
         * The country code of the remote IP address.
         * </p>
         * This is a convenience that creates an instance of the {@link Country.Builder} avoiding the need to create one
         * manually via {@link Country#builder()}.
         *
         * When the {@link Consumer} completes, {@link Country.Builder#build()} is called immediately and its result is
         * passed to {@link #country(Country)}.
         * 
         * @param country
         *        a consumer that will call methods on {@link Country.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #country(Country)
         */
        default Builder country(Consumer<Country.Builder> country) {
            return country(Country.builder().applyMutation(country).build());
        }

        /**
         * <p>
         * The location information of the remote IP address.
         * </p>
         * 
         * @param geoLocation
         *        The location information of the remote IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoLocation(GeoLocation geoLocation);

        /**
         * <p>
         * The location information of the remote IP address.
         * </p>
         * This is a convenience that creates an instance of the {@link GeoLocation.Builder} avoiding the need to create
         * one manually via {@link GeoLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link GeoLocation.Builder#build()} is called immediately and its result
         * is passed to {@link #geoLocation(GeoLocation)}.
         * 
         * @param geoLocation
         *        a consumer that will call methods on {@link GeoLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoLocation(GeoLocation)
         */
        default Builder geoLocation(Consumer<GeoLocation.Builder> geoLocation) {
            return geoLocation(GeoLocation.builder().applyMutation(geoLocation).build());
        }

        /**
         * <p>
         * The IPv4 remote address of the connection.
         * </p>
         * 
         * @param ipAddressV4
         *        The IPv4 remote address of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddressV4(String ipAddressV4);

        /**
         * <p>
         * The ISP organization information of the remote IP address.
         * </p>
         * 
         * @param organization
         *        The ISP organization information of the remote IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organization(Organization organization);

        /**
         * <p>
         * The ISP organization information of the remote IP address.
         * </p>
         * This is a convenience that creates an instance of the {@link Organization.Builder} avoiding the need to
         * create one manually via {@link Organization#builder()}.
         *
         * When the {@link Consumer} completes, {@link Organization.Builder#build()} is called immediately and its
         * result is passed to {@link #organization(Organization)}.
         * 
         * @param organization
         *        a consumer that will call methods on {@link Organization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organization(Organization)
         */
        default Builder organization(Consumer<Organization.Builder> organization) {
            return organization(Organization.builder().applyMutation(organization).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private City city;

        private Country country;

        private GeoLocation geoLocation;

        private String ipAddressV4;

        private Organization organization;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoteIpDetails model) {
            city(model.city);
            country(model.country);
            geoLocation(model.geoLocation);
            ipAddressV4(model.ipAddressV4);
            organization(model.organization);
        }

        public final City.Builder getCity() {
            return city != null ? city.toBuilder() : null;
        }

        @Override
        public final Builder city(City city) {
            this.city = city;
            return this;
        }

        public final void setCity(City.BuilderImpl city) {
            this.city = city != null ? city.build() : null;
        }

        public final Country.Builder getCountry() {
            return country != null ? country.toBuilder() : null;
        }

        @Override
        public final Builder country(Country country) {
            this.country = country;
            return this;
        }

        public final void setCountry(Country.BuilderImpl country) {
            this.country = country != null ? country.build() : null;
        }

        public final GeoLocation.Builder getGeoLocation() {
            return geoLocation != null ? geoLocation.toBuilder() : null;
        }

        @Override
        public final Builder geoLocation(GeoLocation geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        public final void setGeoLocation(GeoLocation.BuilderImpl geoLocation) {
            this.geoLocation = geoLocation != null ? geoLocation.build() : null;
        }

        public final String getIpAddressV4() {
            return ipAddressV4;
        }

        @Override
        public final Builder ipAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
            return this;
        }

        public final void setIpAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
        }

        public final Organization.Builder getOrganization() {
            return organization != null ? organization.toBuilder() : null;
        }

        @Override
        public final Builder organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        public final void setOrganization(Organization.BuilderImpl organization) {
            this.organization = organization != null ? organization.build() : null;
        }

        @Override
        public RemoteIpDetails build() {
            return new RemoteIpDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
