/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the total usage with the corresponding currency unit for that value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Total implements SdkPojo, Serializable, ToCopyableBuilder<Total.Builder, Total> {
    private static final SdkField<String> AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Amount")
            .getter(getter(Total::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(Total::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD, UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String amount;

    private final String unit;

    private Total(BuilderImpl builder) {
        this.amount = builder.amount;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The total usage.
     * </p>
     * 
     * @return The total usage.
     */
    public String amount() {
        return amount;
    }

    /**
     * <p>
     * The currency unit that the amount is given in.
     * </p>
     * 
     * @return The currency unit that the amount is given in.
     */
    public String unit() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Total)) {
            return false;
        }
        Total other = (Total) obj;
        return Objects.equals(amount(), other.amount()) && Objects.equals(unit(), other.unit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Total").add("Amount", amount()).add("Unit", unit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Total, T> g) {
        return obj -> g.apply((Total) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Total> {
        /**
         * <p>
         * The total usage.
         * </p>
         * 
         * @param amount
         *        The total usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(String amount);

        /**
         * <p>
         * The currency unit that the amount is given in.
         * </p>
         * 
         * @param unit
         *        The currency unit that the amount is given in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);
    }

    static final class BuilderImpl implements Builder {
        private String amount;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(Total model) {
            amount(model.amount);
            unit(model.unit);
        }

        public final String getAmount() {
            return amount;
        }

        @Override
        public final Builder amount(String amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(String amount) {
            this.amount = amount;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public Total build() {
            return new Total(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
