/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOrganizationConfigurationRequest extends GuardDutyRequest implements
        ToCopyableBuilder<UpdateOrganizationConfigurationRequest.Builder, UpdateOrganizationConfigurationRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(UpdateOrganizationConfigurationRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoEnable").getter(getter(UpdateOrganizationConfigurationRequest::autoEnable))
            .setter(setter(Builder::autoEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()).build();

    private static final SdkField<OrganizationDataSourceConfigurations> DATA_SOURCES_FIELD = SdkField
            .<OrganizationDataSourceConfigurations> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(UpdateOrganizationConfigurationRequest::dataSources)).setter(setter(Builder::dataSources))
            .constructor(OrganizationDataSourceConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            AUTO_ENABLE_FIELD, DATA_SOURCES_FIELD));

    private final String detectorId;

    private final Boolean autoEnable;

    private final OrganizationDataSourceConfigurations dataSources;

    private UpdateOrganizationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.autoEnable = builder.autoEnable;
        this.dataSources = builder.dataSources;
    }

    /**
     * <p>
     * The ID of the detector to update the delegated administrator for.
     * </p>
     * 
     * @return The ID of the detector to update the delegated administrator for.
     */
    public String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * Indicates whether to automatically enable member accounts in the organization.
     * </p>
     * 
     * @return Indicates whether to automatically enable member accounts in the organization.
     */
    public Boolean autoEnable() {
        return autoEnable;
    }

    /**
     * <p>
     * An object describes which data sources will be updated.
     * </p>
     * 
     * @return An object describes which data sources will be updated.
     */
    public OrganizationDataSourceConfigurations dataSources() {
        return dataSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOrganizationConfigurationRequest)) {
            return false;
        }
        UpdateOrganizationConfigurationRequest other = (UpdateOrganizationConfigurationRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(autoEnable(), other.autoEnable())
                && Objects.equals(dataSources(), other.dataSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateOrganizationConfigurationRequest").add("DetectorId", detectorId())
                .add("AutoEnable", autoEnable()).add("DataSources", dataSources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "AutoEnable":
            return Optional.ofNullable(clazz.cast(autoEnable()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOrganizationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateOrganizationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateOrganizationConfigurationRequest> {
        /**
         * <p>
         * The ID of the detector to update the delegated administrator for.
         * </p>
         * 
         * @param detectorId
         *        The ID of the detector to update the delegated administrator for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * Indicates whether to automatically enable member accounts in the organization.
         * </p>
         * 
         * @param autoEnable
         *        Indicates whether to automatically enable member accounts in the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnable(Boolean autoEnable);

        /**
         * <p>
         * An object describes which data sources will be updated.
         * </p>
         * 
         * @param dataSources
         *        An object describes which data sources will be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(OrganizationDataSourceConfigurations dataSources);

        /**
         * <p>
         * An object describes which data sources will be updated.
         * </p>
         * This is a convenience that creates an instance of the {@link OrganizationDataSourceConfigurations.Builder}
         * avoiding the need to create one manually via {@link OrganizationDataSourceConfigurations#builder()}.
         *
         * When the {@link Consumer} completes, {@link OrganizationDataSourceConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #dataSources(OrganizationDataSourceConfigurations)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link OrganizationDataSourceConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(OrganizationDataSourceConfigurations)
         */
        default Builder dataSources(Consumer<OrganizationDataSourceConfigurations.Builder> dataSources) {
            return dataSources(OrganizationDataSourceConfigurations.builder().applyMutation(dataSources).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private Boolean autoEnable;

        private OrganizationDataSourceConfigurations dataSources;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOrganizationConfigurationRequest model) {
            super(model);
            detectorId(model.detectorId);
            autoEnable(model.autoEnable);
            dataSources(model.dataSources);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Boolean getAutoEnable() {
            return autoEnable;
        }

        @Override
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        public final OrganizationDataSourceConfigurations.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        @Override
        public final Builder dataSources(OrganizationDataSourceConfigurations dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final void setDataSources(OrganizationDataSourceConfigurations.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOrganizationConfigurationRequest build() {
            return new UpdateOrganizationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
