/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePublishingDestinationResponse extends GuardDutyResponse implements
        ToCopyableBuilder<DescribePublishingDestinationResponse.Builder, DescribePublishingDestinationResponse> {
    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationId").getter(getter(DescribePublishingDestinationResponse::destinationId))
            .setter(setter(Builder::destinationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationId").build()).build();

    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationType").getter(getter(DescribePublishingDestinationResponse::destinationTypeAsString))
            .setter(setter(Builder::destinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribePublishingDestinationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Long> PUBLISHING_FAILURE_START_TIMESTAMP_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("PublishingFailureStartTimestamp")
            .getter(getter(DescribePublishingDestinationResponse::publishingFailureStartTimestamp))
            .setter(setter(Builder::publishingFailureStartTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishingFailureStartTimestamp")
                    .build()).build();

    private static final SdkField<DestinationProperties> DESTINATION_PROPERTIES_FIELD = SdkField
            .<DestinationProperties> builder(MarshallingType.SDK_POJO).memberName("DestinationProperties")
            .getter(getter(DescribePublishingDestinationResponse::destinationProperties))
            .setter(setter(Builder::destinationProperties)).constructor(DestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ID_FIELD,
            DESTINATION_TYPE_FIELD, STATUS_FIELD, PUBLISHING_FAILURE_START_TIMESTAMP_FIELD, DESTINATION_PROPERTIES_FIELD));

    private final String destinationId;

    private final String destinationType;

    private final String status;

    private final Long publishingFailureStartTimestamp;

    private final DestinationProperties destinationProperties;

    private DescribePublishingDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.destinationId = builder.destinationId;
        this.destinationType = builder.destinationType;
        this.status = builder.status;
        this.publishingFailureStartTimestamp = builder.publishingFailureStartTimestamp;
        this.destinationProperties = builder.destinationProperties;
    }

    /**
     * <p>
     * The ID of the publishing destination.
     * </p>
     * 
     * @return The ID of the publishing destination.
     */
    public String destinationId() {
        return destinationId;
    }

    /**
     * <p>
     * The type of publishing destination. Currently, only Amazon S3 buckets are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return The type of publishing destination. Currently, only Amazon S3 buckets are supported.
     * @see DestinationType
     */
    public DestinationType destinationType() {
        return DestinationType.fromValue(destinationType);
    }

    /**
     * <p>
     * The type of publishing destination. Currently, only Amazon S3 buckets are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return The type of publishing destination. Currently, only Amazon S3 buckets are supported.
     * @see DestinationType
     */
    public String destinationTypeAsString() {
        return destinationType;
    }

    /**
     * <p>
     * The status of the publishing destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PublishingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the publishing destination.
     * @see PublishingStatus
     */
    public PublishingStatus status() {
        return PublishingStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the publishing destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PublishingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the publishing destination.
     * @see PublishingStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time, in epoch millisecond format, at which GuardDuty was first unable to publish findings to the
     * destination.
     * </p>
     * 
     * @return The time, in epoch millisecond format, at which GuardDuty was first unable to publish findings to the
     *         destination.
     */
    public Long publishingFailureStartTimestamp() {
        return publishingFailureStartTimestamp;
    }

    /**
     * <p>
     * A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and
     * <code>KmsKeyArn</code> of the publishing destination.
     * </p>
     * 
     * @return A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and
     *         <code>KmsKeyArn</code> of the publishing destination.
     */
    public DestinationProperties destinationProperties() {
        return destinationProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publishingFailureStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(destinationProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePublishingDestinationResponse)) {
            return false;
        }
        DescribePublishingDestinationResponse other = (DescribePublishingDestinationResponse) obj;
        return Objects.equals(destinationId(), other.destinationId())
                && Objects.equals(destinationTypeAsString(), other.destinationTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(publishingFailureStartTimestamp(), other.publishingFailureStartTimestamp())
                && Objects.equals(destinationProperties(), other.destinationProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribePublishingDestinationResponse").add("DestinationId", destinationId())
                .add("DestinationType", destinationTypeAsString()).add("Status", statusAsString())
                .add("PublishingFailureStartTimestamp", publishingFailureStartTimestamp())
                .add("DestinationProperties", destinationProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationId":
            return Optional.ofNullable(clazz.cast(destinationId()));
        case "DestinationType":
            return Optional.ofNullable(clazz.cast(destinationTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "PublishingFailureStartTimestamp":
            return Optional.ofNullable(clazz.cast(publishingFailureStartTimestamp()));
        case "DestinationProperties":
            return Optional.ofNullable(clazz.cast(destinationProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePublishingDestinationResponse, T> g) {
        return obj -> g.apply((DescribePublishingDestinationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePublishingDestinationResponse> {
        /**
         * <p>
         * The ID of the publishing destination.
         * </p>
         * 
         * @param destinationId
         *        The ID of the publishing destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationId(String destinationId);

        /**
         * <p>
         * The type of publishing destination. Currently, only Amazon S3 buckets are supported.
         * </p>
         * 
         * @param destinationType
         *        The type of publishing destination. Currently, only Amazon S3 buckets are supported.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(String destinationType);

        /**
         * <p>
         * The type of publishing destination. Currently, only Amazon S3 buckets are supported.
         * </p>
         * 
         * @param destinationType
         *        The type of publishing destination. Currently, only Amazon S3 buckets are supported.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(DestinationType destinationType);

        /**
         * <p>
         * The status of the publishing destination.
         * </p>
         * 
         * @param status
         *        The status of the publishing destination.
         * @see PublishingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublishingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the publishing destination.
         * </p>
         * 
         * @param status
         *        The status of the publishing destination.
         * @see PublishingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublishingStatus
         */
        Builder status(PublishingStatus status);

        /**
         * <p>
         * The time, in epoch millisecond format, at which GuardDuty was first unable to publish findings to the
         * destination.
         * </p>
         * 
         * @param publishingFailureStartTimestamp
         *        The time, in epoch millisecond format, at which GuardDuty was first unable to publish findings to the
         *        destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishingFailureStartTimestamp(Long publishingFailureStartTimestamp);

        /**
         * <p>
         * A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and
         * <code>KmsKeyArn</code> of the publishing destination.
         * </p>
         * 
         * @param destinationProperties
         *        A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and
         *        <code>KmsKeyArn</code> of the publishing destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationProperties(DestinationProperties destinationProperties);

        /**
         * <p>
         * A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and
         * <code>KmsKeyArn</code> of the publishing destination.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationProperties.Builder} avoiding the need
         * to create one manually via {@link DestinationProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationProperties(DestinationProperties)}.
         * 
         * @param destinationProperties
         *        a consumer that will call methods on {@link DestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationProperties(DestinationProperties)
         */
        default Builder destinationProperties(Consumer<DestinationProperties.Builder> destinationProperties) {
            return destinationProperties(DestinationProperties.builder().applyMutation(destinationProperties).build());
        }
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private String destinationId;

        private String destinationType;

        private String status;

        private Long publishingFailureStartTimestamp;

        private DestinationProperties destinationProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePublishingDestinationResponse model) {
            super(model);
            destinationId(model.destinationId);
            destinationType(model.destinationType);
            status(model.status);
            publishingFailureStartTimestamp(model.publishingFailureStartTimestamp);
            destinationProperties(model.destinationProperties);
        }

        public final String getDestinationId() {
            return destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        public final String getDestinationType() {
            return destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(DestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PublishingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getPublishingFailureStartTimestamp() {
            return publishingFailureStartTimestamp;
        }

        @Override
        public final Builder publishingFailureStartTimestamp(Long publishingFailureStartTimestamp) {
            this.publishingFailureStartTimestamp = publishingFailureStartTimestamp;
            return this;
        }

        public final void setPublishingFailureStartTimestamp(Long publishingFailureStartTimestamp) {
            this.publishingFailureStartTimestamp = publishingFailureStartTimestamp;
        }

        public final DestinationProperties.Builder getDestinationProperties() {
            return destinationProperties != null ? destinationProperties.toBuilder() : null;
        }

        @Override
        public final Builder destinationProperties(DestinationProperties destinationProperties) {
            this.destinationProperties = destinationProperties;
            return this;
        }

        public final void setDestinationProperties(DestinationProperties.BuilderImpl destinationProperties) {
            this.destinationProperties = destinationProperties != null ? destinationProperties.build() : null;
        }

        @Override
        public DescribePublishingDestinationResponse build() {
            return new DescribePublishingDestinationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
