/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the administrator account and invitation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Master implements SdkPojo, Serializable, ToCopyableBuilder<Master.Builder, Master> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(Master::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvitationId").getter(getter(Master::invitationId)).setter(setter(Builder::invitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitationId").build()).build();

    private static final SdkField<String> RELATIONSHIP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelationshipStatus").getter(getter(Master::relationshipStatus))
            .setter(setter(Builder::relationshipStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipStatus").build())
            .build();

    private static final SdkField<String> INVITED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvitedAt").getter(getter(Master::invitedAt)).setter(setter(Builder::invitedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            INVITATION_ID_FIELD, RELATIONSHIP_STATUS_FIELD, INVITED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String invitationId;

    private final String relationshipStatus;

    private final String invitedAt;

    private Master(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.invitationId = builder.invitationId;
        this.relationshipStatus = builder.relationshipStatus;
        this.invitedAt = builder.invitedAt;
    }

    /**
     * <p>
     * The ID of the account used as the administrator account.
     * </p>
     * 
     * @return The ID of the account used as the administrator account.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The value used to validate the administrator account to the member account.
     * </p>
     * 
     * @return The value used to validate the administrator account to the member account.
     */
    public String invitationId() {
        return invitationId;
    }

    /**
     * <p>
     * The status of the relationship between the administrator and member accounts.
     * </p>
     * 
     * @return The status of the relationship between the administrator and member accounts.
     */
    public String relationshipStatus() {
        return relationshipStatus;
    }

    /**
     * <p>
     * The timestamp when the invitation was sent.
     * </p>
     * 
     * @return The timestamp when the invitation was sent.
     */
    public String invitedAt() {
        return invitedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(invitationId());
        hashCode = 31 * hashCode + Objects.hashCode(relationshipStatus());
        hashCode = 31 * hashCode + Objects.hashCode(invitedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Master)) {
            return false;
        }
        Master other = (Master) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(invitationId(), other.invitationId())
                && Objects.equals(relationshipStatus(), other.relationshipStatus())
                && Objects.equals(invitedAt(), other.invitedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Master").add("AccountId", accountId()).add("InvitationId", invitationId())
                .add("RelationshipStatus", relationshipStatus()).add("InvitedAt", invitedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "InvitationId":
            return Optional.ofNullable(clazz.cast(invitationId()));
        case "RelationshipStatus":
            return Optional.ofNullable(clazz.cast(relationshipStatus()));
        case "InvitedAt":
            return Optional.ofNullable(clazz.cast(invitedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Master, T> g) {
        return obj -> g.apply((Master) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Master> {
        /**
         * <p>
         * The ID of the account used as the administrator account.
         * </p>
         * 
         * @param accountId
         *        The ID of the account used as the administrator account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The value used to validate the administrator account to the member account.
         * </p>
         * 
         * @param invitationId
         *        The value used to validate the administrator account to the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitationId(String invitationId);

        /**
         * <p>
         * The status of the relationship between the administrator and member accounts.
         * </p>
         * 
         * @param relationshipStatus
         *        The status of the relationship between the administrator and member accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationshipStatus(String relationshipStatus);

        /**
         * <p>
         * The timestamp when the invitation was sent.
         * </p>
         * 
         * @param invitedAt
         *        The timestamp when the invitation was sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitedAt(String invitedAt);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String invitationId;

        private String relationshipStatus;

        private String invitedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Master model) {
            accountId(model.accountId);
            invitationId(model.invitationId);
            relationshipStatus(model.relationshipStatus);
            invitedAt(model.invitedAt);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getInvitationId() {
            return invitationId;
        }

        @Override
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        public final String getRelationshipStatus() {
            return relationshipStatus;
        }

        @Override
        public final Builder relationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
            return this;
        }

        public final void setRelationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
        }

        public final String getInvitedAt() {
            return invitedAt;
        }

        @Override
        public final Builder invitedAt(String invitedAt) {
            this.invitedAt = invitedAt;
            return this;
        }

        public final void setInvitedAt(String invitedAt) {
            this.invitedAt = invitedAt;
        }

        @Override
        public Master build() {
            return new Master(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
