/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.DataSourceConfigurations;
import software.amazon.awssdk.services.guardduty.model.FindingPublishingFrequency;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDetectorRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, UpdateDetectorRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(UpdateDetectorRequest.getter(UpdateDetectorRequest::detectorId)).setter(UpdateDetectorRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<Boolean> ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enable").getter(UpdateDetectorRequest.getter(UpdateDetectorRequest::enable)).setter(UpdateDetectorRequest.setter(Builder::enable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enable").build()}).build();
    private static final SdkField<String> FINDING_PUBLISHING_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FindingPublishingFrequency").getter(UpdateDetectorRequest.getter(UpdateDetectorRequest::findingPublishingFrequencyAsString)).setter(UpdateDetectorRequest.setter(Builder::findingPublishingFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingPublishingFrequency").build()}).build();
    private static final SdkField<DataSourceConfigurations> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSources").getter(UpdateDetectorRequest.getter(UpdateDetectorRequest::dataSources)).setter(UpdateDetectorRequest.setter(Builder::dataSources)).constructor(DataSourceConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, ENABLE_FIELD, FINDING_PUBLISHING_FREQUENCY_FIELD, DATA_SOURCES_FIELD));
    private final String detectorId;
    private final Boolean enable;
    private final String findingPublishingFrequency;
    private final DataSourceConfigurations dataSources;

    private UpdateDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.enable = builder.enable;
        this.findingPublishingFrequency = builder.findingPublishingFrequency;
        this.dataSources = builder.dataSources;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final Boolean enable() {
        return this.enable;
    }

    public final FindingPublishingFrequency findingPublishingFrequency() {
        return FindingPublishingFrequency.fromValue(this.findingPublishingFrequency);
    }

    public final String findingPublishingFrequencyAsString() {
        return this.findingPublishingFrequency;
    }

    public final DataSourceConfigurations dataSources() {
        return this.dataSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enable());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingPublishingFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDetectorRequest)) {
            return false;
        }
        UpdateDetectorRequest other = (UpdateDetectorRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.enable(), other.enable()) && Objects.equals(this.findingPublishingFrequencyAsString(), other.findingPublishingFrequencyAsString()) && Objects.equals(this.dataSources(), other.dataSources());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDetectorRequest").add("DetectorId", (Object)this.detectorId()).add("Enable", (Object)this.enable()).add("FindingPublishingFrequency", (Object)this.findingPublishingFrequencyAsString()).add("DataSources", (Object)this.dataSources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "Enable": {
                return Optional.ofNullable(clazz.cast(this.enable()));
            }
            case "FindingPublishingFrequency": {
                return Optional.ofNullable(clazz.cast(this.findingPublishingFrequencyAsString()));
            }
            case "DataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDetectorRequest, T> g) {
        return obj -> g.apply((UpdateDetectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private Boolean enable;
        private String findingPublishingFrequency;
        private DataSourceConfigurations dataSources;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDetectorRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.enable(model.enable);
            this.findingPublishingFrequency(model.findingPublishingFrequency);
            this.dataSources(model.dataSources);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Boolean getEnable() {
            return this.enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public final String getFindingPublishingFrequency() {
            return this.findingPublishingFrequency;
        }

        @Override
        public final Builder findingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
            return this;
        }

        @Override
        public final Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency) {
            this.findingPublishingFrequency(findingPublishingFrequency == null ? null : findingPublishingFrequency.toString());
            return this;
        }

        public final void setFindingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
        }

        public final DataSourceConfigurations.Builder getDataSources() {
            return this.dataSources != null ? this.dataSources.toBuilder() : null;
        }

        @Override
        public final Builder dataSources(DataSourceConfigurations dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final void setDataSources(DataSourceConfigurations.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDetectorRequest build() {
            return new UpdateDetectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDetectorRequest> {
        public Builder detectorId(String var1);

        public Builder enable(Boolean var1);

        public Builder findingPublishingFrequency(String var1);

        public Builder findingPublishingFrequency(FindingPublishingFrequency var1);

        public Builder dataSources(DataSourceConfigurations var1);

        default public Builder dataSources(Consumer<DataSourceConfigurations.Builder> dataSources) {
            return this.dataSources((DataSourceConfigurations)((DataSourceConfigurations.Builder)DataSourceConfigurations.builder().applyMutation(dataSources)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

