/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMemberDetectorsResponse extends GuardDutyResponse implements
        ToCopyableBuilder<GetMemberDetectorsResponse.Builder, GetMemberDetectorsResponse> {
    private static final SdkField<List<MemberDataSourceConfiguration>> MEMBER_DATA_SOURCE_CONFIGURATIONS_FIELD = SdkField
            .<List<MemberDataSourceConfiguration>> builder(MarshallingType.LIST)
            .memberName("MemberDataSourceConfigurations")
            .getter(getter(GetMemberDetectorsResponse::memberDataSourceConfigurations))
            .setter(setter(Builder::memberDataSourceConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("members").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberDataSourceConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberDataSourceConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedAccount>> UNPROCESSED_ACCOUNTS_FIELD = SdkField
            .<List<UnprocessedAccount>> builder(MarshallingType.LIST)
            .memberName("UnprocessedAccounts")
            .getter(getter(GetMemberDetectorsResponse::unprocessedAccounts))
            .setter(setter(Builder::unprocessedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MEMBER_DATA_SOURCE_CONFIGURATIONS_FIELD, UNPROCESSED_ACCOUNTS_FIELD));

    private final List<MemberDataSourceConfiguration> memberDataSourceConfigurations;

    private final List<UnprocessedAccount> unprocessedAccounts;

    private GetMemberDetectorsResponse(BuilderImpl builder) {
        super(builder);
        this.memberDataSourceConfigurations = builder.memberDataSourceConfigurations;
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    /**
     * Returns true if the MemberDataSourceConfigurations property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasMemberDataSourceConfigurations() {
        return memberDataSourceConfigurations != null && !(memberDataSourceConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that describes which data sources are enabled for a member account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMemberDataSourceConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object that describes which data sources are enabled for a member account.
     */
    public final List<MemberDataSourceConfiguration> memberDataSourceConfigurations() {
        return memberDataSourceConfigurations;
    }

    /**
     * Returns true if the UnprocessedAccounts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUnprocessedAccounts() {
        return unprocessedAccounts != null && !(unprocessedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of member account IDs that were unable to be processed along with an explanation for why they were not
     * processed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUnprocessedAccounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of member account IDs that were unable to be processed along with an explanation for why they were
     *         not processed.
     */
    public final List<UnprocessedAccount> unprocessedAccounts() {
        return unprocessedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasMemberDataSourceConfigurations() ? memberDataSourceConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedAccounts() ? unprocessedAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMemberDetectorsResponse)) {
            return false;
        }
        GetMemberDetectorsResponse other = (GetMemberDetectorsResponse) obj;
        return hasMemberDataSourceConfigurations() == other.hasMemberDataSourceConfigurations()
                && Objects.equals(memberDataSourceConfigurations(), other.memberDataSourceConfigurations())
                && hasUnprocessedAccounts() == other.hasUnprocessedAccounts()
                && Objects.equals(unprocessedAccounts(), other.unprocessedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetMemberDetectorsResponse")
                .add("MemberDataSourceConfigurations",
                        hasMemberDataSourceConfigurations() ? memberDataSourceConfigurations() : null)
                .add("UnprocessedAccounts", hasUnprocessedAccounts() ? unprocessedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemberDataSourceConfigurations":
            return Optional.ofNullable(clazz.cast(memberDataSourceConfigurations()));
        case "UnprocessedAccounts":
            return Optional.ofNullable(clazz.cast(unprocessedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMemberDetectorsResponse, T> g) {
        return obj -> g.apply((GetMemberDetectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMemberDetectorsResponse> {
        /**
         * <p>
         * An object that describes which data sources are enabled for a member account.
         * </p>
         * 
         * @param memberDataSourceConfigurations
         *        An object that describes which data sources are enabled for a member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDataSourceConfigurations(Collection<MemberDataSourceConfiguration> memberDataSourceConfigurations);

        /**
         * <p>
         * An object that describes which data sources are enabled for a member account.
         * </p>
         * 
         * @param memberDataSourceConfigurations
         *        An object that describes which data sources are enabled for a member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDataSourceConfigurations(MemberDataSourceConfiguration... memberDataSourceConfigurations);

        /**
         * <p>
         * An object that describes which data sources are enabled for a member account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MemberDataSourceConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<MemberDataSourceConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MemberDataSourceConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #memberDataSourceConfigurations(List<MemberDataSourceConfiguration>)}.
         * 
         * @param memberDataSourceConfigurations
         *        a consumer that will call methods on {@link List<MemberDataSourceConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberDataSourceConfigurations(List<MemberDataSourceConfiguration>)
         */
        Builder memberDataSourceConfigurations(Consumer<MemberDataSourceConfiguration.Builder>... memberDataSourceConfigurations);

        /**
         * <p>
         * A list of member account IDs that were unable to be processed along with an explanation for why they were not
         * processed.
         * </p>
         * 
         * @param unprocessedAccounts
         *        A list of member account IDs that were unable to be processed along with an explanation for why they
         *        were not processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts);

        /**
         * <p>
         * A list of member account IDs that were unable to be processed along with an explanation for why they were not
         * processed.
         * </p>
         * 
         * @param unprocessedAccounts
         *        A list of member account IDs that were unable to be processed along with an explanation for why they
         *        were not processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts);

        /**
         * <p>
         * A list of member account IDs that were unable to be processed along with an explanation for why they were not
         * processed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UnprocessedAccount>.Builder} avoiding the
         * need to create one manually via {@link List<UnprocessedAccount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UnprocessedAccount>.Builder#build()} is called immediately
         * and its result is passed to {@link #unprocessedAccounts(List<UnprocessedAccount>)}.
         * 
         * @param unprocessedAccounts
         *        a consumer that will call methods on {@link List<UnprocessedAccount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedAccounts(List<UnprocessedAccount>)
         */
        Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts);
    }

    static final class BuilderImpl extends GuardDutyResponse.BuilderImpl implements Builder {
        private List<MemberDataSourceConfiguration> memberDataSourceConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMemberDetectorsResponse model) {
            super(model);
            memberDataSourceConfigurations(model.memberDataSourceConfigurations);
            unprocessedAccounts(model.unprocessedAccounts);
        }

        public final Collection<MemberDataSourceConfiguration.Builder> getMemberDataSourceConfigurations() {
            if (memberDataSourceConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return memberDataSourceConfigurations != null ? memberDataSourceConfigurations.stream()
                    .map(MemberDataSourceConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder memberDataSourceConfigurations(
                Collection<MemberDataSourceConfiguration> memberDataSourceConfigurations) {
            this.memberDataSourceConfigurations = MemberDataSourceConfigurationsCopier.copy(memberDataSourceConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDataSourceConfigurations(MemberDataSourceConfiguration... memberDataSourceConfigurations) {
            memberDataSourceConfigurations(Arrays.asList(memberDataSourceConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDataSourceConfigurations(
                Consumer<MemberDataSourceConfiguration.Builder>... memberDataSourceConfigurations) {
            memberDataSourceConfigurations(Stream.of(memberDataSourceConfigurations)
                    .map(c -> MemberDataSourceConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMemberDataSourceConfigurations(
                Collection<MemberDataSourceConfiguration.BuilderImpl> memberDataSourceConfigurations) {
            this.memberDataSourceConfigurations = MemberDataSourceConfigurationsCopier
                    .copyFromBuilder(memberDataSourceConfigurations);
        }

        public final Collection<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            if (unprocessedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return unprocessedAccounts != null ? unprocessedAccounts.stream().map(UnprocessedAccount::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountsCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts) {
            unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts) {
            unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> UnprocessedAccount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = UnprocessedAccountsCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public GetMemberDetectorsResponse build() {
            return new GetMemberDetectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
