/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMemberDetectorsRequest extends GuardDutyRequest implements
        ToCopyableBuilder<UpdateMemberDetectorsRequest.Builder, UpdateMemberDetectorsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(UpdateMemberDetectorsRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIds")
            .getter(getter(UpdateMemberDetectorsRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataSourceConfigurations> DATA_SOURCES_FIELD = SdkField
            .<DataSourceConfigurations> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(UpdateMemberDetectorsRequest::dataSources)).setter(setter(Builder::dataSources))
            .constructor(DataSourceConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            ACCOUNT_IDS_FIELD, DATA_SOURCES_FIELD));

    private final String detectorId;

    private final List<String> accountIds;

    private final DataSourceConfigurations dataSources;

    private UpdateMemberDetectorsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.accountIds = builder.accountIds;
        this.dataSources = builder.dataSources;
    }

    /**
     * <p>
     * The detector ID of the administrator account.
     * </p>
     * 
     * @return The detector ID of the administrator account.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * Returns true if the AccountIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of member account IDs to be updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of member account IDs to be updated.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * <p>
     * Describes which data sources will be updated.
     * </p>
     * 
     * @return Describes which data sources will be updated.
     */
    public final DataSourceConfigurations dataSources() {
        return dataSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMemberDetectorsRequest)) {
            return false;
        }
        UpdateMemberDetectorsRequest other = (UpdateMemberDetectorsRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && hasAccountIds() == other.hasAccountIds()
                && Objects.equals(accountIds(), other.accountIds()) && Objects.equals(dataSources(), other.dataSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMemberDetectorsRequest").add("DetectorId", detectorId())
                .add("AccountIds", hasAccountIds() ? accountIds() : null).add("DataSources", dataSources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMemberDetectorsRequest, T> g) {
        return obj -> g.apply((UpdateMemberDetectorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMemberDetectorsRequest> {
        /**
         * <p>
         * The detector ID of the administrator account.
         * </p>
         * 
         * @param detectorId
         *        The detector ID of the administrator account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * A list of member account IDs to be updated.
         * </p>
         * 
         * @param accountIds
         *        A list of member account IDs to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * A list of member account IDs to be updated.
         * </p>
         * 
         * @param accountIds
         *        A list of member account IDs to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * Describes which data sources will be updated.
         * </p>
         * 
         * @param dataSources
         *        Describes which data sources will be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSourceConfigurations dataSources);

        /**
         * <p>
         * Describes which data sources will be updated.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSourceConfigurations.Builder} avoiding the
         * need to create one manually via {@link DataSourceConfigurations#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceConfigurations.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSources(DataSourceConfigurations)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link DataSourceConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(DataSourceConfigurations)
         */
        default Builder dataSources(Consumer<DataSourceConfigurations.Builder> dataSources) {
            return dataSources(DataSourceConfigurations.builder().applyMutation(dataSources).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private DataSourceConfigurations dataSources;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMemberDetectorsRequest model) {
            super(model);
            detectorId(model.detectorId);
            accountIds(model.accountIds);
            dataSources(model.dataSources);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        public final DataSourceConfigurations.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        @Override
        public final Builder dataSources(DataSourceConfigurations dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final void setDataSources(DataSourceConfigurations.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMemberDetectorsRequest build() {
            return new UpdateMemberDetectorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
