/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The account within the organization specified as the GuardDuty delegated administrator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdminAccount implements SdkPojo, Serializable, ToCopyableBuilder<AdminAccount.Builder, AdminAccount> {
    private static final SdkField<String> ADMIN_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdminAccountId").getter(getter(AdminAccount::adminAccountId)).setter(setter(Builder::adminAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminAccountId").build()).build();

    private static final SdkField<String> ADMIN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdminStatus").getter(getter(AdminAccount::adminStatusAsString)).setter(setter(Builder::adminStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNT_ID_FIELD,
            ADMIN_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adminAccountId;

    private final String adminStatus;

    private AdminAccount(BuilderImpl builder) {
        this.adminAccountId = builder.adminAccountId;
        this.adminStatus = builder.adminStatus;
    }

    /**
     * <p>
     * The AWS account ID for the account.
     * </p>
     * 
     * @return The AWS account ID for the account.
     */
    public final String adminAccountId() {
        return adminAccountId;
    }

    /**
     * <p>
     * Indicates whether the account is enabled as the delegated administrator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adminStatus} will
     * return {@link AdminStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adminStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the account is enabled as the delegated administrator.
     * @see AdminStatus
     */
    public final AdminStatus adminStatus() {
        return AdminStatus.fromValue(adminStatus);
    }

    /**
     * <p>
     * Indicates whether the account is enabled as the delegated administrator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #adminStatus} will
     * return {@link AdminStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #adminStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the account is enabled as the delegated administrator.
     * @see AdminStatus
     */
    public final String adminStatusAsString() {
        return adminStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adminAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(adminStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminAccount)) {
            return false;
        }
        AdminAccount other = (AdminAccount) obj;
        return Objects.equals(adminAccountId(), other.adminAccountId())
                && Objects.equals(adminStatusAsString(), other.adminStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdminAccount").add("AdminAccountId", adminAccountId()).add("AdminStatus", adminStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdminAccountId":
            return Optional.ofNullable(clazz.cast(adminAccountId()));
        case "AdminStatus":
            return Optional.ofNullable(clazz.cast(adminStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminAccount, T> g) {
        return obj -> g.apply((AdminAccount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdminAccount> {
        /**
         * <p>
         * The AWS account ID for the account.
         * </p>
         * 
         * @param adminAccountId
         *        The AWS account ID for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminAccountId(String adminAccountId);

        /**
         * <p>
         * Indicates whether the account is enabled as the delegated administrator.
         * </p>
         * 
         * @param adminStatus
         *        Indicates whether the account is enabled as the delegated administrator.
         * @see AdminStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdminStatus
         */
        Builder adminStatus(String adminStatus);

        /**
         * <p>
         * Indicates whether the account is enabled as the delegated administrator.
         * </p>
         * 
         * @param adminStatus
         *        Indicates whether the account is enabled as the delegated administrator.
         * @see AdminStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdminStatus
         */
        Builder adminStatus(AdminStatus adminStatus);
    }

    static final class BuilderImpl implements Builder {
        private String adminAccountId;

        private String adminStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminAccount model) {
            adminAccountId(model.adminAccountId);
            adminStatus(model.adminStatus);
        }

        public final String getAdminAccountId() {
            return adminAccountId;
        }

        @Override
        public final Builder adminAccountId(String adminAccountId) {
            this.adminAccountId = adminAccountId;
            return this;
        }

        public final void setAdminAccountId(String adminAccountId) {
            this.adminAccountId = adminAccountId;
        }

        public final String getAdminStatus() {
            return adminStatus;
        }

        @Override
        public final Builder adminStatus(String adminStatus) {
            this.adminStatus = adminStatus;
            return this;
        }

        @Override
        public final Builder adminStatus(AdminStatus adminStatus) {
            this.adminStatus(adminStatus == null ? null : adminStatus.toString());
            return this;
        }

        public final void setAdminStatus(String adminStatus) {
            this.adminStatus = adminStatus;
        }

        @Override
        public AdminAccount build() {
            return new AdminAccount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
