/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePublishingDestinationRequest extends GuardDutyRequest implements
        ToCopyableBuilder<UpdatePublishingDestinationRequest.Builder, UpdatePublishingDestinationRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(UpdatePublishingDestinationRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationId").getter(getter(UpdatePublishingDestinationRequest::destinationId))
            .setter(setter(Builder::destinationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("destinationId").build()).build();

    private static final SdkField<DestinationProperties> DESTINATION_PROPERTIES_FIELD = SdkField
            .<DestinationProperties> builder(MarshallingType.SDK_POJO).memberName("DestinationProperties")
            .getter(getter(UpdatePublishingDestinationRequest::destinationProperties))
            .setter(setter(Builder::destinationProperties)).constructor(DestinationProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            DESTINATION_ID_FIELD, DESTINATION_PROPERTIES_FIELD));

    private final String detectorId;

    private final String destinationId;

    private final DestinationProperties destinationProperties;

    private UpdatePublishingDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.destinationId = builder.destinationId;
        this.destinationProperties = builder.destinationProperties;
    }

    /**
     * <p>
     * The ID of the detector associated with the publishing destinations to update.
     * </p>
     * 
     * @return The ID of the detector associated with the publishing destinations to update.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The ID of the publishing destination to update.
     * </p>
     * 
     * @return The ID of the publishing destination to update.
     */
    public final String destinationId() {
        return destinationId;
    }

    /**
     * <p>
     * A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and
     * <code>KmsKeyArn</code> of the publishing destination.
     * </p>
     * 
     * @return A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and
     *         <code>KmsKeyArn</code> of the publishing destination.
     */
    public final DestinationProperties destinationProperties() {
        return destinationProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePublishingDestinationRequest)) {
            return false;
        }
        UpdatePublishingDestinationRequest other = (UpdatePublishingDestinationRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(destinationId(), other.destinationId())
                && Objects.equals(destinationProperties(), other.destinationProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePublishingDestinationRequest").add("DetectorId", detectorId())
                .add("DestinationId", destinationId()).add("DestinationProperties", destinationProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "DestinationId":
            return Optional.ofNullable(clazz.cast(destinationId()));
        case "DestinationProperties":
            return Optional.ofNullable(clazz.cast(destinationProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePublishingDestinationRequest, T> g) {
        return obj -> g.apply((UpdatePublishingDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePublishingDestinationRequest> {
        /**
         * <p>
         * The ID of the detector associated with the publishing destinations to update.
         * </p>
         * 
         * @param detectorId
         *        The ID of the detector associated with the publishing destinations to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The ID of the publishing destination to update.
         * </p>
         * 
         * @param destinationId
         *        The ID of the publishing destination to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationId(String destinationId);

        /**
         * <p>
         * A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and
         * <code>KmsKeyArn</code> of the publishing destination.
         * </p>
         * 
         * @param destinationProperties
         *        A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and
         *        <code>KmsKeyArn</code> of the publishing destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationProperties(DestinationProperties destinationProperties);

        /**
         * <p>
         * A <code>DestinationProperties</code> object that includes the <code>DestinationArn</code> and
         * <code>KmsKeyArn</code> of the publishing destination.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationProperties.Builder} avoiding the need
         * to create one manually via {@link DestinationProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationProperties(DestinationProperties)}.
         * 
         * @param destinationProperties
         *        a consumer that will call methods on {@link DestinationProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationProperties(DestinationProperties)
         */
        default Builder destinationProperties(Consumer<DestinationProperties.Builder> destinationProperties) {
            return destinationProperties(DestinationProperties.builder().applyMutation(destinationProperties).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String destinationId;

        private DestinationProperties destinationProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePublishingDestinationRequest model) {
            super(model);
            detectorId(model.detectorId);
            destinationId(model.destinationId);
            destinationProperties(model.destinationProperties);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getDestinationId() {
            return destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        public final DestinationProperties.Builder getDestinationProperties() {
            return destinationProperties != null ? destinationProperties.toBuilder() : null;
        }

        @Override
        public final Builder destinationProperties(DestinationProperties destinationProperties) {
            this.destinationProperties = destinationProperties;
            return this;
        }

        public final void setDestinationProperties(DestinationProperties.BuilderImpl destinationProperties) {
            this.destinationProperties = destinationProperties != null ? destinationProperties.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePublishingDestinationRequest build() {
            return new UpdatePublishingDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
