/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFindingsFeedbackRequest extends GuardDutyRequest implements
        ToCopyableBuilder<UpdateFindingsFeedbackRequest.Builder, UpdateFindingsFeedbackRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(UpdateFindingsFeedbackRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<List<String>> FINDING_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FindingIds")
            .getter(getter(UpdateFindingsFeedbackRequest::findingIds))
            .setter(setter(Builder::findingIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FEEDBACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Feedback").getter(getter(UpdateFindingsFeedbackRequest::feedbackAsString))
            .setter(setter(Builder::feedback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feedback").build()).build();

    private static final SdkField<String> COMMENTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Comments").getter(getter(UpdateFindingsFeedbackRequest::comments)).setter(setter(Builder::comments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comments").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            FINDING_IDS_FIELD, FEEDBACK_FIELD, COMMENTS_FIELD));

    private final String detectorId;

    private final List<String> findingIds;

    private final String feedback;

    private final String comments;

    private UpdateFindingsFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.findingIds = builder.findingIds;
        this.feedback = builder.feedback;
        this.comments = builder.comments;
    }

    /**
     * <p>
     * The ID of the detector associated with the findings to update feedback for.
     * </p>
     * 
     * @return The ID of the detector associated with the findings to update feedback for.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * Returns true if the FindingIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFindingIds() {
        return findingIds != null && !(findingIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the findings that you want to mark as useful or not useful.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindingIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the findings that you want to mark as useful or not useful.
     */
    public final List<String> findingIds() {
        return findingIds;
    }

    /**
     * <p>
     * The feedback for the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedback} will
     * return {@link Feedback#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #feedbackAsString}.
     * </p>
     * 
     * @return The feedback for the finding.
     * @see Feedback
     */
    public final Feedback feedback() {
        return Feedback.fromValue(feedback);
    }

    /**
     * <p>
     * The feedback for the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feedback} will
     * return {@link Feedback#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #feedbackAsString}.
     * </p>
     * 
     * @return The feedback for the finding.
     * @see Feedback
     */
    public final String feedbackAsString() {
        return feedback;
    }

    /**
     * <p>
     * Additional feedback about the GuardDuty findings.
     * </p>
     * 
     * @return Additional feedback about the GuardDuty findings.
     */
    public final String comments() {
        return comments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingIds() ? findingIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(feedbackAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comments());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFindingsFeedbackRequest)) {
            return false;
        }
        UpdateFindingsFeedbackRequest other = (UpdateFindingsFeedbackRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && hasFindingIds() == other.hasFindingIds()
                && Objects.equals(findingIds(), other.findingIds())
                && Objects.equals(feedbackAsString(), other.feedbackAsString()) && Objects.equals(comments(), other.comments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFindingsFeedbackRequest").add("DetectorId", detectorId())
                .add("FindingIds", hasFindingIds() ? findingIds() : null).add("Feedback", feedbackAsString())
                .add("Comments", comments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "FindingIds":
            return Optional.ofNullable(clazz.cast(findingIds()));
        case "Feedback":
            return Optional.ofNullable(clazz.cast(feedbackAsString()));
        case "Comments":
            return Optional.ofNullable(clazz.cast(comments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFindingsFeedbackRequest, T> g) {
        return obj -> g.apply((UpdateFindingsFeedbackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFindingsFeedbackRequest> {
        /**
         * <p>
         * The ID of the detector associated with the findings to update feedback for.
         * </p>
         * 
         * @param detectorId
         *        The ID of the detector associated with the findings to update feedback for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The IDs of the findings that you want to mark as useful or not useful.
         * </p>
         * 
         * @param findingIds
         *        The IDs of the findings that you want to mark as useful or not useful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(Collection<String> findingIds);

        /**
         * <p>
         * The IDs of the findings that you want to mark as useful or not useful.
         * </p>
         * 
         * @param findingIds
         *        The IDs of the findings that you want to mark as useful or not useful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingIds(String... findingIds);

        /**
         * <p>
         * The feedback for the finding.
         * </p>
         * 
         * @param feedback
         *        The feedback for the finding.
         * @see Feedback
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Feedback
         */
        Builder feedback(String feedback);

        /**
         * <p>
         * The feedback for the finding.
         * </p>
         * 
         * @param feedback
         *        The feedback for the finding.
         * @see Feedback
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Feedback
         */
        Builder feedback(Feedback feedback);

        /**
         * <p>
         * Additional feedback about the GuardDuty findings.
         * </p>
         * 
         * @param comments
         *        Additional feedback about the GuardDuty findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comments(String comments);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private List<String> findingIds = DefaultSdkAutoConstructList.getInstance();

        private String feedback;

        private String comments;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFindingsFeedbackRequest model) {
            super(model);
            detectorId(model.detectorId);
            findingIds(model.findingIds);
            feedback(model.feedback);
            comments(model.comments);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Collection<String> getFindingIds() {
            if (findingIds instanceof SdkAutoConstructList) {
                return null;
            }
            return findingIds;
        }

        @Override
        public final Builder findingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIds(String... findingIds) {
            findingIds(Arrays.asList(findingIds));
            return this;
        }

        public final void setFindingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdsCopier.copy(findingIds);
        }

        public final String getFeedback() {
            return feedback;
        }

        @Override
        public final Builder feedback(String feedback) {
            this.feedback = feedback;
            return this;
        }

        @Override
        public final Builder feedback(Feedback feedback) {
            this.feedback(feedback == null ? null : feedback.toString());
            return this;
        }

        public final void setFeedback(String feedback) {
            this.feedback = feedback;
        }

        public final String getComments() {
            return comments;
        }

        @Override
        public final Builder comments(String comments) {
            this.comments = comments;
            return this;
        }

        public final void setComments(String comments) {
            this.comments = comments;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFindingsFeedbackRequest build() {
            return new UpdateFindingsFeedbackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
