/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on the total of usage based on account IDs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageAccountResult implements SdkPojo, Serializable,
        ToCopyableBuilder<UsageAccountResult.Builder, UsageAccountResult> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(UsageAccountResult::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Total> TOTAL_FIELD = SdkField.<Total> builder(MarshallingType.SDK_POJO).memberName("Total")
            .getter(getter(UsageAccountResult::total)).setter(setter(Builder::total)).constructor(Total::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, TOTAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Total total;

    private UsageAccountResult(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.total = builder.total;
    }

    /**
     * <p>
     * The Account ID that generated usage.
     * </p>
     * 
     * @return The Account ID that generated usage.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Represents the total of usage for the Account ID.
     * </p>
     * 
     * @return Represents the total of usage for the Account ID.
     */
    public final Total total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageAccountResult)) {
            return false;
        }
        UsageAccountResult other = (UsageAccountResult) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageAccountResult").add("AccountId", accountId()).add("Total", total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageAccountResult, T> g) {
        return obj -> g.apply((UsageAccountResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageAccountResult> {
        /**
         * <p>
         * The Account ID that generated usage.
         * </p>
         * 
         * @param accountId
         *        The Account ID that generated usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Represents the total of usage for the Account ID.
         * </p>
         * 
         * @param total
         *        Represents the total of usage for the Account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Total total);

        /**
         * <p>
         * Represents the total of usage for the Account ID.
         * </p>
         * This is a convenience that creates an instance of the {@link Total.Builder} avoiding the need to create one
         * manually via {@link Total#builder()}.
         *
         * When the {@link Consumer} completes, {@link Total.Builder#build()} is called immediately and its result is
         * passed to {@link #total(Total)}.
         * 
         * @param total
         *        a consumer that will call methods on {@link Total.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #total(Total)
         */
        default Builder total(Consumer<Total.Builder> total) {
            return total(Total.builder().applyMutation(total).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Total total;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageAccountResult model) {
            accountId(model.accountId);
            total(model.total);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Total.Builder getTotal() {
            return total != null ? total.toBuilder() : null;
        }

        @Override
        public final Builder total(Total total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Total.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public UsageAccountResult build() {
            return new UsageAccountResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
