/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.model.DataSourceConfigurations;
import software.amazon.awssdk.services.guardduty.model.FindingPublishingFrequency;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDetectorRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, CreateDetectorRequest> {
    private static final SdkField<Boolean> ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enable").getter(CreateDetectorRequest.getter(CreateDetectorRequest::enable)).setter(CreateDetectorRequest.setter(Builder::enable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enable").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateDetectorRequest.getter(CreateDetectorRequest::clientToken)).setter(CreateDetectorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FINDING_PUBLISHING_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FindingPublishingFrequency").getter(CreateDetectorRequest.getter(CreateDetectorRequest::findingPublishingFrequencyAsString)).setter(CreateDetectorRequest.setter(Builder::findingPublishingFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingPublishingFrequency").build()}).build();
    private static final SdkField<DataSourceConfigurations> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSources").getter(CreateDetectorRequest.getter(CreateDetectorRequest::dataSources)).setter(CreateDetectorRequest.setter(Builder::dataSources)).constructor(DataSourceConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateDetectorRequest.getter(CreateDetectorRequest::tags)).setter(CreateDetectorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_FIELD, CLIENT_TOKEN_FIELD, FINDING_PUBLISHING_FREQUENCY_FIELD, DATA_SOURCES_FIELD, TAGS_FIELD));
    private final Boolean enable;
    private final String clientToken;
    private final String findingPublishingFrequency;
    private final DataSourceConfigurations dataSources;
    private final Map<String, String> tags;

    private CreateDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.enable = builder.enable;
        this.clientToken = builder.clientToken;
        this.findingPublishingFrequency = builder.findingPublishingFrequency;
        this.dataSources = builder.dataSources;
        this.tags = builder.tags;
    }

    public final Boolean enable() {
        return this.enable;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final FindingPublishingFrequency findingPublishingFrequency() {
        return FindingPublishingFrequency.fromValue(this.findingPublishingFrequency);
    }

    public final String findingPublishingFrequencyAsString() {
        return this.findingPublishingFrequency;
    }

    public final DataSourceConfigurations dataSources() {
        return this.dataSources;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.enable());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingPublishingFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDetectorRequest)) {
            return false;
        }
        CreateDetectorRequest other = (CreateDetectorRequest)((Object)obj);
        return Objects.equals(this.enable(), other.enable()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.findingPublishingFrequencyAsString(), other.findingPublishingFrequencyAsString()) && Objects.equals(this.dataSources(), other.dataSources()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDetectorRequest").add("Enable", (Object)this.enable()).add("ClientToken", (Object)this.clientToken()).add("FindingPublishingFrequency", (Object)this.findingPublishingFrequencyAsString()).add("DataSources", (Object)this.dataSources()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enable": {
                return Optional.ofNullable(clazz.cast(this.enable()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "FindingPublishingFrequency": {
                return Optional.ofNullable(clazz.cast(this.findingPublishingFrequencyAsString()));
            }
            case "DataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDetectorRequest, T> g) {
        return obj -> g.apply((CreateDetectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private Boolean enable;
        private String clientToken;
        private String findingPublishingFrequency;
        private DataSourceConfigurations dataSources;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDetectorRequest model) {
            super(model);
            this.enable(model.enable);
            this.clientToken(model.clientToken);
            this.findingPublishingFrequency(model.findingPublishingFrequency);
            this.dataSources(model.dataSources);
            this.tags(model.tags);
        }

        public final Boolean getEnable() {
            return this.enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getFindingPublishingFrequency() {
            return this.findingPublishingFrequency;
        }

        @Override
        public final Builder findingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
            return this;
        }

        @Override
        public final Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency) {
            this.findingPublishingFrequency(findingPublishingFrequency == null ? null : findingPublishingFrequency.toString());
            return this;
        }

        public final void setFindingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
        }

        public final DataSourceConfigurations.Builder getDataSources() {
            return this.dataSources != null ? this.dataSources.toBuilder() : null;
        }

        @Override
        public final Builder dataSources(DataSourceConfigurations dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final void setDataSources(DataSourceConfigurations.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDetectorRequest build() {
            return new CreateDetectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDetectorRequest> {
        public Builder enable(Boolean var1);

        public Builder clientToken(String var1);

        public Builder findingPublishingFrequency(String var1);

        public Builder findingPublishingFrequency(FindingPublishingFrequency var1);

        public Builder dataSources(DataSourceConfigurations var1);

        default public Builder dataSources(Consumer<DataSourceConfigurations.Builder> dataSources) {
            return this.dataSources((DataSourceConfigurations)((DataSourceConfigurations.Builder)DataSourceConfigurations.builder().applyMutation(dataSources)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

