/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.UsageCriteria;
import software.amazon.awssdk.services.guardduty.model.UsageStatisticType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUsageStatisticsRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, GetUsageStatisticsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(GetUsageStatisticsRequest.getter(GetUsageStatisticsRequest::detectorId)).setter(GetUsageStatisticsRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<String> USAGE_STATISTIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageStatisticType").getter(GetUsageStatisticsRequest.getter(GetUsageStatisticsRequest::usageStatisticTypeAsString)).setter(GetUsageStatisticsRequest.setter(Builder::usageStatisticType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageStatisticsType").build()}).build();
    private static final SdkField<UsageCriteria> USAGE_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UsageCriteria").getter(GetUsageStatisticsRequest.getter(GetUsageStatisticsRequest::usageCriteria)).setter(GetUsageStatisticsRequest.setter(Builder::usageCriteria)).constructor(UsageCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageCriteria").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(GetUsageStatisticsRequest.getter(GetUsageStatisticsRequest::unit)).setter(GetUsageStatisticsRequest.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetUsageStatisticsRequest.getter(GetUsageStatisticsRequest::maxResults)).setter(GetUsageStatisticsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetUsageStatisticsRequest.getter(GetUsageStatisticsRequest::nextToken)).setter(GetUsageStatisticsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, USAGE_STATISTIC_TYPE_FIELD, USAGE_CRITERIA_FIELD, UNIT_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String detectorId;
    private final String usageStatisticType;
    private final UsageCriteria usageCriteria;
    private final String unit;
    private final Integer maxResults;
    private final String nextToken;

    private GetUsageStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.usageStatisticType = builder.usageStatisticType;
        this.usageCriteria = builder.usageCriteria;
        this.unit = builder.unit;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final UsageStatisticType usageStatisticType() {
        return UsageStatisticType.fromValue(this.usageStatisticType);
    }

    public final String usageStatisticTypeAsString() {
        return this.usageStatisticType;
    }

    public final UsageCriteria usageCriteria() {
        return this.usageCriteria;
    }

    public final String unit() {
        return this.unit;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageStatisticTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageStatisticsRequest)) {
            return false;
        }
        GetUsageStatisticsRequest other = (GetUsageStatisticsRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.usageStatisticTypeAsString(), other.usageStatisticTypeAsString()) && Objects.equals(this.usageCriteria(), other.usageCriteria()) && Objects.equals(this.unit(), other.unit()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetUsageStatisticsRequest").add("DetectorId", (Object)this.detectorId()).add("UsageStatisticType", (Object)this.usageStatisticTypeAsString()).add("UsageCriteria", (Object)this.usageCriteria()).add("Unit", (Object)this.unit()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "UsageStatisticType": {
                return Optional.ofNullable(clazz.cast(this.usageStatisticTypeAsString()));
            }
            case "UsageCriteria": {
                return Optional.ofNullable(clazz.cast(this.usageCriteria()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUsageStatisticsRequest, T> g) {
        return obj -> g.apply((GetUsageStatisticsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private String usageStatisticType;
        private UsageCriteria usageCriteria;
        private String unit;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageStatisticsRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.usageStatisticType(model.usageStatisticType);
            this.usageCriteria(model.usageCriteria);
            this.unit(model.unit);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getUsageStatisticType() {
            return this.usageStatisticType;
        }

        @Override
        public final Builder usageStatisticType(String usageStatisticType) {
            this.usageStatisticType = usageStatisticType;
            return this;
        }

        @Override
        public final Builder usageStatisticType(UsageStatisticType usageStatisticType) {
            this.usageStatisticType(usageStatisticType == null ? null : usageStatisticType.toString());
            return this;
        }

        public final void setUsageStatisticType(String usageStatisticType) {
            this.usageStatisticType = usageStatisticType;
        }

        public final UsageCriteria.Builder getUsageCriteria() {
            return this.usageCriteria != null ? this.usageCriteria.toBuilder() : null;
        }

        @Override
        public final Builder usageCriteria(UsageCriteria usageCriteria) {
            this.usageCriteria = usageCriteria;
            return this;
        }

        public final void setUsageCriteria(UsageCriteria.BuilderImpl usageCriteria) {
            this.usageCriteria = usageCriteria != null ? usageCriteria.build() : null;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUsageStatisticsRequest build() {
            return new GetUsageStatisticsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUsageStatisticsRequest> {
        public Builder detectorId(String var1);

        public Builder usageStatisticType(String var1);

        public Builder usageStatisticType(UsageStatisticType var1);

        public Builder usageCriteria(UsageCriteria var1);

        default public Builder usageCriteria(Consumer<UsageCriteria.Builder> usageCriteria) {
            return this.usageCriteria((UsageCriteria)((UsageCriteria.Builder)UsageCriteria.builder().applyMutation(usageCriteria)).build());
        }

        public Builder unit(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

