/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the AWS resource associated with the activity that prompted GuardDuty to generate a
 * finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resource implements SdkPojo, Serializable, ToCopyableBuilder<Resource.Builder, Resource> {
    private static final SdkField<AccessKeyDetails> ACCESS_KEY_DETAILS_FIELD = SdkField
            .<AccessKeyDetails> builder(MarshallingType.SDK_POJO).memberName("AccessKeyDetails")
            .getter(getter(Resource::accessKeyDetails)).setter(setter(Builder::accessKeyDetails))
            .constructor(AccessKeyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyDetails").build()).build();

    private static final SdkField<List<S3BucketDetail>> S3_BUCKET_DETAILS_FIELD = SdkField
            .<List<S3BucketDetail>> builder(MarshallingType.LIST)
            .memberName("S3BucketDetails")
            .getter(getter(Resource::s3BucketDetails))
            .setter(setter(Builder::s3BucketDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3BucketDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3BucketDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceDetails> INSTANCE_DETAILS_FIELD = SdkField
            .<InstanceDetails> builder(MarshallingType.SDK_POJO).memberName("InstanceDetails")
            .getter(getter(Resource::instanceDetails)).setter(setter(Builder::instanceDetails))
            .constructor(InstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceDetails").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(Resource::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_DETAILS_FIELD,
            S3_BUCKET_DETAILS_FIELD, INSTANCE_DETAILS_FIELD, RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final AccessKeyDetails accessKeyDetails;

    private final List<S3BucketDetail> s3BucketDetails;

    private final InstanceDetails instanceDetails;

    private final String resourceType;

    private Resource(BuilderImpl builder) {
        this.accessKeyDetails = builder.accessKeyDetails;
        this.s3BucketDetails = builder.s3BucketDetails;
        this.instanceDetails = builder.instanceDetails;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The IAM access key details (IAM user information) of a user that engaged in the activity that prompted GuardDuty
     * to generate a finding.
     * </p>
     * 
     * @return The IAM access key details (IAM user information) of a user that engaged in the activity that prompted
     *         GuardDuty to generate a finding.
     */
    public final AccessKeyDetails accessKeyDetails() {
        return accessKeyDetails;
    }

    /**
     * Returns true if the S3BucketDetails property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasS3BucketDetails() {
        return s3BucketDetails != null && !(s3BucketDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information on the S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasS3BucketDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains information on the S3 bucket.
     */
    public final List<S3BucketDetail> s3BucketDetails() {
        return s3BucketDetails;
    }

    /**
     * <p>
     * The information about the EC2 instance associated with the activity that prompted GuardDuty to generate a
     * finding.
     * </p>
     * 
     * @return The information about the EC2 instance associated with the activity that prompted GuardDuty to generate a
     *         finding.
     */
    public final InstanceDetails instanceDetails() {
        return instanceDetails;
    }

    /**
     * <p>
     * The type of AWS resource.
     * </p>
     * 
     * @return The type of AWS resource.
     */
    public final String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasS3BucketDetails() ? s3BucketDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource) obj;
        return Objects.equals(accessKeyDetails(), other.accessKeyDetails()) && hasS3BucketDetails() == other.hasS3BucketDetails()
                && Objects.equals(s3BucketDetails(), other.s3BucketDetails())
                && Objects.equals(instanceDetails(), other.instanceDetails())
                && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Resource").add("AccessKeyDetails", accessKeyDetails())
                .add("S3BucketDetails", hasS3BucketDetails() ? s3BucketDetails() : null)
                .add("InstanceDetails", instanceDetails()).add("ResourceType", resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessKeyDetails":
            return Optional.ofNullable(clazz.cast(accessKeyDetails()));
        case "S3BucketDetails":
            return Optional.ofNullable(clazz.cast(s3BucketDetails()));
        case "InstanceDetails":
            return Optional.ofNullable(clazz.cast(instanceDetails()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resource> {
        /**
         * <p>
         * The IAM access key details (IAM user information) of a user that engaged in the activity that prompted
         * GuardDuty to generate a finding.
         * </p>
         * 
         * @param accessKeyDetails
         *        The IAM access key details (IAM user information) of a user that engaged in the activity that prompted
         *        GuardDuty to generate a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyDetails(AccessKeyDetails accessKeyDetails);

        /**
         * <p>
         * The IAM access key details (IAM user information) of a user that engaged in the activity that prompted
         * GuardDuty to generate a finding.
         * </p>
         * This is a convenience that creates an instance of the {@link AccessKeyDetails.Builder} avoiding the need to
         * create one manually via {@link AccessKeyDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessKeyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #accessKeyDetails(AccessKeyDetails)}.
         * 
         * @param accessKeyDetails
         *        a consumer that will call methods on {@link AccessKeyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessKeyDetails(AccessKeyDetails)
         */
        default Builder accessKeyDetails(Consumer<AccessKeyDetails.Builder> accessKeyDetails) {
            return accessKeyDetails(AccessKeyDetails.builder().applyMutation(accessKeyDetails).build());
        }

        /**
         * <p>
         * Contains information on the S3 bucket.
         * </p>
         * 
         * @param s3BucketDetails
         *        Contains information on the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketDetails(Collection<S3BucketDetail> s3BucketDetails);

        /**
         * <p>
         * Contains information on the S3 bucket.
         * </p>
         * 
         * @param s3BucketDetails
         *        Contains information on the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketDetails(S3BucketDetail... s3BucketDetails);

        /**
         * <p>
         * Contains information on the S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link List<S3BucketDetail>.Builder} avoiding the need
         * to create one manually via {@link List<S3BucketDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<S3BucketDetail>.Builder#build()} is called immediately and
         * its result is passed to {@link #s3BucketDetails(List<S3BucketDetail>)}.
         * 
         * @param s3BucketDetails
         *        a consumer that will call methods on {@link List<S3BucketDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BucketDetails(List<S3BucketDetail>)
         */
        Builder s3BucketDetails(Consumer<S3BucketDetail.Builder>... s3BucketDetails);

        /**
         * <p>
         * The information about the EC2 instance associated with the activity that prompted GuardDuty to generate a
         * finding.
         * </p>
         * 
         * @param instanceDetails
         *        The information about the EC2 instance associated with the activity that prompted GuardDuty to
         *        generate a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceDetails(InstanceDetails instanceDetails);

        /**
         * <p>
         * The information about the EC2 instance associated with the activity that prompted GuardDuty to generate a
         * finding.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceDetails.Builder} avoiding the need to
         * create one manually via {@link InstanceDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceDetails(InstanceDetails)}.
         * 
         * @param instanceDetails
         *        a consumer that will call methods on {@link InstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceDetails(InstanceDetails)
         */
        default Builder instanceDetails(Consumer<InstanceDetails.Builder> instanceDetails) {
            return instanceDetails(InstanceDetails.builder().applyMutation(instanceDetails).build());
        }

        /**
         * <p>
         * The type of AWS resource.
         * </p>
         * 
         * @param resourceType
         *        The type of AWS resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl implements Builder {
        private AccessKeyDetails accessKeyDetails;

        private List<S3BucketDetail> s3BucketDetails = DefaultSdkAutoConstructList.getInstance();

        private InstanceDetails instanceDetails;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            accessKeyDetails(model.accessKeyDetails);
            s3BucketDetails(model.s3BucketDetails);
            instanceDetails(model.instanceDetails);
            resourceType(model.resourceType);
        }

        public final AccessKeyDetails.Builder getAccessKeyDetails() {
            return accessKeyDetails != null ? accessKeyDetails.toBuilder() : null;
        }

        @Override
        public final Builder accessKeyDetails(AccessKeyDetails accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails;
            return this;
        }

        public final void setAccessKeyDetails(AccessKeyDetails.BuilderImpl accessKeyDetails) {
            this.accessKeyDetails = accessKeyDetails != null ? accessKeyDetails.build() : null;
        }

        public final List<S3BucketDetail.Builder> getS3BucketDetails() {
            List<S3BucketDetail.Builder> result = S3BucketDetailsCopier.copyToBuilder(this.s3BucketDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder s3BucketDetails(Collection<S3BucketDetail> s3BucketDetails) {
            this.s3BucketDetails = S3BucketDetailsCopier.copy(s3BucketDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3BucketDetails(S3BucketDetail... s3BucketDetails) {
            s3BucketDetails(Arrays.asList(s3BucketDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3BucketDetails(Consumer<S3BucketDetail.Builder>... s3BucketDetails) {
            s3BucketDetails(Stream.of(s3BucketDetails).map(c -> S3BucketDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setS3BucketDetails(Collection<S3BucketDetail.BuilderImpl> s3BucketDetails) {
            this.s3BucketDetails = S3BucketDetailsCopier.copyFromBuilder(s3BucketDetails);
        }

        public final InstanceDetails.Builder getInstanceDetails() {
            return instanceDetails != null ? instanceDetails.toBuilder() : null;
        }

        @Override
        public final Builder instanceDetails(InstanceDetails instanceDetails) {
            this.instanceDetails = instanceDetails;
            return this;
        }

        public final void setInstanceDetails(InstanceDetails.BuilderImpl instanceDetails) {
            this.instanceDetails = instanceDetails != null ? instanceDetails.build() : null;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public Resource build() {
            return new Resource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
