/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on the result of usage based on data source type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageDataSourceResult implements SdkPojo, Serializable,
        ToCopyableBuilder<UsageDataSourceResult.Builder, UsageDataSourceResult> {
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSource").getter(getter(UsageDataSourceResult::dataSourceAsString))
            .setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final SdkField<Total> TOTAL_FIELD = SdkField.<Total> builder(MarshallingType.SDK_POJO).memberName("Total")
            .getter(getter(UsageDataSourceResult::total)).setter(setter(Builder::total)).constructor(Total::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DATA_SOURCE_FIELD, TOTAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataSource;

    private final Total total;

    private UsageDataSourceResult(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.total = builder.total;
    }

    /**
     * <p>
     * The data source type that generated usage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSource} will
     * return {@link DataSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSourceAsString}.
     * </p>
     * 
     * @return The data source type that generated usage.
     * @see DataSource
     */
    public final DataSource dataSource() {
        return DataSource.fromValue(dataSource);
    }

    /**
     * <p>
     * The data source type that generated usage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataSource} will
     * return {@link DataSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataSourceAsString}.
     * </p>
     * 
     * @return The data source type that generated usage.
     * @see DataSource
     */
    public final String dataSourceAsString() {
        return dataSource;
    }

    /**
     * <p>
     * Represents the total of usage for the specified data source.
     * </p>
     * 
     * @return Represents the total of usage for the specified data source.
     */
    public final Total total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageDataSourceResult)) {
            return false;
        }
        UsageDataSourceResult other = (UsageDataSourceResult) obj;
        return Objects.equals(dataSourceAsString(), other.dataSourceAsString()) && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageDataSourceResult").add("DataSource", dataSourceAsString()).add("Total", total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSourceAsString()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageDataSourceResult, T> g) {
        return obj -> g.apply((UsageDataSourceResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageDataSourceResult> {
        /**
         * <p>
         * The data source type that generated usage.
         * </p>
         * 
         * @param dataSource
         *        The data source type that generated usage.
         * @see DataSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSource
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * The data source type that generated usage.
         * </p>
         * 
         * @param dataSource
         *        The data source type that generated usage.
         * @see DataSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSource
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * Represents the total of usage for the specified data source.
         * </p>
         * 
         * @param total
         *        Represents the total of usage for the specified data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Total total);

        /**
         * <p>
         * Represents the total of usage for the specified data source.
         * </p>
         * This is a convenience that creates an instance of the {@link Total.Builder} avoiding the need to create one
         * manually via {@link Total#builder()}.
         *
         * When the {@link Consumer} completes, {@link Total.Builder#build()} is called immediately and its result is
         * passed to {@link #total(Total)}.
         * 
         * @param total
         *        a consumer that will call methods on {@link Total.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #total(Total)
         */
        default Builder total(Consumer<Total.Builder> total) {
            return total(Total.builder().applyMutation(total).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String dataSource;

        private Total total;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageDataSourceResult model) {
            dataSource(model.dataSource);
            total(model.total);
        }

        public final String getDataSource() {
            return dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource(dataSource == null ? null : dataSource.toString());
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final Total.Builder getTotal() {
            return total != null ? total.toBuilder() : null;
        }

        @Override
        public final Builder total(Total total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Total.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public UsageDataSourceResult build() {
            return new UsageDataSourceResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
